/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;

public class EnumFieldSource
extends FieldCacheSource {
    static final Integer DEFAULT_VALUE = -1;
    final Map<Integer, String> enumIntToStringMap;
    final Map<String, Integer> enumStringToIntMap;

    public EnumFieldSource(String field, Map<Integer, String> enumIntToStringMap, Map<String, Integer> enumStringToIntMap) {
        super(field);
        this.enumIntToStringMap = enumIntToStringMap;
        this.enumStringToIntMap = enumStringToIntMap;
    }

    private static Integer tryParseInt(String valueStr) {
        Integer intValue = null;
        try {
            intValue = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    private String intValueToStringValue(Integer intVal) {
        if (intVal == null) {
            return null;
        }
        String enumString = this.enumIntToStringMap.get(intVal);
        if (enumString != null) {
            return enumString;
        }
        return DEFAULT_VALUE.toString();
    }

    private Integer stringValueToIntValue(String stringVal) {
        String enumString;
        if (stringVal == null) {
            return null;
        }
        Integer enumInt = this.enumStringToIntMap.get(stringVal);
        if (enumInt != null) {
            return enumInt;
        }
        Integer intValue = EnumFieldSource.tryParseInt(stringVal);
        if (intValue == null) {
            intValue = DEFAULT_VALUE;
        }
        if ((enumString = this.enumIntToStringMap.get(intValue)) != null) {
            return intValue;
        }
        return DEFAULT_VALUE;
    }

    @Override
    public String description() {
        return "enum(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = DocValues.getNumeric(readerContext.reader(), this.field);
        final Bits valid = DocValues.getDocsWithField(readerContext.reader(), this.field);
        return new IntDocValues(this){
            final MutableValueInt val;
            {
                super(x0);
                this.val = new MutableValueInt();
            }

            @Override
            public int intVal(int doc2) {
                return (int)arr.get(doc2);
            }

            @Override
            public String strVal(int doc2) {
                Integer intValue = this.intVal(doc2);
                return EnumFieldSource.this.intValueToStringValue(intValue);
            }

            @Override
            public boolean exists(int doc2) {
                return valid.get(doc2);
            }

            @Override
            public ValueSourceScorer getRangeScorer(IndexReader reader2, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
                Integer n;
                Integer n2;
                Integer lower = EnumFieldSource.this.stringValueToIntValue(lowerVal);
                Integer upper = EnumFieldSource.this.stringValueToIntValue(upperVal);
                if (lower == null) {
                    lower = Integer.MIN_VALUE;
                } else if (!includeLower && lower < Integer.MAX_VALUE) {
                    n2 = lower;
                    n = lower = Integer.valueOf(lower + 1);
                }
                if (upper == null) {
                    upper = Integer.MAX_VALUE;
                } else if (!includeUpper && upper > Integer.MIN_VALUE) {
                    n2 = upper;
                    n = upper = Integer.valueOf(upper - 1);
                }
                final int ll = lower;
                final int uu = upper;
                return new ValueSourceScorer(reader2, this){

                    @Override
                    public boolean matchesValue(int doc2) {
                        int val2 = this.intVal(doc2);
                        return val2 >= ll && val2 <= uu;
                    }
                };
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc2) {
                        this.mval.value = this.intVal(doc2);
                        this.mval.exists = valid.get(doc2);
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnumFieldSource that = (EnumFieldSource)o;
        if (!this.enumIntToStringMap.equals(that.enumIntToStringMap)) {
            return false;
        }
        return this.enumStringToIntMap.equals(that.enumStringToIntMap);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.enumIntToStringMap.hashCode();
        result = 31 * result + this.enumStringToIntMap.hashCode();
        return result;
    }
}

