/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;

public final class CompositeReaderContext
extends IndexReaderContext {
    private final List<IndexReaderContext> children;
    private final List<LeafReaderContext> leaves;
    private final CompositeReader reader;

    static CompositeReaderContext create(CompositeReader reader2) {
        return new Builder(reader2).build();
    }

    CompositeReaderContext(CompositeReaderContext parent, CompositeReader reader2, int ordInParent, int docbaseInParent, List<IndexReaderContext> children2) {
        this(parent, reader2, ordInParent, docbaseInParent, children2, null);
    }

    CompositeReaderContext(CompositeReader reader2, List<IndexReaderContext> children2, List<LeafReaderContext> leaves) {
        this(null, reader2, 0, 0, children2, leaves);
    }

    private CompositeReaderContext(CompositeReaderContext parent, CompositeReader reader2, int ordInParent, int docbaseInParent, List<IndexReaderContext> children2, List<LeafReaderContext> leaves) {
        super(parent, ordInParent, docbaseInParent);
        this.children = Collections.unmodifiableList(children2);
        this.leaves = leaves == null ? null : Collections.unmodifiableList(leaves);
        this.reader = reader2;
    }

    @Override
    public List<LeafReaderContext> leaves() throws UnsupportedOperationException {
        if (!this.isTopLevel) {
            throw new UnsupportedOperationException("This is not a top-level context.");
        }
        assert (this.leaves != null);
        return this.leaves;
    }

    @Override
    public List<IndexReaderContext> children() {
        return this.children;
    }

    @Override
    public CompositeReader reader() {
        return this.reader;
    }

    private static final class Builder {
        private final CompositeReader reader;
        private final List<LeafReaderContext> leaves = new ArrayList<LeafReaderContext>();
        private int leafDocBase = 0;

        public Builder(CompositeReader reader2) {
            this.reader = reader2;
        }

        public CompositeReaderContext build() {
            return (CompositeReaderContext)this.build(null, this.reader, 0, 0);
        }

        private IndexReaderContext build(CompositeReaderContext parent, IndexReader reader2, int ord, int docBase) {
            if (reader2 instanceof LeafReader) {
                LeafReader ar = (LeafReader)reader2;
                LeafReaderContext atomic = new LeafReaderContext(parent, ar, ord, docBase, this.leaves.size(), this.leafDocBase);
                this.leaves.add(atomic);
                this.leafDocBase += reader2.maxDoc();
                return atomic;
            }
            CompositeReader cr = (CompositeReader)reader2;
            List<? extends IndexReader> sequentialSubReaders = cr.getSequentialSubReaders();
            List<IndexReaderContext> children2 = Arrays.asList(new IndexReaderContext[sequentialSubReaders.size()]);
            CompositeReaderContext newParent = parent == null ? new CompositeReaderContext(cr, children2, this.leaves) : new CompositeReaderContext(parent, cr, ord, docBase, children2);
            int newDocBase = 0;
            int c = sequentialSubReaders.size();
            for (int i = 0; i < c; ++i) {
                IndexReader r = sequentialSubReaders.get(i);
                children2.set(i, this.build(newParent, r, i, newDocBase));
                newDocBase += r.maxDoc();
            }
            assert (newDocBase == cr.maxDoc());
            return newParent;
        }
    }
}

