/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.IOUtils;

public class HunspellStemFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private static final String PARAM_DICTIONARY = "dictionary";
    private static final String PARAM_AFFIX = "affix";
    private static final String PARAM_RECURSION_CAP = "recursionCap";
    private static final String PARAM_IGNORE_CASE = "ignoreCase";
    private static final String PARAM_LONGEST_ONLY = "longestOnly";
    private final String dictionaryFiles;
    private final String affixFile;
    private final boolean ignoreCase;
    private final boolean longestOnly;
    private Dictionary dictionary;

    public HunspellStemFilterFactory(Map<String, String> args) {
        super(args);
        this.dictionaryFiles = this.require(args, PARAM_DICTIONARY);
        this.affixFile = this.get(args, PARAM_AFFIX);
        this.ignoreCase = this.getBoolean(args, PARAM_IGNORE_CASE, false);
        this.longestOnly = this.getBoolean(args, PARAM_LONGEST_ONLY, false);
        this.getBoolean(args, "strictAffixParsing", true);
        this.getInt(args, PARAM_RECURSION_CAP, 0);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader2) throws IOException {
        String[] dicts = this.dictionaryFiles.split(",");
        InputStream affix = null;
        ArrayList<InputStream> dictionaries = new ArrayList<InputStream>();
        try {
            dictionaries = new ArrayList();
            for (String file2 : dicts) {
                dictionaries.add(loader2.openResource(file2));
            }
            affix = loader2.openResource(this.affixFile);
            this.dictionary = new Dictionary(affix, dictionaries, this.ignoreCase);
        }
        catch (ParseException e2) {
            try {
                throw new IOException("Unable to load hunspell data! [dictionary=" + dictionaries + ",affix=" + this.affixFile + "]", e2);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(affix);
                IOUtils.closeWhileHandlingException(dictionaries);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(affix);
        IOUtils.closeWhileHandlingException(dictionaries);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary, true, this.longestOnly);
    }
}

