/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;

public final class NumberUtils {
    public static int stringToInt(String str2) {
        return NumberUtils.stringToInt(str2, 0);
    }

    public static int stringToInt(String str2, int defaultValue) {
        try {
            return Integer.parseInt(str2);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Number createNumber(String val2) throws NumberFormatException {
        String mant;
        String dec2;
        if (val2 == null) {
            return null;
        }
        if (val2.length() == 0) {
            throw new NumberFormatException("\"\" is not a valid number.");
        }
        if (val2.length() == 1 && !Character.isDigit(val2.charAt(0))) {
            throw new NumberFormatException(val2 + " is not a valid number.");
        }
        if (val2.startsWith("--")) {
            return null;
        }
        if (val2.startsWith("0x") || val2.startsWith("-0x")) {
            return NumberUtils.createInteger(val2);
        }
        char lastChar = val2.charAt(val2.length() - 1);
        int decPos = val2.indexOf(46);
        int expPos = val2.indexOf(101) + val2.indexOf(69) + 1;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos) {
                    throw new NumberFormatException(val2 + " is not a valid number.");
                }
                dec2 = val2.substring(decPos + 1, expPos);
            } else {
                dec2 = val2.substring(decPos + 1);
            }
            mant = val2.substring(0, decPos);
        } else {
            mant = expPos > -1 ? val2.substring(0, expPos) : val2;
            dec2 = null;
        }
        if (!Character.isDigit(lastChar)) {
            String exp = expPos > -1 && expPos < val2.length() - 1 ? val2.substring(expPos + 1, val2.length() - 1) : null;
            String numeric = val2.substring(0, val2.length() - 1);
            boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec2 == null && exp == null && (numeric.charAt(0) == '-' && NumberUtils.isDigits(numeric.substring(1)) || NumberUtils.isDigits(numeric))) {
                        try {
                            return NumberUtils.createLong(numeric);
                        }
                        catch (NumberFormatException nfe) {
                            return NumberUtils.createBigInteger(numeric);
                        }
                    }
                    throw new NumberFormatException(val2 + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = NumberUtils.createFloat(numeric);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                            return f;
                        }
                    }
                    catch (NumberFormatException e2) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = NumberUtils.createDouble(numeric);
                        if (!d.isInfinite() && ((double)d.floatValue() != 0.0 || allZeros)) {
                            return d;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(numeric);
                    }
                    catch (NumberFormatException e3) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(val2 + " is not a valid number.");
        }
        String exp = expPos > -1 && expPos < val2.length() - 1 ? val2.substring(expPos + 1, val2.length()) : null;
        if (dec2 == null && exp == null) {
            try {
                return NumberUtils.createInteger(val2);
            }
            catch (NumberFormatException nfe) {
                try {
                    return NumberUtils.createLong(val2);
                }
                catch (NumberFormatException nfe2) {
                    return NumberUtils.createBigInteger(val2);
                }
            }
        }
        boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
        try {
            Float f = NumberUtils.createFloat(val2);
            if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                return f;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            Double d = NumberUtils.createDouble(val2);
            if (!d.isInfinite() && (d != 0.0 || allZeros)) {
                return d;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(val2);
    }

    private static boolean isAllZeros(String s) {
        if (s == null) {
            return true;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '0') continue;
            return false;
        }
        return s.length() > 0;
    }

    public static Float createFloat(String val2) {
        return Float.valueOf(val2);
    }

    public static Double createDouble(String val2) {
        return Double.valueOf(val2);
    }

    public static Integer createInteger(String val2) {
        return Integer.decode(val2);
    }

    public static Long createLong(String val2) {
        return Long.valueOf(val2);
    }

    public static BigInteger createBigInteger(String val2) {
        BigInteger bi = new BigInteger(val2);
        return bi;
    }

    public static BigDecimal createBigDecimal(String val2) {
        BigDecimal bd = new BigDecimal(val2);
        return bd;
    }

    public static long minimum(long a, long b, long c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static int minimum(int a, int b, int c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static long maximum(long a, long b, long c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static int maximum(int a, int b, int c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static int compare(double lhs, double rhs) {
        long rhsBits;
        if (lhs < rhs) {
            return -1;
        }
        if (lhs > rhs) {
            return 1;
        }
        long lhsBits = Double.doubleToLongBits(lhs);
        if (lhsBits == (rhsBits = Double.doubleToLongBits(rhs))) {
            return 0;
        }
        if (lhsBits < rhsBits) {
            return -1;
        }
        return 1;
    }

    public static int compare(float lhs, float rhs) {
        int rhsBits;
        if (lhs < rhs) {
            return -1;
        }
        if (lhs > rhs) {
            return 1;
        }
        int lhsBits = Float.floatToIntBits(lhs);
        if (lhsBits == (rhsBits = Float.floatToIntBits(rhs))) {
            return 0;
        }
        if (lhsBits < rhsBits) {
            return -1;
        }
        return 1;
    }

    public static boolean isDigits(String str2) {
        if (str2 == null || str2.length() == 0) {
            return false;
        }
        for (int i = 0; i < str2.length(); ++i) {
            if (Character.isDigit(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str2) {
        int i;
        int start;
        if (StringUtils.isEmpty(str2)) {
            return false;
        }
        char[] chars2 = str2.toCharArray();
        int sz = chars2.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars2[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars2[start] == '0' && chars2[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars2.length) {
                if (!(chars2[i2] >= '0' && chars2[i2] <= '9' || chars2[i2] >= 'a' && chars2[i2] <= 'f' || chars2[i2] >= 'A' && chars2[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars2[i] >= '0' && chars2[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars2[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars2[i] == 'e' || chars2[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars2[i] == '+' || chars2[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars2.length) {
            if (chars2[i] >= '0' && chars2[i] <= '9') {
                return true;
            }
            if (chars2[i] == 'e' || chars2[i] == 'E') {
                return false;
            }
            if (!(allowSigns || chars2[i] != 'd' && chars2[i] != 'D' && chars2[i] != 'f' && chars2[i] != 'F')) {
                return foundDigit;
            }
            if (chars2[i] == 'l' || chars2[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }
}

