/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.util;

import com.spatial4j.core.distance.DistanceUtils;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.vocabulary.GEOF;

public final class GeoUnits {
    private GeoUnits() {
    }

    public static final double toMiles(double distance, URI units) {
        double miles;
        if (GEOF.UOM_METRE.equals(units)) {
            miles = 0.621371192 * distance / 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            miles = DistanceUtils.degrees2Dist(distance, 3958.7613145272735);
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            miles = DistanceUtils.radians2Dist(distance, 3958.7613145272735);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            miles = distance * Math.PI * 3958.7613145272735;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + units);
        }
        return miles;
    }

    public static final double fromMiles(double miles, URI units) {
        double dist;
        if (GEOF.UOM_METRE.equals(units)) {
            dist = 1.6093440006146922 * miles * 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            dist = DistanceUtils.dist2Degrees(miles, 3958.7613145272735);
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            dist = DistanceUtils.dist2Radians(miles, 3958.7613145272735);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            dist = miles / 12436.815463034354;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + units);
        }
        return dist;
    }

    public static final double toKilometres(double distance, URI units) {
        double kms;
        if (GEOF.UOM_METRE.equals(units)) {
            kms = distance / 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            kms = DistanceUtils.degrees2Dist(distance, 6371.0087714);
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            kms = DistanceUtils.radians2Dist(distance, 6371.0087714);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            kms = distance * Math.PI * 6371.0087714;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + units);
        }
        return kms;
    }

    public static final double fromKilometres(double kms, URI units) {
        double dist;
        if (GEOF.UOM_METRE.equals(units)) {
            dist = kms * 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            dist = DistanceUtils.dist2Degrees(kms, 6371.0087714);
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            dist = DistanceUtils.dist2Radians(kms, 6371.0087714);
        } else if (GEOF.UOM_UNITY.equals(units)) {
            dist = kms / 20015.114352186374;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + units);
        }
        return dist;
    }

    public static final double toDegrees(double distance, URI units) {
        double degs;
        if (GEOF.UOM_METRE.equals(units)) {
            degs = DistanceUtils.dist2Degrees(distance / 1000.0, 6371.0087714);
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            degs = distance;
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            degs = 57.29577951308232 * distance;
        } else if (GEOF.UOM_UNITY.equals(units)) {
            degs = distance * 180.0;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + units);
        }
        return degs;
    }

    public static final double fromDegrees(double degs, URI units) {
        double dist;
        if (GEOF.UOM_METRE.equals(units)) {
            dist = DistanceUtils.degrees2Dist(degs, 6371.0087714) * 1000.0;
        } else if (GEOF.UOM_DEGREE.equals(units)) {
            dist = degs;
        } else if (GEOF.UOM_RADIAN.equals(units)) {
            dist = Math.PI / 180 * degs;
        } else if (GEOF.UOM_UNITY.equals(units)) {
            dist = degs / 180.0;
        } else {
            throw new IllegalArgumentException("Unsupported units: " + units);
        }
        return dist;
    }
}

