/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternCollector;

public class ConstructorBuilder {
    public TupleExpr buildConstructor(TupleExpr bodyExpr, TupleExpr constructExpr, boolean distinct2, boolean reduced2) {
        return this.buildConstructor(bodyExpr, constructExpr, true, distinct2, reduced2);
    }

    public TupleExpr buildConstructor(TupleExpr bodyExpr, boolean distinct2, boolean reduced2) throws MalformedQueryException {
        BasicPatternVerifier verifier = new BasicPatternVerifier();
        bodyExpr.visit(verifier);
        if (!verifier.isBasicPattern()) {
            throw new MalformedQueryException("can not use shorthand CONSTRUCT: graph pattern in WHERE clause is not a basic pattern.");
        }
        return this.buildConstructor(bodyExpr, bodyExpr, false, distinct2, reduced2);
    }

    private TupleExpr buildConstructor(TupleExpr bodyExpr, TupleExpr constructExpr, boolean explicitConstructor, boolean distinct2, boolean reduced2) {
        TupleExpr result = bodyExpr;
        List<StatementPattern> statementPatterns = StatementPatternCollector.process(constructExpr);
        Set<Var> constructVars = this.getConstructVars(statementPatterns);
        if (distinct2 || reduced2) {
            ProjectionElemList projElemList = new ProjectionElemList();
            for (Var var : constructVars) {
                if (var.isAnonymous() || var.hasValue()) continue;
                projElemList.addElement(new ProjectionElem(var.getName()));
            }
            result = new Projection(result, projElemList);
            result = distinct2 ? new Distinct(result) : new Reduced(result);
        }
        HashMap<Var, ExtensionElem> extElemMap = new HashMap<Var, ExtensionElem>();
        for (Var var : constructVars) {
            if (!var.isAnonymous() || extElemMap.containsKey(var)) continue;
            AbstractQueryModelNode valueExpr = null;
            if (var.hasValue()) {
                valueExpr = new ValueConstant(var.getValue());
            } else if (explicitConstructor) {
                valueExpr = new BNodeGenerator();
            }
            if (valueExpr == null) continue;
            extElemMap.put(var, new ExtensionElem((ValueExpr)((Object)valueExpr), var.getName()));
        }
        if (!extElemMap.isEmpty()) {
            result = new Extension(result, extElemMap.values());
        }
        ArrayList<ProjectionElemList> projections = new ArrayList<ProjectionElemList>();
        for (StatementPattern sp : statementPatterns) {
            ProjectionElemList projElemList = new ProjectionElemList();
            projElemList.addElement(new ProjectionElem(sp.getSubjectVar().getName(), "subject"));
            projElemList.addElement(new ProjectionElem(sp.getPredicateVar().getName(), "predicate"));
            projElemList.addElement(new ProjectionElem(sp.getObjectVar().getName(), "object"));
            projections.add(projElemList);
        }
        if (projections.size() == 1) {
            result = new Projection(result, (ProjectionElemList)projections.get(0));
        } else if (projections.size() > 1) {
            result = new MultiProjection(result, projections);
            if (distinct2) {
                result = new Distinct(result);
            } else if (reduced2) {
                result = new Reduced(result);
            }
        } else {
            result = new EmptySet();
        }
        return result;
    }

    private Set<Var> getConstructVars(Collection<StatementPattern> statementPatterns) {
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>(statementPatterns.size() * 2);
        for (StatementPattern sp : statementPatterns) {
            vars.add(sp.getSubjectVar());
            vars.add(sp.getPredicateVar());
            vars.add(sp.getObjectVar());
        }
        return vars;
    }

    private class BasicPatternVerifier
    extends AbstractQueryModelVisitor<RuntimeException> {
        private boolean basicPattern = true;

        private BasicPatternVerifier() {
        }

        public boolean isBasicPattern() {
            return this.basicPattern;
        }

        @Override
        public void meet(LeftJoin node2) {
            this.basicPattern = false;
        }

        @Override
        public void meet(Filter node2) {
            this.basicPattern = false;
        }

        @Override
        public void meet(Extension node2) {
            this.basicPattern = false;
        }

        @Override
        public void meet(Projection node2) {
            this.basicPattern = false;
        }

        @Override
        public void meet(Union node2) {
            this.basicPattern = false;
        }

        @Override
        public void meet(StatementPattern node2) {
            if (!StatementPattern.Scope.DEFAULT_CONTEXTS.equals((Object)node2.getScope())) {
                this.basicPattern = false;
            } else if (node2.getContextVar() != null) {
                this.basicPattern = false;
            } else {
                super.meet(node2);
            }
        }
    }
}

