/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class OrderLimitOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new OrderOptimizer());
    }

    protected static class OrderOptimizer
    extends AbstractQueryModelVisitor<RuntimeException> {
        private boolean variablesProjected = true;
        private Projection projection;

        protected OrderOptimizer() {
        }

        @Override
        public void meet(Projection node2) {
            this.projection = node2;
            node2.getArg().visit(this);
            this.projection = null;
        }

        @Override
        public void meet(Order node2) {
            QueryModelNode parent;
            for (OrderElem e2 : node2.getElements()) {
                e2.visit(this);
            }
            if (this.variablesProjected && this.projection == (parent = node2.getParentNode())) {
                node2.replaceWith(node2.getArg().clone());
                node2.setArg(this.projection.clone());
                Order replacement = node2.clone();
                this.projection.replaceWith(replacement);
                QueryModelNode distinct2 = replacement.getParentNode();
                if (distinct2 instanceof Distinct) {
                    distinct2.replaceWith(new Reduced(replacement.clone()));
                }
            }
        }

        @Override
        public void meet(Var node2) {
            if (this.projection != null) {
                boolean projected = false;
                for (ProjectionElem e2 : this.projection.getProjectionElemList().getElements()) {
                    String source2 = e2.getSourceName();
                    String target = e2.getTargetName();
                    if (!node2.getName().equals(source2) || !node2.getName().equals(target)) continue;
                    projected = true;
                    break;
                }
                if (!projected) {
                    this.variablesProjected = false;
                }
            }
        }
    }
}

