/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.lucene.spin;

import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSpinSailConnection
extends NotifyingSailConnectionWrapper {
    private SearchIndex idx;
    private ValueFactory vf;
    private static final Logger LOG = LoggerFactory.getLogger(LuceneSpinSailConnection.class);

    public LuceneSpinSailConnection(NotifyingSailConnection wrappedCon, ValueFactory vf, SearchIndex si) {
        super(wrappedCon);
        this.vf = vf;
        this.idx = si;
    }

    @Override
    public void clear(Resource ... contexts) throws SailException {
        super.clear(contexts);
        try {
            this.idx.clearContexts(contexts);
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
    }

    @Override
    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        super.removeStatements(subj, pred, obj, contexts);
        for (Resource graph : contexts) {
            Statement st = this.vf.createStatement(subj, pred, obj, graph);
            try {
                this.idx.removeStatement(st);
            }
            catch (IOException e2) {
                LOG.error("Error during processing statement: {}", (Object)st.toString());
                throw new SailException(e2);
            }
        }
    }

    @Override
    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        super.addStatement(subj, pred, obj, contexts);
        if (contexts.length == 0) {
            Statement st = this.vf.createStatement(subj, pred, obj);
            try {
                this.idx.addStatement(st);
            }
            catch (IOException e2) {
                LOG.error("Error during processing statement: {}", (Object)st.toString());
                throw new SailException(e2);
            }
        } else {
            for (Resource graph : contexts) {
                Statement st = this.vf.createStatement(subj, pred, obj, graph);
                try {
                    this.idx.addStatement(st);
                    LOG.debug("add statement: {}", (Object)st.toString());
                }
                catch (IOException e3) {
                    LOG.error("Error during processing statement: {}", (Object)st.toString());
                    throw new SailException(e3);
                }
            }
        }
    }

    @Override
    public void begin() throws SailException {
        super.begin();
        try {
            this.idx.begin();
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
    }

    @Override
    public void close() throws SailException {
        try {
            this.idx.endReading();
        }
        catch (IOException e2) {
            LOG.warn("LuceneIndex or SearchIndex is not closed properly");
        }
        super.close();
    }

    @Override
    public void commit() throws SailException {
        try {
            this.idx.commit();
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
        super.commit();
    }

    @Override
    public void rollback() throws SailException {
        try {
            this.idx.rollback();
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
        super.rollback();
    }
}

