/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.SuppressForbidden;

@SuppressForbidden(reason="java.io.File: RAFDirectory is legacy API")
public class RAFDirectory
extends FSDirectory {
    public RAFDirectory(Path path2, LockFactory lockFactory) throws IOException {
        super(path2, lockFactory);
        path2.toFile();
    }

    public RAFDirectory(Path path2) throws IOException {
        this(path2, FSLockFactory.getDefault());
    }

    @Override
    public IndexInput openInput(String name2, IOContext context) throws IOException {
        this.ensureOpen();
        File path2 = this.directory.resolve(name2).toFile();
        RandomAccessFile raf = new RandomAccessFile(path2, "r");
        return new RAFIndexInput("SimpleFSIndexInput(path=\"" + path2.getPath() + "\")", raf, context);
    }

    @SuppressForbidden(reason="java.io.File: RAFDirectory is legacy API")
    static final class RAFIndexInput
    extends BufferedIndexInput {
        private static final int CHUNK_SIZE = 8192;
        protected final RandomAccessFile file;
        boolean isClone = false;
        protected final long off;
        protected final long end;

        public RAFIndexInput(String resourceDesc, RandomAccessFile file2, IOContext context) throws IOException {
            super(resourceDesc, context);
            this.file = file2;
            this.off = 0L;
            this.end = file2.length();
        }

        public RAFIndexInput(String resourceDesc, RandomAccessFile file2, long off, long length, int bufferSize) {
            super(resourceDesc, bufferSize);
            this.file = file2;
            this.off = off;
            this.end = off + length;
            this.isClone = true;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        @Override
        public RAFIndexInput clone() {
            RAFIndexInput clone = (RAFIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        @Override
        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            if (offset < 0L || length < 0L || offset + length > this.length()) {
                throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: " + this);
            }
            return new RAFIndexInput(sliceDescription, this.file, this.off + offset, length, this.getBufferSize());
        }

        @Override
        public final long length() {
            return this.end - this.off;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            RandomAccessFile randomAccessFile = this.file;
            synchronized (randomAccessFile) {
                long position = this.off + this.getFilePointer();
                this.file.seek(position);
                if (position + (long)len > this.end) {
                    throw new EOFException("read past EOF: " + this);
                }
                try {
                    int total;
                    int i;
                    for (total = 0; total < len; total += i) {
                        int toRead = Math.min(8192, len - total);
                        i = this.file.read(b, offset + total, toRead);
                        if (i < 0) {
                            throw new EOFException("read past EOF: " + this + " off: " + offset + " len: " + len + " total: " + total + " chunkLen: " + toRead + " end: " + this.end);
                        }
                        assert (i > 0) : "RandomAccessFile.read with non zero-length toRead must always read at least one byte";
                    }
                    assert (total == len);
                }
                catch (IOException ioe) {
                    throw new IOException(ioe.getMessage() + ": " + this, ioe);
                }
            }
        }

        @Override
        protected void seekInternal(long position) {
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }
    }
}

