/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitDocIdSetFilter;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;

public class ToParentBlockJoinQuery
extends Query {
    private final BitDocIdSetFilter parentsFilter;
    private final Query childQuery;
    private final Query origChildQuery;
    private final ScoreMode scoreMode;

    public ToParentBlockJoinQuery(Query childQuery, BitDocIdSetFilter parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = childQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    private ToParentBlockJoinQuery(Query origChildQuery, Query childQuery, BitDocIdSetFilter parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = origChildQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new BlockJoinWeight(this, this.childQuery.createWeight(searcher, needsScores), this.parentsFilter, this.scoreMode);
    }

    public Query getChildQuery() {
        return this.childQuery;
    }

    @Override
    public Query rewrite(IndexReader reader2) throws IOException {
        Query childRewrite = this.childQuery.rewrite(reader2);
        if (childRewrite != this.childQuery) {
            ToParentBlockJoinQuery rewritten = new ToParentBlockJoinQuery(this.origChildQuery, childRewrite, this.parentsFilter, this.scoreMode);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    @Override
    public String toString(String field) {
        return "ToParentBlockJoinQuery (" + this.childQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object _other) {
        if (_other instanceof ToParentBlockJoinQuery) {
            ToParentBlockJoinQuery other = (ToParentBlockJoinQuery)_other;
            return this.origChildQuery.equals(other.origChildQuery) && this.parentsFilter.equals(other.parentsFilter) && this.scoreMode == other.scoreMode && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash2 = super.hashCode();
        hash2 = 31 * hash2 + this.origChildQuery.hashCode();
        hash2 = 31 * hash2 + this.scoreMode.hashCode();
        hash2 = 31 * hash2 + this.parentsFilter.hashCode();
        return hash2;
    }

    static class BlockJoinScorer
    extends Scorer {
        private final Scorer childScorer;
        private final BitSet parentBits;
        private final ScoreMode scoreMode;
        private final Bits acceptDocs;
        private int parentDoc = -1;
        private int prevParentDoc;
        private float parentScore;
        private int parentFreq;
        private int nextChildDoc;
        private int[] pendingChildDocs;
        private float[] pendingChildScores;
        private int childDocUpto;

        public BlockJoinScorer(Weight weight, Scorer childScorer, BitSet parentBits, int firstChildDoc, ScoreMode scoreMode, Bits acceptDocs) {
            super(weight);
            this.parentBits = parentBits;
            this.childScorer = childScorer;
            this.scoreMode = scoreMode;
            this.acceptDocs = acceptDocs;
            this.nextChildDoc = firstChildDoc;
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.childScorer, "BLOCK_JOIN"));
        }

        int getChildCount() {
            return this.childDocUpto;
        }

        int getParentDoc() {
            return this.parentDoc;
        }

        int[] swapChildDocs(int[] other) {
            int[] ret = this.pendingChildDocs;
            this.pendingChildDocs = other == null ? new int[5] : other;
            return ret;
        }

        float[] swapChildScores(float[] other) {
            if (this.scoreMode == ScoreMode.None) {
                throw new IllegalStateException("ScoreMode is None; you must pass trackScores=false to ToParentBlockJoinCollector");
            }
            float[] ret = this.pendingChildScores;
            this.pendingChildScores = other == null ? new float[5] : other;
            return ret;
        }

        @Override
        public int nextDoc() throws IOException {
            block18: {
                do {
                    if (this.nextChildDoc == Integer.MAX_VALUE) {
                        this.parentDoc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.parentDoc = this.parentBits.nextSetBit(this.nextChildDoc);
                    if (this.nextChildDoc == this.parentDoc) {
                        throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + this.nextChildDoc + " matched childScorer=" + this.childScorer.getClass());
                    }
                    assert (this.parentDoc != Integer.MAX_VALUE);
                    if (this.acceptDocs == null || this.acceptDocs.get(this.parentDoc)) break block18;
                    do {
                        this.nextChildDoc = this.childScorer.nextDoc();
                    } while (this.nextChildDoc < this.parentDoc);
                } while (this.nextChildDoc != this.parentDoc);
                throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + this.nextChildDoc + " matched childScorer=" + this.childScorer.getClass());
            }
            float totalScore = 0.0f;
            float maxScore = Float.NEGATIVE_INFINITY;
            float minScore = Float.POSITIVE_INFINITY;
            this.childDocUpto = 0;
            this.parentFreq = 0;
            do {
                if (this.pendingChildDocs != null && this.pendingChildDocs.length == this.childDocUpto) {
                    this.pendingChildDocs = ArrayUtil.grow(this.pendingChildDocs);
                }
                if (this.pendingChildScores != null && this.scoreMode != ScoreMode.None && this.pendingChildScores.length == this.childDocUpto) {
                    this.pendingChildScores = ArrayUtil.grow(this.pendingChildScores);
                }
                if (this.pendingChildDocs != null) {
                    this.pendingChildDocs[this.childDocUpto] = this.nextChildDoc;
                }
                if (this.scoreMode != ScoreMode.None) {
                    float childScore = this.childScorer.score();
                    int childFreq = this.childScorer.freq();
                    if (this.pendingChildScores != null) {
                        this.pendingChildScores[this.childDocUpto] = childScore;
                    }
                    maxScore = Math.max(childScore, maxScore);
                    minScore = Math.min((float)childFreq, minScore);
                    totalScore += childScore;
                    this.parentFreq += childFreq;
                }
                ++this.childDocUpto;
                this.nextChildDoc = this.childScorer.nextDoc();
            } while (this.nextChildDoc < this.parentDoc);
            if (this.nextChildDoc == this.parentDoc) {
                throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + this.nextChildDoc + " matched childScorer=" + this.childScorer.getClass());
            }
            switch (this.scoreMode) {
                case Avg: {
                    this.parentScore = totalScore / (float)this.childDocUpto;
                    break;
                }
                case Max: {
                    this.parentScore = maxScore;
                    break;
                }
                case Min: {
                    this.parentScore = minScore;
                    break;
                }
                case Total: {
                    this.parentScore = totalScore;
                    break;
                }
            }
            return this.parentDoc;
        }

        @Override
        public int docID() {
            return this.parentDoc;
        }

        @Override
        public float score() throws IOException {
            return this.parentScore;
        }

        @Override
        public int freq() {
            return this.parentFreq;
        }

        @Override
        public int advance(int parentTarget) throws IOException {
            if (parentTarget == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (parentTarget == 0) {
                return this.nextDoc();
            }
            this.prevParentDoc = this.parentBits.prevSetBit(parentTarget - 1);
            assert (this.prevParentDoc >= this.parentDoc);
            if (this.prevParentDoc > this.nextChildDoc) {
                this.nextChildDoc = this.childScorer.advance(this.prevParentDoc);
            }
            if (this.nextChildDoc == this.prevParentDoc) {
                throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + this.nextChildDoc + " matched childScorer=" + this.childScorer.getClass());
            }
            int nd = this.nextDoc();
            return nd;
        }

        public Explanation explain(int docBase) throws IOException {
            int start = docBase + this.prevParentDoc + 1;
            int end = docBase + this.parentDoc - 1;
            return Explanation.match(this.score(), String.format(Locale.ROOT, "Score based on child doc range from %d to %d", start, end), new Explanation[0]);
        }

        @Override
        public long cost() {
            return this.childScorer.cost();
        }

        public void trackPendingChildHits() {
            this.pendingChildDocs = new int[5];
            if (this.scoreMode != ScoreMode.None) {
                this.pendingChildScores = new float[5];
            }
        }
    }

    private static class BlockJoinWeight
    extends Weight {
        private final Query joinQuery;
        private final Weight childWeight;
        private final BitDocIdSetFilter parentsFilter;
        private final ScoreMode scoreMode;

        public BlockJoinWeight(Query joinQuery, Weight childWeight, BitDocIdSetFilter parentsFilter, ScoreMode scoreMode) {
            super(joinQuery);
            this.joinQuery = joinQuery;
            this.childWeight = childWeight;
            this.parentsFilter = parentsFilter;
            this.scoreMode = scoreMode;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.childWeight.getValueForNormalization() * this.joinQuery.getBoost() * this.joinQuery.getBoost();
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.childWeight.normalize(norm, topLevelBoost * this.joinQuery.getBoost());
        }

        @Override
        public Scorer scorer(LeafReaderContext readerContext, Bits acceptDocs) throws IOException {
            Scorer childScorer = this.childWeight.scorer(readerContext, readerContext.reader().getLiveDocs());
            if (childScorer == null) {
                return null;
            }
            int firstChildDoc = childScorer.nextDoc();
            if (firstChildDoc == Integer.MAX_VALUE) {
                return null;
            }
            BitDocIdSet parents2 = this.parentsFilter.getDocIdSet(readerContext);
            if (parents2 == null) {
                return null;
            }
            return new BlockJoinScorer(this, childScorer, parents2.bits(), firstChildDoc, this.scoreMode, acceptDocs);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc2) throws IOException {
            BlockJoinScorer scorer = (BlockJoinScorer)this.scorer(context, context.reader().getLiveDocs());
            if (scorer != null && scorer.advance(doc2) == doc2) {
                return scorer.explain(context.docBase);
            }
            return Explanation.noMatch("Not a match", new Explanation[0]);
        }
    }
}

