/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;

public class NumericRangeQueryBuilder
implements QueryBuilder {
    @Override
    public Query getQuery(Element e2) throws ParserException {
        String field = DOMUtils.getAttributeWithInheritanceOrFail(e2, "fieldName");
        String lowerTerm = DOMUtils.getAttributeOrFail(e2, "lowerTerm");
        String upperTerm = DOMUtils.getAttributeOrFail(e2, "upperTerm");
        boolean lowerInclusive = DOMUtils.getAttribute(e2, "includeLower", true);
        boolean upperInclusive = DOMUtils.getAttribute(e2, "includeUpper", true);
        int precisionStep = DOMUtils.getAttribute(e2, "precisionStep", 16);
        String type2 = DOMUtils.getAttribute(e2, "type", "int");
        try {
            NumericRangeQuery<Number> filter2;
            if (type2.equalsIgnoreCase("int")) {
                filter2 = NumericRangeQuery.newIntRange(field, precisionStep, Integer.valueOf(lowerTerm), Integer.valueOf(upperTerm), lowerInclusive, upperInclusive);
            } else if (type2.equalsIgnoreCase("long")) {
                filter2 = NumericRangeQuery.newLongRange(field, precisionStep, Long.valueOf(lowerTerm), Long.valueOf(upperTerm), lowerInclusive, upperInclusive);
            } else if (type2.equalsIgnoreCase("double")) {
                filter2 = NumericRangeQuery.newDoubleRange(field, precisionStep, Double.valueOf(lowerTerm), Double.valueOf(upperTerm), lowerInclusive, upperInclusive);
            } else if (type2.equalsIgnoreCase("float")) {
                filter2 = NumericRangeQuery.newFloatRange(field, precisionStep, Float.valueOf(lowerTerm), Float.valueOf(upperTerm), lowerInclusive, upperInclusive);
            } else {
                throw new ParserException("type attribute must be one of: [long, int, double, float]");
            }
            return filter2;
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("Could not parse lowerTerm or upperTerm into a number", nfe);
        }
    }
}

