/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.surround.query.SimpleTerm;
import org.apache.lucene.util.BytesRef;

public class SrndTermQuery
extends SimpleTerm {
    private final String termText;

    public SrndTermQuery(String termText, boolean quoted) {
        super(quoted);
        this.termText = termText;
    }

    public String getTermText() {
        return this.termText;
    }

    public Term getLuceneTerm(String fieldName) {
        return new Term(fieldName, this.getTermText());
    }

    @Override
    public String toStringUnquoted() {
        return this.getTermText();
    }

    @Override
    public void visitMatchingTerms(IndexReader reader2, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        TermsEnum termsEnum;
        TermsEnum.SeekStatus status;
        Terms terms = MultiFields.getTerms(reader2, fieldName);
        if (terms != null && (status = (termsEnum = terms.iterator()).seekCeil(new BytesRef(this.getTermText()))) == TermsEnum.SeekStatus.FOUND) {
            mtv.visitMatchingTerm(this.getLuceneTerm(fieldName));
        }
    }
}

