/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.docvalues;

import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueBool;

public abstract class BoolDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public BoolDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public abstract boolean boolVal(int var1);

    @Override
    public byte byteVal(int doc2) {
        return this.boolVal(doc2) ? (byte)1 : 0;
    }

    @Override
    public short shortVal(int doc2) {
        return this.boolVal(doc2) ? (short)1 : 0;
    }

    @Override
    public float floatVal(int doc2) {
        return this.boolVal(doc2) ? 1.0f : 0.0f;
    }

    @Override
    public int intVal(int doc2) {
        return this.boolVal(doc2) ? 1 : 0;
    }

    @Override
    public long longVal(int doc2) {
        return this.boolVal(doc2) ? 1L : 0L;
    }

    @Override
    public double doubleVal(int doc2) {
        return this.boolVal(doc2) ? 1.0 : 0.0;
    }

    @Override
    public String strVal(int doc2) {
        return Boolean.toString(this.boolVal(doc2));
    }

    @Override
    public Object objectVal(int doc2) {
        return this.exists(doc2) ? Boolean.valueOf(this.boolVal(doc2)) : null;
    }

    @Override
    public String toString(int doc2) {
        return this.vs.description() + '=' + this.strVal(doc2);
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueBool mval = new MutableValueBool();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc2) {
                this.mval.value = BoolDocValues.this.boolVal(doc2);
                this.mval.exists = BoolDocValues.this.exists(doc2);
            }
        };
    }
}

