/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.AbortingException;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeRateLimiter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TwoPhaseCommit;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.RateLimitedIndexOutput;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.Version;

public class IndexWriter
implements Closeable,
TwoPhaseCommit,
Accountable {
    public static final int MAX_DOCS = 0x7FFFFF7F;
    public static final int MAX_POSITION = 0x7FFFFF7F;
    private static int actualMaxDocs = 0x7FFFFF7F;
    boolean enableTestPoints;
    private static final int UNBOUNDED_MAX_MERGE_SEGMENTS = -1;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String SOURCE = "source";
    public static final String SOURCE_MERGE = "merge";
    public static final String SOURCE_FLUSH = "flush";
    public static final String SOURCE_ADDINDEXES_READERS = "addIndexes(CodecReader...)";
    public static final int MAX_TERM_LENGTH = 32766;
    volatile Throwable tragedy;
    private final Directory directory;
    private final Directory mergeDirectory;
    private final Analyzer analyzer;
    private final AtomicLong changeCount;
    private volatile long lastCommitChangeCount;
    private List<SegmentCommitInfo> rollbackSegments;
    volatile SegmentInfos pendingCommit;
    volatile long pendingCommitChangeCount;
    private Collection<String> filesToCommit;
    final SegmentInfos segmentInfos;
    final FieldInfos.FieldNumbers globalFieldNumberMap;
    private final DocumentsWriter docWriter;
    private final Queue<Event> eventQueue;
    final IndexFileDeleter deleter;
    private Map<SegmentCommitInfo, Boolean> segmentsToMerge;
    private int mergeMaxNumSegments;
    private Lock writeLock;
    private volatile boolean closed;
    private volatile boolean closing;
    private HashSet<SegmentCommitInfo> mergingSegments;
    private final MergeScheduler mergeScheduler;
    private LinkedList<MergePolicy.OneMerge> pendingMerges;
    private Set<MergePolicy.OneMerge> runningMerges;
    private List<MergePolicy.OneMerge> mergeExceptions;
    private long mergeGen;
    private boolean stopMerges;
    private boolean didMessageState;
    final AtomicInteger flushCount;
    final AtomicInteger flushDeletesCount;
    final ReaderPool readerPool;
    final BufferedUpdatesStream bufferedUpdatesStream;
    private volatile boolean poolReaders;
    private final LiveIndexWriterConfig config;
    private long startCommitTime;
    final AtomicLong pendingNumDocs;
    final CloseableThreadLocal<MergeRateLimiter> rateLimiters;
    final Codec codec;
    final InfoStream infoStream;
    private final Object commitLock;
    private final Object fullFlushLock;
    private boolean keepFullyDeletedSegments;

    static void setMaxDocs(int maxDocs) {
        if (maxDocs > 0x7FFFFF7F) {
            throw new IllegalArgumentException("maxDocs must be <= IndexWriter.MAX_DOCS=2147483519; got: " + maxDocs);
        }
        actualMaxDocs = maxDocs;
    }

    static int getActualMaxDocs() {
        return actualMaxDocs;
    }

    DirectoryReader getReader() throws IOException {
        return this.getReader(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectoryReader getReader(boolean applyAllDeletes) throws IOException {
        this.ensureOpen();
        long tStart = System.currentTimeMillis();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "flush at getReader");
        }
        this.poolReaders = true;
        DirectoryReader r = null;
        this.doBeforeFlush();
        boolean anyChanges = false;
        boolean success2 = false;
        try {
            boolean success = false;
            Object object = this.fullFlushLock;
            synchronized (object) {
                try {
                    anyChanges = this.docWriter.flushAllThreads();
                    if (!anyChanges) {
                        this.flushCount.incrementAndGet();
                    }
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        anyChanges |= this.maybeApplyDeletes(applyAllDeletes);
                        r = StandardDirectoryReader.open(this, this.segmentInfos, applyAllDeletes);
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "return reader version=" + r.getVersion() + " reader=" + r);
                        }
                    }
                    success = true;
                }
                finally {
                    this.docWriter.finishFullFlush(this, success);
                    if (success) {
                        this.processEvents(false, true);
                        this.doAfterFlush();
                    } else if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "hit exception during NRT reader");
                    }
                }
            }
            if (anyChanges) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "getReader took " + (System.currentTimeMillis() - tStart) + " msec");
            }
            if (success2 = true) return r;
        }
        catch (OutOfMemoryError | AbortingException tragedy) {
            DirectoryReader directoryReader;
            try {
                this.tragicEvent(tragedy, "getReader");
                directoryReader = null;
                if (success2) return directoryReader;
            }
            catch (Throwable throwable) {
                if (success2) throw throwable;
                IOUtils.closeWhileHandlingException(r);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(r);
            return directoryReader;
        }
        IOUtils.closeWhileHandlingException(r);
        return r;
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.docWriter.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public int numDeletedDocs(SegmentCommitInfo info2) {
        this.ensureOpen(false);
        int delCount = info2.getDelCount();
        ReadersAndUpdates rld = this.readerPool.get(info2, false);
        if (rld != null) {
            delCount += rld.getPendingDeleteCount();
        }
        return delCount;
    }

    protected final void ensureOpen(boolean failIfClosing) throws AlreadyClosedException {
        if (this.closed || failIfClosing && this.closing) {
            throw new AlreadyClosedException("this IndexWriter is closed", this.tragedy);
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        this.ensureOpen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
        block18: {
            block19: {
                this.enableTestPoints = false;
                this.changeCount = new AtomicLong();
                this.segmentsToMerge = new HashMap<SegmentCommitInfo, Boolean>();
                this.mergingSegments = new HashSet();
                this.pendingMerges = new LinkedList();
                this.runningMerges = new HashSet<MergePolicy.OneMerge>();
                this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
                this.flushCount = new AtomicInteger();
                this.flushDeletesCount = new AtomicInteger();
                this.readerPool = new ReaderPool();
                this.pendingNumDocs = new AtomicLong();
                this.rateLimiters = new CloseableThreadLocal();
                this.commitLock = new Object();
                this.fullFlushLock = new Object();
                conf.setIndexWriter(this);
                this.config = conf;
                this.directory = d;
                this.mergeDirectory = this.addMergeRateLimiters(d);
                this.analyzer = this.config.getAnalyzer();
                this.infoStream = this.config.getInfoStream();
                this.mergeScheduler = this.config.getMergeScheduler();
                this.mergeScheduler.setInfoStream(this.infoStream);
                this.codec = this.config.getCodec();
                this.bufferedUpdatesStream = new BufferedUpdatesStream(this.infoStream);
                this.poolReaders = this.config.getReaderPooling();
                this.writeLock = this.directory.makeLock(WRITE_LOCK_NAME);
                if (!this.writeLock.obtain(this.config.getWriteLockTimeout())) {
                    throw new LockObtainFailedException("Index locked for write: " + this.writeLock);
                }
                boolean success = false;
                try {
                    IndexWriterConfig.OpenMode mode = this.config.getOpenMode();
                    boolean create = mode == IndexWriterConfig.OpenMode.CREATE ? true : (mode == IndexWriterConfig.OpenMode.APPEND ? false : !DirectoryReader.indexExists(this.directory));
                    boolean initialIndexExists = true;
                    if (create) {
                        SegmentInfos sis = null;
                        try {
                            sis = SegmentInfos.readLatestCommit(this.directory);
                            sis.clear();
                        }
                        catch (IOException e2) {
                            initialIndexExists = false;
                            sis = new SegmentInfos();
                        }
                        this.segmentInfos = sis;
                        this.changed();
                    } else {
                        Object[] files = this.directory.listAll();
                        String lastSegmentsFile = SegmentInfos.getLastCommitSegmentsFileName((String[])files);
                        if (lastSegmentsFile == null) {
                            throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files));
                        }
                        this.segmentInfos = SegmentInfos.readCommit(this.directory, lastSegmentsFile);
                        IndexCommit commit = this.config.getIndexCommit();
                        if (commit != null) {
                            if (commit.getDirectory() != this.directory) {
                                throw new IllegalArgumentException("IndexCommit's directory doesn't match my directory");
                            }
                            SegmentInfos oldInfos = SegmentInfos.readCommit(this.directory, commit.getSegmentsFileName());
                            this.segmentInfos.replace(oldInfos);
                            this.changed();
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "init: loaded commit \"" + commit.getSegmentsFileName() + "\"");
                            }
                        }
                    }
                    this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                    this.pendingNumDocs.set(this.segmentInfos.totalMaxDoc());
                    this.globalFieldNumberMap = this.getFieldNumberMap();
                    this.config.getFlushPolicy().init(this.config);
                    this.docWriter = new DocumentsWriter(this, this.config, this.directory);
                    this.eventQueue = this.docWriter.eventQueue();
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        this.deleter = new IndexFileDeleter(this.directory, this.config.getIndexDeletionPolicy(), this.segmentInfos, this.infoStream, this, initialIndexExists);
                    }
                    if (this.deleter.startingCommitDeleted) {
                        this.changed();
                    }
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "init: create=" + create);
                        this.messageState();
                    }
                    if (success = true) break block18;
                    if (!this.infoStream.isEnabled("IW")) break block19;
                    this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                        }
                        IOUtils.closeWhileHandlingException(this.writeLock);
                        this.writeLock = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(this.writeLock);
            this.writeLock = null;
        }
    }

    static FieldInfos readFieldInfos(SegmentCommitInfo si) throws IOException {
        Codec codec = si.info.getCodec();
        FieldInfosFormat reader2 = codec.fieldInfosFormat();
        if (si.hasFieldUpdates()) {
            String segmentSuffix = Long.toString(si.getFieldInfosGen(), 36);
            return reader2.read(si.info.dir, si.info, segmentSuffix, IOContext.READONCE);
        }
        if (si.info.getUseCompoundFile()) {
            try (Directory cfs = codec.compoundFormat().getCompoundReader(si.info.dir, si.info, IOContext.DEFAULT);){
                FieldInfos fieldInfos = reader2.read(cfs, si.info, "", IOContext.READONCE);
                return fieldInfos;
            }
        }
        return reader2.read(si.info.dir, si.info, "", IOContext.READONCE);
    }

    private FieldInfos.FieldNumbers getFieldNumberMap() throws IOException {
        FieldInfos.FieldNumbers map2 = new FieldInfos.FieldNumbers();
        for (SegmentCommitInfo info2 : this.segmentInfos) {
            FieldInfos fis = IndexWriter.readFieldInfos(info2);
            for (FieldInfo fi : fis) {
                map2.addOrGet(fi.name, fi.number, fi.getDocValuesType());
            }
        }
        return map2;
    }

    public LiveIndexWriterConfig getConfig() {
        this.ensureOpen(false);
        return this.config;
    }

    private void messageState() {
        if (this.infoStream.isEnabled("IW") && !this.didMessageState) {
            this.didMessageState = true;
            this.infoStream.message("IW", "\ndir=" + this.directory + "\n" + "index=" + this.segString() + "\n" + "version=" + Version.LATEST.toString() + "\n" + this.config.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() throws IOException {
        if (this.pendingCommit != null) {
            throw new IllegalStateException("cannot close: prepareCommit was already called with no corresponding call to commit");
        }
        if (this.shouldClose()) {
            boolean success = false;
            try {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "now flush at close");
                }
                this.flush(true, true);
                this.waitForMerges();
                this.commitInternal(this.config.getMergePolicy());
                this.rollbackInternal();
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        this.rollbackInternal();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.config.getCommitOnClose()) {
            this.shutdown();
        } else {
            this.rollback();
        }
    }

    private synchronized boolean shouldClose() {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            this.doWait();
        }
        return false;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int maxDoc() {
        this.ensureOpen();
        return this.docWriter.getNumDocs() + this.segmentInfos.totalMaxDoc();
    }

    public synchronized int numDocs() {
        this.ensureOpen();
        int count2 = this.docWriter.getNumDocs();
        for (SegmentCommitInfo info2 : this.segmentInfos) {
            count2 += info2.info.maxDoc() - this.numDeletedDocs(info2);
        }
        return count2;
    }

    public synchronized boolean hasDeletions() {
        this.ensureOpen();
        if (this.bufferedUpdatesStream.any()) {
            return true;
        }
        if (this.docWriter.anyDeletions()) {
            return true;
        }
        if (this.readerPool.anyPendingDeletes()) {
            return true;
        }
        for (SegmentCommitInfo info2 : this.segmentInfos) {
            if (!info2.hasDeletions()) continue;
            return true;
        }
        return false;
    }

    public void addDocument(Iterable<? extends IndexableField> doc2) throws IOException {
        this.updateDocument(null, doc2);
    }

    public void addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.updateDocuments(null, docs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.ensureOpen();
        try {
            boolean success = false;
            try {
                if (this.docWriter.updateDocuments(docs, this.analyzer, delTerm)) {
                    this.processEvents(true, false);
                }
                success = true;
            }
            finally {
                if (!success && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
            }
        }
        catch (OutOfMemoryError | AbortingException tragedy) {
            this.tragicEvent(tragedy, "updateDocuments");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryDeleteDocument(IndexReader readerIn, int docID) throws IOException {
        ReadersAndUpdates rld;
        LeafReader reader2;
        if (readerIn instanceof LeafReader) {
            reader2 = (LeafReader)readerIn;
        } else {
            List<LeafReaderContext> leaves = readerIn.leaves();
            int subIndex = ReaderUtil.subIndex(docID, leaves);
            reader2 = leaves.get(subIndex).reader();
            assert ((docID -= leaves.get((int)subIndex).docBase) >= 0);
            assert (docID < reader2.maxDoc());
        }
        if (!(reader2 instanceof SegmentReader)) {
            throw new IllegalArgumentException("the reader must be a SegmentReader or composite reader containing only SegmentReaders");
        }
        SegmentCommitInfo info2 = ((SegmentReader)reader2).getSegmentInfo();
        if (this.segmentInfos.indexOf(info2) != -1 && (rld = this.readerPool.get(info2, false)) != null) {
            BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
            synchronized (bufferedUpdatesStream) {
                rld.initWritableLiveDocs();
                if (rld.delete(docID)) {
                    int fullDelCount = rld.info.getDelCount() + rld.getPendingDeleteCount();
                    if (fullDelCount == rld.info.info.maxDoc() && !this.mergingSegments.contains(rld.info)) {
                        this.segmentInfos.remove(rld.info);
                        this.readerPool.drop(rld.info);
                        this.checkpoint();
                    }
                    this.changed();
                }
                return true;
            }
        }
        return false;
    }

    public void deleteDocuments(Term ... terms) throws IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteTerms(terms)) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "deleteDocuments(Term..)");
        }
    }

    public void deleteDocuments(Query ... queries) throws IOException {
        this.ensureOpen();
        for (Query query : queries) {
            if (query.getClass() != MatchAllDocsQuery.class) continue;
            this.deleteAll();
            return;
        }
        try {
            if (this.docWriter.deleteQueries(queries)) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "deleteDocuments(Query..)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Iterable<? extends IndexableField> doc2) throws IOException {
        this.ensureOpen();
        try {
            boolean success = false;
            try {
                if (this.docWriter.updateDocument(doc2, this.analyzer, term)) {
                    this.processEvents(true, false);
                }
                success = true;
            }
            finally {
                if (!success && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
            }
        }
        catch (OutOfMemoryError | AbortingException tragedy) {
            this.tragicEvent(tragedy, "updateDocument");
        }
    }

    public void updateNumericDocValue(Term term, String field, long value) throws IOException {
        this.ensureOpen();
        if (!this.globalFieldNumberMap.contains(field, DocValuesType.NUMERIC)) {
            throw new IllegalArgumentException("can only update existing numeric-docvalues fields!");
        }
        try {
            if (this.docWriter.updateDocValues(new DocValuesUpdate.NumericDocValuesUpdate(term, field, value))) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "updateNumericDocValue");
        }
    }

    public void updateBinaryDocValue(Term term, String field, BytesRef value) throws IOException {
        this.ensureOpen();
        if (value == null) {
            throw new IllegalArgumentException("cannot update a field to a null value: " + field);
        }
        if (!this.globalFieldNumberMap.contains(field, DocValuesType.BINARY)) {
            throw new IllegalArgumentException("can only update existing binary-docvalues fields!");
        }
        try {
            if (this.docWriter.updateDocValues(new DocValuesUpdate.BinaryDocValuesUpdate(term, field, value))) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "updateBinaryDocValue");
        }
    }

    public void updateDocValues(Term term, Field ... updates) throws IOException {
        this.ensureOpen();
        DocValuesUpdate[] dvUpdates = new DocValuesUpdate[updates.length];
        block6: for (int i = 0; i < updates.length; ++i) {
            Field f = updates[i];
            DocValuesType dvType = f.fieldType().docValuesType();
            if (dvType == null) {
                throw new NullPointerException("DocValuesType cannot be null (field: \"" + f.name() + "\")");
            }
            if (dvType == DocValuesType.NONE) {
                throw new IllegalArgumentException("can only update NUMERIC or BINARY fields! field=" + f.name());
            }
            if (!this.globalFieldNumberMap.contains(f.name(), dvType)) {
                throw new IllegalArgumentException("can only update existing docvalues fields! field=" + f.name() + ", type=" + (Object)((Object)dvType));
            }
            switch (dvType) {
                case NUMERIC: {
                    dvUpdates[i] = new DocValuesUpdate.NumericDocValuesUpdate(term, f.name(), (Long)f.numericValue());
                    continue block6;
                }
                case BINARY: {
                    dvUpdates[i] = new DocValuesUpdate.BinaryDocValuesUpdate(term, f.name(), f.binaryValue());
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("can only update NUMERIC or BINARY fields: field=" + f.name() + ", type=" + (Object)((Object)dvType));
                }
            }
        }
        try {
            if (this.docWriter.updateDocValues(dvUpdates)) {
                this.processEvents(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "updateDocValues");
        }
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocs();
    }

    final synchronized Collection<String> getIndexFileNames() throws IOException {
        return this.segmentInfos.files(true);
    }

    final synchronized int maxDoc(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).info.maxDoc();
        }
        return -1;
    }

    final int getFlushCount() {
        return this.flushCount.get();
    }

    final int getFlushDeletesCount() {
        return this.flushDeletesCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            this.changeCount.incrementAndGet();
            this.segmentInfos.changed();
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    public void forceMerge(int maxNumSegments) throws IOException {
        this.forceMerge(maxNumSegments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMerge(int maxNumSegments, boolean doWait) throws IOException {
        this.ensureOpen();
        if (maxNumSegments < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + maxNumSegments);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMerge: index now " + this.segString());
            this.infoStream.message("IW", "now flush at forceMerge");
        }
        this.flush(true, true);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToMerge.clear();
            for (SegmentCommitInfo info2 : this.segmentInfos) {
                this.segmentsToMerge.put(info2, Boolean.TRUE);
            }
            this.mergeMaxNumSegments = maxNumSegments;
            for (MergePolicy.OneMerge merge2 : this.pendingMerges) {
                merge2.maxNumSegments = maxNumSegments;
                this.segmentsToMerge.put(merge2.info, Boolean.TRUE);
            }
            for (MergePolicy.OneMerge merge2 : this.runningMerges) {
                merge2.maxNumSegments = maxNumSegments;
                this.segmentsToMerge.put(merge2.info, Boolean.TRUE);
            }
        }
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, maxNumSegments);
        if (doWait) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (true) {
                    if (this.tragedy != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMerge", this.tragedy);
                    }
                    if (this.mergeExceptions.size() > 0) {
                        int size = this.mergeExceptions.size();
                        for (int i = 0; i < size; ++i) {
                            MergePolicy.OneMerge merge3 = this.mergeExceptions.get(i);
                            if (merge3.maxNumSegments == -1) continue;
                            throw new IOException("background merge hit exception: " + merge3.segString(), merge3.getException());
                        }
                    }
                    if (!this.maxNumSegmentsMergesPending()) break;
                    this.doWait();
                }
            }
            this.ensureOpen();
        }
    }

    private synchronized boolean maxNumSegmentsMergesPending() {
        for (MergePolicy.OneMerge merge2 : this.pendingMerges) {
            if (merge2.maxNumSegments == -1) continue;
            return true;
        }
        for (MergePolicy.OneMerge merge2 : this.runningMerges) {
            if (merge2.maxNumSegments == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMergeDeletes(boolean doWait) throws IOException {
        MergePolicy.MergeSpecification spec;
        this.ensureOpen();
        this.flush(true, true);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMergeDeletes: index now " + this.segString());
        }
        MergePolicy mergePolicy = this.config.getMergePolicy();
        boolean newMergesFound = false;
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            spec = mergePolicy.findForcedDeletesMerges(this.segmentInfos, this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                int numMerges = spec.merges.size();
                for (int i = 0; i < numMerges; ++i) {
                    this.registerMerge(spec.merges.get(i));
                }
            }
        }
        this.mergeScheduler.merge(this, MergeTrigger.EXPLICIT, newMergesFound);
        if (spec != null && doWait) {
            int numMerges = spec.merges.size();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                boolean running = true;
                while (running) {
                    if (this.tragedy != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMergeDeletes", this.tragedy);
                    }
                    running = false;
                    for (int i = 0; i < numMerges; ++i) {
                        Throwable t;
                        MergePolicy.OneMerge merge2 = spec.merges.get(i);
                        if (this.pendingMerges.contains(merge2) || this.runningMerges.contains(merge2)) {
                            running = true;
                        }
                        if ((t = merge2.getException()) == null) continue;
                        throw new IOException("background merge hit exception: " + merge2.segString(), t);
                    }
                    if (!running) continue;
                    this.doWait();
                }
            }
        }
    }

    public void forceMergeDeletes() throws IOException {
        this.forceMergeDeletes(true);
    }

    public final void maybeMerge() throws IOException {
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, -1);
    }

    private final void maybeMerge(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        this.ensureOpen(false);
        boolean newMergesFound = this.updatePendingMerges(mergePolicy, trigger, maxNumSegments);
        this.mergeScheduler.merge(this, trigger, newMergesFound);
    }

    private synchronized boolean updatePendingMerges(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        int i;
        int numMerges;
        MergePolicy.MergeSpecification spec;
        this.messageState();
        assert (maxNumSegments == -1 || maxNumSegments > 0);
        assert (trigger != null);
        if (this.stopMerges) {
            return false;
        }
        if (this.tragedy != null) {
            return false;
        }
        boolean newMergesFound = false;
        if (maxNumSegments != -1) {
            assert (trigger == MergeTrigger.EXPLICIT || trigger == MergeTrigger.MERGE_FINISHED) : "Expected EXPLICT or MERGE_FINISHED as trigger even with maxNumSegments set but was: " + trigger.name();
            spec = mergePolicy.findForcedMerges(this.segmentInfos, maxNumSegments, Collections.unmodifiableMap(this.segmentsToMerge), this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                numMerges = spec.merges.size();
                for (i = 0; i < numMerges; ++i) {
                    MergePolicy.OneMerge merge2 = spec.merges.get(i);
                    merge2.maxNumSegments = maxNumSegments;
                }
            }
        } else {
            spec = mergePolicy.findMerges(trigger, this.segmentInfos, this);
        }
        boolean bl = newMergesFound = spec != null;
        if (newMergesFound) {
            numMerges = spec.merges.size();
            for (i = 0; i < numMerges; ++i) {
                this.registerMerge(spec.merges.get(i));
            }
        }
        return newMergesFound;
    }

    public synchronized Collection<SegmentCommitInfo> getMergingSegments() {
        return this.mergingSegments;
    }

    public synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge merge2 = this.pendingMerges.removeFirst();
        this.runningMerges.add(merge2);
        return merge2;
    }

    public synchronized boolean hasPendingMerges() {
        return this.pendingMerges.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            if (this.shouldClose()) {
                this.rollbackInternal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternal() throws IOException {
        IndexWriter indexWriter;
        boolean success;
        block41: {
            success = false;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "rollback");
            }
            try {
                indexWriter = this;
                synchronized (indexWriter) {
                    this.abortMerges();
                    this.stopMerges = true;
                }
                this.rateLimiters.close();
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "rollback: done finish merges");
                }
                this.mergeScheduler.close();
                this.bufferedUpdatesStream.clear();
                this.docWriter.close();
                this.docWriter.abort(this);
                indexWriter = this;
                synchronized (indexWriter) {
                    if (this.pendingCommit != null) {
                        this.pendingCommit.rollbackCommit(this.directory);
                        try {
                            this.deleter.decRef(this.pendingCommit);
                        }
                        finally {
                            this.pendingCommit = null;
                            this.notifyAll();
                        }
                    }
                    this.readerPool.dropAll(false);
                    this.segmentInfos.rollbackSegmentInfos(this.rollbackSegments);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "rollback: infos=" + this.segString(this.segmentInfos));
                    }
                    this.testPoint("rollback before checkpoint");
                    this.deleter.checkpoint(this.segmentInfos, false);
                    this.deleter.refresh();
                    this.lastCommitChangeCount = this.changeCount.get();
                    this.deleter.close();
                    this.closed = true;
                    IOUtils.close(this.writeLock);
                    this.writeLock = null;
                    assert (this.docWriter.perThreadPool.numDeactivatedThreadStates() == this.docWriter.perThreadPool.getMaxThreadStates()) : "" + this.docWriter.perThreadPool.numDeactivatedThreadStates() + " " + this.docWriter.perThreadPool.getMaxThreadStates();
                }
                success = true;
                if (success) break block41;
            }
            catch (OutOfMemoryError oom) {
                block42: {
                    try {
                        this.tragicEvent(oom, "rollbackInternal");
                        if (success) break block42;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException(this.mergeScheduler);
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            if (!success) {
                                if (this.pendingCommit != null) {
                                    try {
                                        this.pendingCommit.rollbackCommit(this.directory);
                                        this.deleter.decRef(this.pendingCommit);
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                    this.pendingCommit = null;
                                }
                                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                                this.writeLock = null;
                            }
                            this.closed = true;
                            this.closing = false;
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(this.mergeScheduler);
                }
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    if (!success) {
                        if (this.pendingCommit != null) {
                            try {
                                this.pendingCommit.rollbackCommit(this.directory);
                                this.deleter.decRef(this.pendingCommit);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.pendingCommit = null;
                        }
                        IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                        this.writeLock = null;
                    }
                    this.closed = true;
                    this.closing = false;
                }
            }
            IOUtils.closeWhileHandlingException(this.mergeScheduler);
        }
        indexWriter = this;
        synchronized (indexWriter) {
            if (!success) {
                if (this.pendingCommit != null) {
                    try {
                        this.pendingCommit.rollbackCommit(this.directory);
                        this.deleter.decRef(this.pendingCommit);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.pendingCommit = null;
                }
                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                this.writeLock = null;
            }
            this.closed = true;
            this.closing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws IOException {
        this.ensureOpen();
        boolean success = false;
        try {
            Object object = this.fullFlushLock;
            synchronized (object) {
                long abortedDocCount = this.docWriter.lockAndAbortAll(this);
                this.pendingNumDocs.addAndGet(-abortedDocCount);
                this.processEvents(false, true);
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    try {
                        this.abortMerges();
                        this.pendingNumDocs.addAndGet(-this.segmentInfos.totalMaxDoc());
                        this.segmentInfos.clear();
                        this.deleter.checkpoint(this.segmentInfos, false);
                        this.readerPool.dropAll(false);
                        this.changeCount.incrementAndGet();
                        this.segmentInfos.changed();
                        this.globalFieldNumberMap.clear();
                        success = true;
                    }
                    finally {
                        this.docWriter.unlockAllAfterAbortAll(this);
                        if (!success && this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during deleteAll");
                        }
                    }
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "deleteAll");
        }
    }

    private synchronized void abortMerges() {
        this.stopMerges = true;
        for (MergePolicy.OneMerge merge2 : this.pendingMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort pending merge " + this.segString(merge2.segments));
            }
            merge2.rateLimiter.setAbort();
            this.mergeFinish(merge2);
        }
        this.pendingMerges.clear();
        for (MergePolicy.OneMerge merge2 : this.runningMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort running merge " + this.segString(merge2.segments));
            }
            merge2.rateLimiter.setAbort();
        }
        while (this.runningMerges.size() > 0) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now wait for " + this.runningMerges.size() + " running merge/s to abort");
            }
            this.doWait();
        }
        this.stopMerges = false;
        this.notifyAll();
        assert (0 == this.mergingSegments.size());
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "all running merges have aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMerges() throws IOException {
        this.mergeScheduler.merge(this, MergeTrigger.CLOSING, false);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges");
            }
            while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
                this.doWait();
            }
            assert (0 == this.mergingSegments.size());
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges done");
            }
        }
    }

    synchronized void checkpoint() throws IOException {
        this.changed();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void checkpointNoSIS() throws IOException {
        this.changeCount.incrementAndGet();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void changed() {
        this.changeCount.incrementAndGet();
        this.segmentInfos.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void publishFrozenUpdates(FrozenBufferedUpdates packet) {
        assert (packet != null && packet.any());
        BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
        synchronized (bufferedUpdatesStream) {
            this.bufferedUpdatesStream.push(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishFlushedSegment(SegmentCommitInfo newSegment, FrozenBufferedUpdates packet, FrozenBufferedUpdates globalPacket) throws IOException {
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.ensureOpen(false);
                BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
                synchronized (bufferedUpdatesStream) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "publishFlushedSegment");
                    }
                    if (globalPacket != null && globalPacket.any()) {
                        this.bufferedUpdatesStream.push(globalPacket);
                    }
                    long nextGen = packet != null && packet.any() ? this.bufferedUpdatesStream.push(packet) : this.bufferedUpdatesStream.getNextGen();
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "publish sets newSegment delGen=" + nextGen + " seg=" + this.segString(newSegment));
                    }
                    newSegment.setBufferedDeletesGen(nextGen);
                    this.segmentInfos.add(newSegment);
                    this.checkpoint();
                }
            }
        }
        finally {
            this.flushCount.incrementAndGet();
            this.doAfterFlush();
        }
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
        ++this.mergeGen;
    }

    private void noDupDirs(Directory ... dirs) {
        HashSet<Directory> dups = new HashSet<Directory>();
        for (int i = 0; i < dirs.length; ++i) {
            if (dups.contains(dirs[i])) {
                throw new IllegalArgumentException("Directory " + dirs[i] + " appears more than once");
            }
            if (dirs[i] == this.directory) {
                throw new IllegalArgumentException("Cannot add directory to itself");
            }
            dups.add(dirs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Lock> acquireWriteLocks(Directory ... dirs) throws IOException {
        ArrayList<Lock> locks = new ArrayList<Lock>();
        for (int i = 0; i < dirs.length; ++i) {
            boolean success = false;
            try {
                Lock lock = dirs[i].makeLock(WRITE_LOCK_NAME);
                locks.add(lock);
                lock.obtain(this.config.getWriteLockTimeout());
                success = true;
                continue;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(locks);
                }
            }
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(Directory ... dirs) throws IOException {
        this.ensureOpen();
        this.noDupDirs(dirs);
        List<Lock> locks = this.acquireWriteLocks(dirs);
        boolean successTop = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(Directory...)");
            }
            this.flush(false, true);
            ArrayList<SegmentCommitInfo> infos = new ArrayList<SegmentCommitInfo>();
            long totalMaxDoc = 0L;
            ArrayList<SegmentInfos> commits = new ArrayList<SegmentInfos>(dirs.length);
            for (Directory dir2 : dirs) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "addIndexes: process directory " + dir2);
                }
                SegmentInfos sis = SegmentInfos.readLatestCommit(dir2);
                totalMaxDoc += (long)sis.totalMaxDoc();
                commits.add(sis);
            }
            this.testReserveDocs(totalMaxDoc);
            boolean success = false;
            try {
                for (SegmentInfos sis : commits) {
                    for (SegmentCommitInfo info2 : sis) {
                        assert (!infos.contains(info2)) : "dup info dir=" + info2.info.dir + " name=" + info2.info.name;
                        String newSegName = this.newSegmentName();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "addIndexes: process segment origName=" + info2.info.name + " newName=" + newSegName + " info=" + info2);
                        }
                        IOContext context = new IOContext(new FlushInfo(info2.info.maxDoc(), info2.sizeInBytes()));
                        FieldInfos fis = IndexWriter.readFieldInfos(info2);
                        for (FieldInfo fi : fis) {
                            this.globalFieldNumberMap.addOrGet(fi.name, fi.number, fi.getDocValuesType());
                        }
                        infos.add(this.copySegmentAsIs(info2, newSegName, context));
                    }
                }
                success = true;
            }
            finally {
                if (!success) {
                    for (SegmentCommitInfo sipc : infos) {
                        IOUtils.deleteFilesIgnoringExceptions(this.directory, sipc.files().toArray(new String[0]));
                    }
                }
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                success = false;
                try {
                    this.ensureOpen();
                    this.reserveDocs(totalMaxDoc);
                    success = true;
                }
                finally {
                    if (!success) {
                        for (SegmentCommitInfo sipc : infos) {
                            for (String file2 : sipc.files()) {
                                try {
                                    this.directory.deleteFile(file2);
                                }
                                catch (Throwable t) {}
                            }
                        }
                    }
                }
                this.segmentInfos.addAll(infos);
                this.checkpoint();
            }
            successTop = true;
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "addIndexes(Directory...)");
        }
        finally {
            if (successTop) {
                IOUtils.close(locks);
            } else {
                IOUtils.closeWhileHandlingException(locks);
            }
        }
        this.maybeMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(CodecReader ... readers) throws IOException {
        this.ensureOpen();
        long numDocs = 0L;
        try {
            boolean useCompoundFile;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(CodecReader...)");
            }
            this.flush(false, true);
            String mergedName = this.newSegmentName();
            for (CodecReader leaf : readers) {
                numDocs += (long)leaf.numDocs();
            }
            this.testReserveDocs(numDocs);
            IOContext context = new IOContext(new MergeInfo((int)numDocs, -1L, false, -1));
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(this.directory);
            SegmentInfo info2 = new SegmentInfo(this.directory, Version.LATEST, mergedName, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap<String, String>());
            SegmentMerger merger = new SegmentMerger(Arrays.asList(readers), info2, this.infoStream, trackingDir, this.globalFieldNumberMap, context);
            this.rateLimiters.set(new MergeRateLimiter(null));
            if (!merger.shouldMerge()) {
                return;
            }
            boolean success = false;
            try {
                merger.merge();
                success = true;
            }
            finally {
                if (!success) {
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        this.deleter.refresh(info2.name);
                    }
                }
            }
            SegmentCommitInfo infoPerCommit = new SegmentCommitInfo(info2, 0, -1L, -1L, -1L);
            info2.setFiles(new HashSet<String>(trackingDir.getCreatedFiles()));
            trackingDir.getCreatedFiles().clear();
            IndexWriter.setDiagnostics(info2, SOURCE_ADDINDEXES_READERS);
            MergePolicy mergePolicy = this.config.getMergePolicy();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    this.deleter.deleteNewFiles(infoPerCommit.files());
                    return;
                }
                this.ensureOpen();
                useCompoundFile = mergePolicy.useCompoundFile(this.segmentInfos, infoPerCommit, this);
            }
            if (useCompoundFile) {
                Collection<String> filesToDelete = infoPerCommit.files();
                TrackingDirectoryWrapper trackingCFSDir = new TrackingDirectoryWrapper(this.mergeDirectory);
                try {
                    IndexWriter.createCompoundFile(this.infoStream, trackingCFSDir, info2, context);
                }
                finally {
                    IndexWriter indexWriter2 = this;
                    synchronized (indexWriter2) {
                        this.deleter.deleteNewFiles(filesToDelete);
                    }
                }
                info2.setUseCompoundFile(true);
            }
            success = false;
            try {
                this.codec.segmentInfoFormat().write(trackingDir, info2, context);
                success = true;
            }
            finally {
                if (!success) {
                    indexWriter = this;
                    synchronized (indexWriter) {
                        this.deleter.refresh(info2.name);
                    }
                }
            }
            info2.addFiles(trackingDir.getCreatedFiles());
            indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    this.deleter.deleteNewFiles(info2.files());
                    return;
                }
                this.ensureOpen();
                this.reserveDocs(numDocs);
                this.segmentInfos.add(infoPerCommit);
                this.checkpoint();
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, SOURCE_ADDINDEXES_READERS);
        }
        this.maybeMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentCommitInfo copySegmentAsIs(SegmentCommitInfo info2, String segName, IOContext context) throws IOException {
        SegmentInfo newInfo = new SegmentInfo(this.directory, info2.info.getVersion(), segName, info2.info.maxDoc(), info2.info.getUseCompoundFile(), info2.info.getCodec(), info2.info.getDiagnostics(), info2.info.getId(), info2.info.getAttributes());
        SegmentCommitInfo newInfoPerCommit = new SegmentCommitInfo(newInfo, info2.getDelCount(), info2.getDelGen(), info2.getFieldInfosGen(), info2.getDocValuesGen());
        newInfo.setFiles(info2.files());
        boolean success = false;
        try {
            for (String file2 : info2.files()) {
                String newFileName = newInfo.namedForThisSegment(file2);
                assert (!IndexWriter.slowFileExists(this.directory, newFileName)) : "file \"" + newFileName + "\" already exists; newInfo.files=" + newInfo.files();
                this.directory.copyFrom(info2.info.dir, file2, newFileName, context);
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.deleteFilesIgnoringExceptions(this.directory, newInfo.files().toArray(new String[0]));
            }
        }
        return newInfoPerCommit;
    }

    protected void doAfterFlush() throws IOException {
    }

    protected void doBeforeFlush() throws IOException {
    }

    @Override
    public final void prepareCommit() throws IOException {
        this.ensureOpen();
        this.prepareCommitInternal(this.config.getMergePolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCommitInternal(MergePolicy mergePolicy) throws IOException {
        this.startCommitTime = System.nanoTime();
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "prepareCommit: flush");
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            if (this.tragedy != null) {
                throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
            }
            if (this.pendingCommit != null) {
                throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
            }
            this.doBeforeFlush();
            this.testPoint("startDoFlush");
            SegmentInfos toCommit = null;
            boolean anySegmentsFlushed = false;
            try {
                Object object2 = this.fullFlushLock;
                synchronized (object2) {
                    boolean flushSuccess = false;
                    boolean success = false;
                    try {
                        anySegmentsFlushed = this.docWriter.flushAllThreads();
                        if (!anySegmentsFlushed) {
                            this.flushCount.incrementAndGet();
                        }
                        this.processEvents(false, true);
                        flushSuccess = true;
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            this.maybeApplyDeletes(true);
                            this.readerPool.commit(this.segmentInfos);
                            if (this.changeCount.get() != this.lastCommitChangeCount) {
                                this.changeCount.incrementAndGet();
                                this.segmentInfos.changed();
                            }
                            toCommit = this.segmentInfos.clone();
                            this.pendingCommitChangeCount = this.changeCount.get();
                            this.filesToCommit = toCommit.files(false);
                            this.deleter.incRef(this.filesToCommit);
                        }
                        success = true;
                    }
                    finally {
                        if (!success && this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during prepareCommit");
                        }
                        this.docWriter.finishFullFlush(this, flushSuccess);
                        this.doAfterFlush();
                    }
                }
            }
            catch (OutOfMemoryError | AbortingException tragedy) {
                this.tragicEvent(tragedy, "prepareCommit");
            }
            boolean success = false;
            try {
                if (anySegmentsFlushed) {
                    this.maybeMerge(mergePolicy, MergeTrigger.FULL_FLUSH, -1);
                }
                this.startCommit(toCommit);
                success = true;
            }
            finally {
                if (!success) {
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        if (this.filesToCommit != null) {
                            this.deleter.decRefWhileHandlingException(this.filesToCommit);
                            this.filesToCommit = null;
                        }
                    }
                }
            }
        }
    }

    public final synchronized void setCommitData(Map<String, String> commitUserData) {
        this.segmentInfos.setUserData(new HashMap<String, String>(commitUserData));
        this.changeCount.incrementAndGet();
    }

    public final synchronized Map<String, String> getCommitData() {
        return this.segmentInfos.getUserData();
    }

    @Override
    public final void commit() throws IOException {
        this.ensureOpen();
        this.commitInternal(this.config.getMergePolicy());
    }

    public final boolean hasUncommittedChanges() {
        return this.changeCount.get() != this.lastCommitChangeCount || this.docWriter.anyChanges() || this.bufferedUpdatesStream.any();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitInternal(MergePolicy mergePolicy) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commit: start");
        }
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: enter lock");
            }
            if (this.pendingCommit == null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: now prepare");
                }
                this.prepareCommitInternal(mergePolicy);
            } else if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: already prepared");
            }
            this.finishCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishCommit() throws IOException {
        boolean commitCompleted = false;
        boolean finished = false;
        String committedSegmentsFileName = null;
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.pendingCommit != null) {
                    try {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: pendingCommit != null");
                        }
                        committedSegmentsFileName = this.pendingCommit.finishCommit(this.directory);
                        commitCompleted = true;
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: done writing segments file \"" + committedSegmentsFileName + "\"");
                        }
                        this.deleter.checkpoint(this.pendingCommit, true);
                        this.segmentInfos.updateGeneration(this.pendingCommit);
                        this.lastCommitChangeCount = this.pendingCommitChangeCount;
                        this.rollbackSegments = this.pendingCommit.createBackupSegmentInfos();
                        finished = true;
                    }
                    finally {
                        this.notifyAll();
                        try {
                            if (finished) {
                                this.deleter.decRef(this.filesToCommit);
                            } else if (!commitCompleted) {
                                this.deleter.decRefWhileHandlingException(this.filesToCommit);
                            }
                        }
                        finally {
                            this.pendingCommit = null;
                            this.filesToCommit = null;
                        }
                    }
                }
                assert (this.filesToCommit == null);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: pendingCommit == null; skip");
                }
            }
        }
        catch (Throwable t) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during finishCommit: " + t.getMessage());
            }
            if (commitCompleted) {
                this.tragicEvent(t, "finishCommit");
            }
            IOUtils.reThrow(t);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", String.format(Locale.ROOT, "commit: took %.1f msec", (double)(System.nanoTime() - this.startCommitTime) / 1000000.0));
            this.infoStream.message("IW", "commit: done");
        }
    }

    boolean holdsFullFlushLock() {
        return Thread.holdsLock(this.fullFlushLock);
    }

    protected final void flush(boolean triggerMerge, boolean applyAllDeletes) throws IOException {
        this.ensureOpen(false);
        if (this.doFlush(applyAllDeletes) && triggerMerge) {
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(boolean applyAllDeletes) throws IOException {
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot flush", this.tragedy);
        }
        this.doBeforeFlush();
        this.testPoint("startDoFlush");
        boolean success = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "  start flush: applyAllDeletes=" + applyAllDeletes);
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            boolean anyChanges = false;
            Object object = this.fullFlushLock;
            synchronized (object) {
                boolean flushSuccess = false;
                try {
                    anyChanges = this.docWriter.flushAllThreads();
                    if (!anyChanges) {
                        this.flushCount.incrementAndGet();
                    }
                    flushSuccess = true;
                }
                finally {
                    this.docWriter.finishFullFlush(this, flushSuccess);
                    this.processEvents(false, true);
                }
            }
            object = this;
            synchronized (object) {
                try {
                    this.doAfterFlush();
                    success = true;
                    boolean bl = anyChanges |= this.maybeApplyDeletes(applyAllDeletes);
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (OutOfMemoryError | AbortingException tragedy) {
                        this.tragicEvent(tragedy, "doFlush");
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            if (!success && this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during flush");
            }
        }
    }

    final synchronized boolean maybeApplyDeletes(boolean applyAllDeletes) throws IOException {
        if (applyAllDeletes) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "apply all deletes during flush");
            }
            return this.applyAllDeletesAndUpdates();
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "don't apply deletes now delTermCount=" + this.bufferedUpdatesStream.numTerms() + " bytesUsed=" + this.bufferedUpdatesStream.ramBytesUsed());
        }
        return false;
    }

    final synchronized boolean applyAllDeletesAndUpdates() throws IOException {
        this.flushDeletesCount.incrementAndGet();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply all deletes for all segments maxDoc=" + (this.docWriter.getNumDocs() + this.segmentInfos.totalMaxDoc()));
        }
        BufferedUpdatesStream.ApplyDeletesResult result = this.bufferedUpdatesStream.applyDeletesAndUpdates(this.readerPool, this.segmentInfos.asList());
        if (result.anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && result.allDeleted != null) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "drop 100% deleted segments: " + this.segString(result.allDeleted));
            }
            for (SegmentCommitInfo info2 : result.allDeleted) {
                if (this.mergingSegments.contains(info2)) continue;
                this.segmentInfos.remove(info2);
                this.pendingNumDocs.addAndGet(-info2.info.maxDoc());
                this.readerPool.drop(info2);
            }
            this.checkpoint();
        }
        this.bufferedUpdatesStream.prune(this.segmentInfos);
        return result.anyDeletes;
    }

    DocumentsWriter getDocsWriter() {
        return this.docWriter;
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocs();
    }

    private synchronized void ensureValidMerge(MergePolicy.OneMerge merge2) {
        for (SegmentCommitInfo info2 : merge2.segments) {
            if (this.segmentInfos.contains(info2)) continue;
            throw new MergePolicy.MergeException("MergePolicy selected a segment (" + info2.info.name + ") that is not in the current index " + this.segString(), this.directory);
        }
    }

    private void skipDeletedDoc(DocValuesFieldUpdates.Iterator[] updatesIters, int deletedDoc) {
        for (DocValuesFieldUpdates.Iterator iter : updatesIters) {
            if (iter.doc() == deletedDoc) {
                iter.nextDoc();
            }
            assert (iter.doc() > deletedDoc) : "updateDoc=" + iter.doc() + " deletedDoc=" + deletedDoc;
        }
    }

    private void maybeApplyMergedDVUpdates(MergePolicy.OneMerge merge2, MergeState mergeState, int docUpto, MergedDeletesAndUpdates holder, String[] mergingFields, DocValuesFieldUpdates[] dvFieldUpdates, DocValuesFieldUpdates.Iterator[] updatesIters, int curDoc) throws IOException {
        int newDoc = -1;
        for (int idx = 0; idx < mergingFields.length; ++idx) {
            DocValuesFieldUpdates.Iterator updatesIter = updatesIters[idx];
            if (updatesIter.doc() == curDoc) {
                if (holder.mergedDeletesAndUpdates == null) {
                    holder.init(this.readerPool, merge2, mergeState, false);
                }
                if (newDoc == -1) {
                    newDoc = holder.docMap.map(docUpto);
                }
                DocValuesFieldUpdates dvUpdates = dvFieldUpdates[idx];
                dvUpdates.add(newDoc, updatesIter.value());
                updatesIter.nextDoc();
                continue;
            }
            assert (updatesIter.doc() > curDoc) : "field=" + mergingFields[idx] + " updateDoc=" + updatesIter.doc() + " curDoc=" + curDoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ReadersAndUpdates commitMergedDeletesAndUpdates(MergePolicy.OneMerge merge2, MergeState mergeState) throws IOException {
        this.testPoint("startCommitMergeDeletes");
        List<SegmentCommitInfo> sourceSegments = merge2.segments;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMergeDeletes " + this.segString(merge2.segments));
        }
        int docUpto = 0;
        long minGen = Long.MAX_VALUE;
        MergedDeletesAndUpdates holder = new MergedDeletesAndUpdates();
        DocValuesFieldUpdates.Container mergedDVUpdates = new DocValuesFieldUpdates.Container();
        for (int i = 0; i < sourceSegments.size(); ++i) {
            int j;
            DocValuesFieldUpdates[] dvFieldUpdates;
            DocValuesFieldUpdates.Iterator[] updatesIters;
            String[] mergingFields;
            SegmentCommitInfo info2 = sourceSegments.get(i);
            minGen = Math.min(info2.getBufferedDeletesGen(), minGen);
            int maxDoc = info2.info.maxDoc();
            Bits prevLiveDocs = merge2.readers.get(i).getLiveDocs();
            ReadersAndUpdates rld = this.readerPool.get(info2, false);
            assert (rld != null) : "seg=" + info2.info.name;
            Bits currentLiveDocs = rld.getLiveDocs();
            Map<String, DocValuesFieldUpdates> mergingFieldUpdates = rld.getMergingFieldUpdates();
            if (mergingFieldUpdates.isEmpty()) {
                mergingFields = null;
                updatesIters = null;
                dvFieldUpdates = null;
            } else {
                mergingFields = new String[mergingFieldUpdates.size()];
                dvFieldUpdates = new DocValuesFieldUpdates[mergingFieldUpdates.size()];
                updatesIters = new DocValuesFieldUpdates.Iterator[mergingFieldUpdates.size()];
                int idx = 0;
                for (Map.Entry<String, DocValuesFieldUpdates> e2 : mergingFieldUpdates.entrySet()) {
                    String field = e2.getKey();
                    DocValuesFieldUpdates updates = e2.getValue();
                    mergingFields[idx] = field;
                    dvFieldUpdates[idx] = mergedDVUpdates.getUpdates(field, updates.type);
                    if (dvFieldUpdates[idx] == null) {
                        dvFieldUpdates[idx] = mergedDVUpdates.newUpdates(field, updates.type, mergeState.segmentInfo.maxDoc());
                    }
                    updatesIters[idx] = updates.iterator();
                    updatesIters[idx].nextDoc();
                    ++idx;
                }
            }
            if (prevLiveDocs != null) {
                assert (currentLiveDocs != null);
                assert (prevLiveDocs.length() == maxDoc);
                assert (currentLiveDocs.length() == maxDoc);
                if (currentLiveDocs != prevLiveDocs) {
                    for (j = 0; j < maxDoc; ++j) {
                        if (!prevLiveDocs.get(j)) {
                            assert (!currentLiveDocs.get(j));
                            continue;
                        }
                        if (!currentLiveDocs.get(j)) {
                            if (holder.mergedDeletesAndUpdates == null || !holder.initializedWritableLiveDocs) {
                                holder.init(this.readerPool, merge2, mergeState, true);
                            }
                            holder.mergedDeletesAndUpdates.delete(holder.docMap.map(docUpto));
                            if (mergingFields != null) {
                                this.skipDeletedDoc(updatesIters, j);
                            }
                        } else if (mergingFields != null) {
                            this.maybeApplyMergedDVUpdates(merge2, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                        }
                        ++docUpto;
                    }
                    continue;
                }
                if (mergingFields != null) {
                    for (j = 0; j < maxDoc; ++j) {
                        if (prevLiveDocs.get(j)) {
                            this.maybeApplyMergedDVUpdates(merge2, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                            ++docUpto;
                            continue;
                        }
                        this.skipDeletedDoc(updatesIters, j);
                    }
                    continue;
                }
                docUpto += info2.info.maxDoc() - info2.getDelCount() - rld.getPendingDeleteCount();
                continue;
            }
            if (currentLiveDocs != null) {
                assert (currentLiveDocs.length() == maxDoc);
                for (j = 0; j < maxDoc; ++j) {
                    if (!currentLiveDocs.get(j)) {
                        if (holder.mergedDeletesAndUpdates == null || !holder.initializedWritableLiveDocs) {
                            holder.init(this.readerPool, merge2, mergeState, true);
                        }
                        holder.mergedDeletesAndUpdates.delete(holder.docMap.map(docUpto));
                        if (mergingFields != null) {
                            this.skipDeletedDoc(updatesIters, j);
                        }
                    } else if (mergingFields != null) {
                        this.maybeApplyMergedDVUpdates(merge2, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                    }
                    ++docUpto;
                }
                continue;
            }
            if (mergingFields != null) {
                for (j = 0; j < maxDoc; ++j) {
                    this.maybeApplyMergedDVUpdates(merge2, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                    ++docUpto;
                }
                continue;
            }
            docUpto += info2.info.maxDoc();
        }
        assert (docUpto == merge2.info.info.maxDoc());
        if (mergedDVUpdates.any()) {
            boolean success = false;
            try {
                holder.mergedDeletesAndUpdates.writeFieldUpdates(this.directory, mergedDVUpdates);
                success = true;
            }
            finally {
                if (!success) {
                    holder.mergedDeletesAndUpdates.dropChanges();
                    this.readerPool.drop(merge2.info);
                }
            }
        }
        if (this.infoStream.isEnabled("IW")) {
            if (holder.mergedDeletesAndUpdates == null) {
                this.infoStream.message("IW", "no new deletes or field updates since merge started");
            } else {
                String msg = holder.mergedDeletesAndUpdates.getPendingDeleteCount() + " new deletes";
                if (mergedDVUpdates.any()) {
                    msg = msg + " and " + mergedDVUpdates.size() + " new field updates";
                }
                msg = msg + " since merge started";
                this.infoStream.message("IW", msg);
            }
        }
        merge2.info.setBufferedDeletesGen(minGen);
        return holder.mergedDeletesAndUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean commitMerge(MergePolicy.OneMerge merge2, MergeState mergeState) throws IOException {
        boolean dropSegment;
        boolean allDeleted;
        ReadersAndUpdates mergedUpdates;
        this.testPoint("startCommitMerge");
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete merge", this.tragedy);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMerge: " + this.segString(merge2.segments) + " index=" + this.segString());
        }
        assert (merge2.registerDone);
        if (merge2.rateLimiter.getAbort()) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commitMerge: skip: it was aborted");
            }
            this.readerPool.drop(merge2.info);
            this.deleter.deleteNewFiles(merge2.info.files());
            return false;
        }
        ReadersAndUpdates readersAndUpdates = mergedUpdates = merge2.info.info.maxDoc() == 0 ? null : this.commitMergedDeletesAndUpdates(merge2, mergeState);
        assert (!this.segmentInfos.contains(merge2.info));
        boolean bl = allDeleted = merge2.segments.size() == 0 || merge2.info.info.maxDoc() == 0 || mergedUpdates != null && mergedUpdates.getPendingDeleteCount() == merge2.info.info.maxDoc();
        if (this.infoStream.isEnabled("IW") && allDeleted) {
            this.infoStream.message("IW", "merged segment " + merge2.info + " is 100% deleted" + (this.keepFullyDeletedSegments ? "" : "; skipping insert"));
        }
        boolean bl2 = dropSegment = allDeleted && !this.keepFullyDeletedSegments;
        assert (merge2.segments.size() > 0 || dropSegment);
        assert (merge2.info.info.maxDoc() != 0 || this.keepFullyDeletedSegments || dropSegment);
        if (mergedUpdates != null) {
            boolean success = false;
            try {
                if (dropSegment) {
                    mergedUpdates.dropChanges();
                }
                this.readerPool.release(mergedUpdates, false);
                success = true;
            }
            finally {
                if (!success) {
                    mergedUpdates.dropChanges();
                    this.readerPool.drop(merge2.info);
                }
            }
        }
        this.segmentInfos.applyMergeChanges(merge2, dropSegment);
        int delDocCount = merge2.totalMaxDoc - merge2.info.info.maxDoc();
        assert (delDocCount >= 0);
        this.pendingNumDocs.addAndGet(-delDocCount);
        if (dropSegment) {
            assert (!this.segmentInfos.contains(merge2.info));
            this.readerPool.drop(merge2.info);
            this.deleter.deleteNewFiles(merge2.info.files());
        }
        boolean success = false;
        try {
            this.closeMergeReaders(merge2, false);
            success = true;
        }
        finally {
            if (success) {
                this.checkpoint();
            } else {
                try {
                    this.checkpoint();
                }
                catch (Throwable t) {}
            }
        }
        this.deleter.deletePendingFiles();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "after commitMerge: " + this.segString());
        }
        if (merge2.maxNumSegments != -1 && !dropSegment && !this.segmentsToMerge.containsKey(merge2.info)) {
            this.segmentsToMerge.put(merge2.info, Boolean.FALSE);
        }
        return true;
    }

    private final void handleMergeException(Throwable t, MergePolicy.OneMerge merge2) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "handleMergeException: merge=" + this.segString(merge2.segments) + " exc=" + t);
        }
        merge2.setException(t);
        this.addMergeException(merge2);
        if (t instanceof MergePolicy.MergeAbortedException) {
            if (merge2.isExternal) {
                throw (MergePolicy.MergeAbortedException)t;
            }
        } else {
            IOUtils.reThrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(MergePolicy.OneMerge merge2) throws IOException {
        boolean success = false;
        this.rateLimiters.set(merge2.rateLimiter);
        long t0 = System.currentTimeMillis();
        MergePolicy mergePolicy = this.config.getMergePolicy();
        try {
            try {
                try {
                    this.mergeInit(merge2);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "now merge\n  merge=" + this.segString(merge2.segments) + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(merge2, mergePolicy);
                    this.mergeSuccess(merge2);
                    success = true;
                }
                catch (Throwable t) {
                    this.handleMergeException(t, merge2);
                }
            }
            finally {
                IndexWriter t = this;
                synchronized (t) {
                    this.mergeFinish(merge2);
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during merge");
                        }
                        if (merge2.info != null && !this.segmentInfos.contains(merge2.info)) {
                            this.deleter.refresh(merge2.info.info.name);
                        }
                    }
                    if (success && !merge2.rateLimiter.getAbort() && (merge2.maxNumSegments != -1 || !this.closed && !this.closing)) {
                        this.updatePendingMerges(mergePolicy, MergeTrigger.MERGE_FINISHED, merge2.maxNumSegments);
                    }
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, SOURCE_MERGE);
        }
        if (merge2.info != null && !merge2.rateLimiter.getAbort() && this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge time " + (System.currentTimeMillis() - t0) + " msec for " + merge2.info.info.maxDoc() + " docs");
        }
    }

    void mergeSuccess(MergePolicy.OneMerge merge2) {
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge merge2) throws IOException {
        if (merge2.registerDone) {
            return true;
        }
        assert (merge2.segments.size() > 0);
        if (this.stopMerges) {
            merge2.rateLimiter.setAbort();
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + this.segString(merge2.segments));
        }
        boolean isExternal = false;
        for (SegmentCommitInfo info2 : merge2.segments) {
            if (this.mergingSegments.contains(info2)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge2.segments) + ": segment " + this.segString(info2) + " is already marked for merge");
                }
                return false;
            }
            if (!this.segmentInfos.contains(info2)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge2.segments) + ": segment " + this.segString(info2) + " does not exist in live infos");
                }
                return false;
            }
            if (info2.info.dir != this.directory) {
                isExternal = true;
            }
            if (!this.segmentsToMerge.containsKey(info2)) continue;
            merge2.maxNumSegments = this.mergeMaxNumSegments;
        }
        this.ensureValidMerge(merge2);
        this.pendingMerges.add(merge2);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "add merge to pendingMerges: " + this.segString(merge2.segments) + " [total " + this.pendingMerges.size() + " pending]");
        }
        merge2.mergeGen = this.mergeGen;
        merge2.isExternal = isExternal;
        if (this.infoStream.isEnabled("IW")) {
            StringBuilder builder = new StringBuilder("registerMerge merging= [");
            for (SegmentCommitInfo info3 : this.mergingSegments) {
                builder.append(info3.info.name).append(", ");
            }
            builder.append("]");
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", builder.toString());
            }
        }
        for (SegmentCommitInfo info2 : merge2.segments) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "registerMerge info=" + this.segString(info2));
            }
            this.mergingSegments.add(info2);
        }
        assert (merge2.estimatedMergeBytes == 0L);
        assert (merge2.totalMergeBytes == 0L);
        for (SegmentCommitInfo info2 : merge2.segments) {
            if (info2.info.maxDoc() <= 0) continue;
            int delCount = this.numDeletedDocs(info2);
            assert (delCount <= info2.info.maxDoc());
            double delRatio = (double)delCount / (double)info2.info.maxDoc();
            merge2.estimatedMergeBytes = (long)((double)merge2.estimatedMergeBytes + (double)info2.sizeInBytes() * (1.0 - delRatio));
            merge2.totalMergeBytes += info2.sizeInBytes();
        }
        merge2.registerDone = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void mergeInit(MergePolicy.OneMerge merge2) throws IOException {
        boolean success = false;
        try {
            this._mergeInit(merge2);
            success = true;
        }
        finally {
            if (!success) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception in mergeInit");
                }
                this.mergeFinish(merge2);
            }
        }
    }

    private synchronized void _mergeInit(MergePolicy.OneMerge merge2) throws IOException {
        this.testPoint("startMergeInit");
        assert (merge2.registerDone);
        assert (merge2.maxNumSegments == -1 || merge2.maxNumSegments > 0);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot merge", this.tragedy);
        }
        if (merge2.info != null) {
            return;
        }
        if (merge2.rateLimiter.getAbort()) {
            return;
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply deletes for " + merge2.segments.size() + " merging segments");
        }
        BufferedUpdatesStream.ApplyDeletesResult result = this.bufferedUpdatesStream.applyDeletesAndUpdates(this.readerPool, merge2.segments);
        if (result.anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && result.allDeleted != null) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "drop 100% deleted segments: " + result.allDeleted);
            }
            for (SegmentCommitInfo info2 : result.allDeleted) {
                this.segmentInfos.remove(info2);
                this.pendingNumDocs.addAndGet(-info2.info.maxDoc());
                if (merge2.segments.contains(info2)) {
                    this.mergingSegments.remove(info2);
                    merge2.segments.remove(info2);
                }
                this.readerPool.drop(info2);
            }
            this.checkpoint();
        }
        String mergeSegmentName = this.newSegmentName();
        SegmentInfo si = new SegmentInfo(this.directory, Version.LATEST, mergeSegmentName, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap<String, String>());
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("mergeMaxNumSegments", "" + merge2.maxNumSegments);
        details.put("mergeFactor", Integer.toString(merge2.segments.size()));
        IndexWriter.setDiagnostics(si, SOURCE_MERGE, details);
        merge2.setInfo(new SegmentCommitInfo(si, 0, -1L, -1L, -1L));
        this.bufferedUpdatesStream.prune(this.segmentInfos);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge seg=" + merge2.info.info.name + " " + this.segString(merge2.segments));
        }
    }

    static void setDiagnostics(SegmentInfo info2, String source2) {
        IndexWriter.setDiagnostics(info2, source2, null);
    }

    private static void setDiagnostics(SegmentInfo info2, String source2, Map<String, String> details) {
        HashMap<String, String> diagnostics = new HashMap<String, String>();
        diagnostics.put(SOURCE, source2);
        diagnostics.put("lucene.version", Version.LATEST.toString());
        diagnostics.put("os", Constants.OS_NAME);
        diagnostics.put("os.arch", Constants.OS_ARCH);
        diagnostics.put("os.version", Constants.OS_VERSION);
        diagnostics.put("java.version", Constants.JAVA_VERSION);
        diagnostics.put("java.vendor", Constants.JAVA_VENDOR);
        diagnostics.put("timestamp", Long.toString(new Date().getTime()));
        if (details != null) {
            diagnostics.putAll(details);
        }
        info2.setDiagnostics(diagnostics);
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge merge2) {
        this.notifyAll();
        if (merge2.registerDone) {
            List<SegmentCommitInfo> sourceSegments = merge2.segments;
            for (SegmentCommitInfo info2 : sourceSegments) {
                this.mergingSegments.remove(info2);
            }
            merge2.registerDone = false;
        }
        this.runningMerges.remove(merge2);
    }

    private final synchronized void closeMergeReaders(MergePolicy.OneMerge merge2, boolean suppressExceptions) throws IOException {
        Throwable th;
        block11: {
            int numSegments = merge2.readers.size();
            th = null;
            boolean drop2 = !suppressExceptions;
            for (int i = 0; i < numSegments; ++i) {
                block10: {
                    SegmentReader sr = merge2.readers.get(i);
                    if (sr == null) continue;
                    try {
                        ReadersAndUpdates rld = this.readerPool.get(sr.getSegmentInfo(), false);
                        assert (rld != null);
                        if (drop2) {
                            rld.dropChanges();
                        } else {
                            rld.dropMergingUpdates();
                        }
                        rld.release(sr);
                        this.readerPool.release(rld);
                        if (drop2) {
                            this.readerPool.drop(rld.info);
                        }
                    }
                    catch (Throwable t) {
                        if (th != null) break block10;
                        th = t;
                    }
                }
                merge2.readers.set(i, null);
            }
            try {
                merge2.mergeFinished();
            }
            catch (Throwable t) {
                if (th != null) break block11;
                th = t;
            }
        }
        if (!suppressExceptions) {
            IOUtils.reThrow(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int mergeMiddle(MergePolicy.OneMerge merge2, MergePolicy mergePolicy) throws IOException {
        merge2.rateLimiter.checkAbort();
        List<SegmentCommitInfo> sourceSegments = merge2.segments;
        IOContext context = new IOContext(merge2.getMergeInfo());
        TrackingDirectoryWrapper dirWrapper = new TrackingDirectoryWrapper(this.mergeDirectory);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merging " + this.segString(merge2.segments));
        }
        merge2.readers = new ArrayList<SegmentReader>();
        boolean success = false;
        try {
            Closeable reader2;
            for (int segUpto = 0; segUpto < sourceSegments.size(); ++segUpto) {
                SegmentCommitInfo info2 = sourceSegments.get(segUpto);
                ReadersAndUpdates rld = this.readerPool.get(info2, true);
                IndexWriter indexWriter = this;
                // MONITORENTER : indexWriter
                reader2 = rld.getReaderForMerge(context);
                Bits liveDocs = rld.getReadOnlyLiveDocs();
                int delCount = rld.getPendingDeleteCount() + info2.getDelCount();
                assert (reader2 != null);
                assert (rld.verifyDocCounts());
                if (this.infoStream.isEnabled("IW")) {
                    if (rld.getPendingDeleteCount() != 0) {
                        this.infoStream.message("IW", "seg=" + this.segString(info2) + " delCount=" + info2.getDelCount() + " pendingDelCount=" + rld.getPendingDeleteCount());
                    } else if (info2.getDelCount() != 0) {
                        this.infoStream.message("IW", "seg=" + this.segString(info2) + " delCount=" + info2.getDelCount());
                    } else {
                        this.infoStream.message("IW", "seg=" + this.segString(info2) + " no deletes");
                    }
                }
                // MONITOREXIT : indexWriter
                if (((IndexReader)reader2).numDeletedDocs() != delCount) {
                    assert (delCount > ((IndexReader)reader2).numDeletedDocs());
                    IndexWriter indexWriter2 = this;
                    // MONITORENTER : indexWriter2
                    SegmentReader newReader = new SegmentReader(info2, (SegmentReader)reader2, liveDocs, info2.info.maxDoc() - delCount);
                    // MONITOREXIT : indexWriter2
                    boolean released = false;
                    try {
                        rld.release((SegmentReader)reader2);
                        released = true;
                    }
                    finally {
                        if (!released) {
                            newReader.decRef();
                        }
                    }
                    reader2 = newReader;
                }
                merge2.readers.add((SegmentReader)reader2);
                assert (delCount <= info2.info.maxDoc()) : "delCount=" + delCount + " info.maxDoc=" + info2.info.maxDoc() + " rld.pendingDeleteCount=" + rld.getPendingDeleteCount() + " info.getDelCount()=" + info2.getDelCount();
            }
            SegmentMerger merger = new SegmentMerger(merge2.getMergeReaders(), merge2.info.info, this.infoStream, dirWrapper, this.globalFieldNumberMap, context);
            merge2.rateLimiter.checkAbort();
            merge2.mergeStartNS = System.nanoTime();
            boolean success3 = false;
            try {
                if (merger.shouldMerge()) {
                    merger.merge();
                }
                success3 = true;
            }
            finally {
                if (!success3) {
                    reader2 = this;
                }
            }
            MergeState mergeState = merger.mergeState;
            assert (mergeState.segmentInfo == merge2.info.info);
            merge2.info.info.setFiles(new HashSet<String>(dirWrapper.getCreatedFiles()));
            if (this.infoStream.isEnabled("IW")) {
                if (merger.shouldMerge()) {
                    long t1 = System.nanoTime();
                    double sec = (double)(t1 - merge2.mergeStartNS) / 1.0E9;
                    double segmentMB = (double)merge2.info.sizeInBytes() / 1024.0 / 1024.0;
                    double stoppedSec = (double)merge2.rateLimiter.getTotalStoppedNS() / 1.0E9;
                    double throttleSec = (double)merge2.rateLimiter.getTotalPausedNS() / 1.0E9;
                    this.infoStream.message("IW", "merge codec=" + this.codec + " maxDoc=" + merge2.info.info.maxDoc() + "; merged segment has " + (mergeState.mergeFieldInfos.hasVectors() ? "vectors" : "no vectors") + "; " + (mergeState.mergeFieldInfos.hasNorms() ? "norms" : "no norms") + "; " + (mergeState.mergeFieldInfos.hasDocValues() ? "docValues" : "no docValues") + "; " + (mergeState.mergeFieldInfos.hasProx() ? "prox" : "no prox") + "; " + (mergeState.mergeFieldInfos.hasProx() ? "freqs" : "no freqs") + "; " + String.format(Locale.ROOT, "%.1f sec (%.1f sec stopped, %.1f sec paused) to merge segment [%.2f MB, %.2f MB/sec]", sec, stoppedSec, throttleSec, segmentMB, segmentMB / sec));
                } else {
                    this.infoStream.message("IW", "skip merging fully deleted segments");
                }
            }
            if (!merger.shouldMerge()) {
                assert (merge2.info.info.maxDoc() == 0);
                this.commitMerge(merge2, mergeState);
                int t1 = 0;
                return t1;
            }
            assert (merge2.info.info.maxDoc() > 0);
            IndexWriter delCount = this;
            // MONITORENTER : delCount
            boolean useCompoundFile = mergePolicy.useCompoundFile(this.segmentInfos, merge2.info, this);
            // MONITOREXIT : delCount
            if (useCompoundFile) {
                TrackingDirectoryWrapper trackingCFSDir;
                Collection<String> filesToRemove;
                block95: {
                    success = false;
                    filesToRemove = merge2.info.files();
                    trackingCFSDir = new TrackingDirectoryWrapper(this.mergeDirectory);
                    try {
                        IndexWriter.createCompoundFile(this.infoStream, trackingCFSDir, merge2.info.info, context);
                        success = true;
                    }
                    catch (IOException ioe) {
                        IndexWriter cfsFiles = this;
                        // MONITORENTER : cfsFiles
                        if (!merge2.rateLimiter.getAbort()) {
                            this.handleMergeException(ioe, merge2);
                        }
                        // MONITOREXIT : cfsFiles
                    }
                    catch (Throwable t2) {
                        this.handleMergeException(t2, merge2);
                        if (success) break block95;
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception creating compound file during merge");
                        }
                        IndexWriter t2 = this;
                        // MONITORENTER : t2
                        HashSet<String> cfsFiles = new HashSet<String>(trackingCFSDir.getCreatedFiles());
                        for (String cfsFile : cfsFiles) {
                            this.deleter.deleteFile(cfsFile);
                        }
                        this.deleter.deleteNewFiles(merge2.info.files());
                        // MONITOREXIT : t2
                    }
                    finally {
                        if (success) {
                        }
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception creating compound file during merge");
                        }
                        IndexWriter ioe = this;
                    }
                }
                success = false;
                IndexWriter t2 = this;
                // MONITORENTER : t2
                this.deleter.deleteNewFiles(filesToRemove);
                if (merge2.rateLimiter.getAbort()) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "abort merge after building CFS");
                    }
                    HashSet<String> cfsFiles = new HashSet<String>(trackingCFSDir.getCreatedFiles());
                    Iterator i$ = cfsFiles.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            int n = 0;
                            // MONITOREXIT : t2
                            return n;
                        }
                        String cfsFile = (String)i$.next();
                        this.deleter.deleteFile(cfsFile);
                    }
                }
                // MONITOREXIT : t2
                merge2.info.info.setUseCompoundFile(true);
            } else {
                success = false;
            }
            boolean success2 = false;
            try {
                this.codec.segmentInfoFormat().write(this.directory, merge2.info.info, context);
                success2 = true;
            }
            finally {
                if (!success2) {
                    IndexWriter trackingCFSDir = this;
                }
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", String.format(Locale.ROOT, "merged segment size=%.3f MB vs estimate=%.3f MB", (double)merge2.info.sizeInBytes() / 1024.0 / 1024.0, (double)(merge2.estimatedMergeBytes / 1024L) / 1024.0));
            }
            IndexReaderWarmer mergedSegmentWarmer = this.config.getMergedSegmentWarmer();
            if (this.poolReaders && mergedSegmentWarmer != null) {
                ReadersAndUpdates rld = this.readerPool.get(merge2.info, true);
                SegmentReader sr = rld.getReader(IOContext.READ);
                try {
                    mergedSegmentWarmer.warm(sr);
                    IndexWriter indexWriter = this;
                }
                catch (Throwable throwable) {
                    IndexWriter indexWriter = this;
                    // MONITORENTER : indexWriter
                    rld.release(sr);
                    this.readerPool.release(rld);
                    // MONITOREXIT : indexWriter
                    throw throwable;
                }
                rld.release(sr);
                this.readerPool.release(rld);
                // MONITOREXIT : indexWriter
            }
            if (!this.commitMerge(merge2, mergeState)) {
                int n = 0;
                return n;
            }
            success = true;
            return merge2.info.info.maxDoc();
        }
        finally {
            if (!success) {
                this.closeMergeReaders(merge2, true);
            }
        }
    }

    synchronized void addMergeException(MergePolicy.OneMerge merge2) {
        assert (merge2.getException() != null);
        if (!this.mergeExceptions.contains(merge2) && this.mergeGen == merge2.mergeGen) {
            this.mergeExceptions.add(merge2);
        }
    }

    final int getBufferedDeleteTermsSize() {
        return this.docWriter.getBufferedDeleteTermsSize();
    }

    final int getNumBufferedDeleteTerms() {
        return this.docWriter.getNumBufferedDeleteTerms();
    }

    synchronized SegmentCommitInfo newestSegment() {
        return this.segmentInfos.size() > 0 ? this.segmentInfos.info(this.segmentInfos.size() - 1) : null;
    }

    public synchronized String segString() {
        return this.segString(this.segmentInfos);
    }

    public synchronized String segString(Iterable<SegmentCommitInfo> infos) {
        StringBuilder buffer = new StringBuilder();
        for (SegmentCommitInfo info2 : infos) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(this.segString(info2));
        }
        return buffer.toString();
    }

    public synchronized String segString(SegmentCommitInfo info2) {
        return info2.toString(this.numDeletedDocs(info2) - info2.getDelCount());
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
    }

    void setKeepFullyDeletedSegments(boolean v) {
        this.keepFullyDeletedSegments = v;
    }

    boolean getKeepFullyDeletedSegments() {
        return this.keepFullyDeletedSegments;
    }

    private boolean filesExist(SegmentInfos toSync) throws IOException {
        Collection<String> files = toSync.files(false);
        for (String fileName : files) {
            assert (IndexWriter.slowFileExists(this.directory, fileName)) : "file " + fileName + " does not exist; files=" + Arrays.toString(this.directory.listAll());
            assert (this.deleter.exists(fileName)) : "IndexFileDeleter doesn't know about file " + fileName;
        }
        return true;
    }

    synchronized SegmentInfos toLiveInfos(SegmentInfos sis) {
        SegmentInfos newSIS = new SegmentInfos();
        HashMap<SegmentCommitInfo, SegmentCommitInfo> liveSIS = new HashMap<SegmentCommitInfo, SegmentCommitInfo>();
        for (SegmentCommitInfo info2 : this.segmentInfos) {
            liveSIS.put(info2, info2);
        }
        for (SegmentCommitInfo info2 : sis) {
            SegmentCommitInfo liveInfo = (SegmentCommitInfo)liveSIS.get(info2);
            if (liveInfo != null) {
                info2 = liveInfo;
            }
            newSIS.add(info2);
        }
        return newSIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommit(SegmentInfos toSync) throws IOException {
        this.testPoint("startStartCommit");
        assert (this.pendingCommit == null);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
        }
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "startCommit(): start");
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.lastCommitChangeCount > this.changeCount.get()) {
                    throw new IllegalStateException("lastCommitChangeCount=" + this.lastCommitChangeCount + ",changeCount=" + this.changeCount);
                }
                if (this.pendingCommitChangeCount == this.lastCommitChangeCount) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "  skip startCommit(): no changes pending");
                    }
                    try {
                        this.deleter.decRef(this.filesToCommit);
                    }
                    finally {
                        this.filesToCommit = null;
                    }
                    return;
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "startCommit index=" + this.segString(this.toLiveInfos(toSync)) + " changeCount=" + this.changeCount);
                }
                assert (this.filesExist(toSync));
            }
            this.testPoint("midStartCommit");
            boolean pendingCommitSet = false;
            try {
                Collection<String> filesToSync;
                this.testPoint("midStartCommit2");
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    assert (this.pendingCommit == null);
                    assert (this.segmentInfos.getGeneration() == toSync.getGeneration());
                    toSync.prepareCommit(this.directory);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "startCommit: wrote pending segments file \"" + IndexFileNames.fileNameFromGeneration("pending_segments", "", toSync.getGeneration()) + "\"");
                    }
                    pendingCommitSet = true;
                    this.pendingCommit = toSync;
                }
                boolean success = false;
                try {
                    filesToSync = toSync.files(false);
                    this.directory.sync(filesToSync);
                    success = true;
                }
                finally {
                    if (!success) {
                        pendingCommitSet = false;
                        this.pendingCommit = null;
                        toSync.rollbackCommit(this.directory);
                    }
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "done all syncs: " + filesToSync);
                }
                this.testPoint("midStartCommitSuccess");
            }
            finally {
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    this.segmentInfos.updateGeneration(toSync);
                    if (!pendingCommitSet) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception committing segments file");
                        }
                        this.deleter.decRefWhileHandlingException(this.filesToCommit);
                        this.filesToCommit = null;
                    }
                }
            }
        }
        catch (OutOfMemoryError oom) {
            this.tragicEvent(oom, "startCommit");
        }
        this.testPoint("finishStartCommit");
    }

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock(WRITE_LOCK_NAME).isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tragicEvent(Throwable tragedy, String location) throws IOException {
        if (tragedy instanceof AbortingException) {
            tragedy = tragedy.getCause();
        }
        assert (!Thread.holdsLock(this));
        assert (tragedy != null);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "hit tragic " + tragedy.getClass().getSimpleName() + " inside " + location);
        }
        Object object = this;
        synchronized (object) {
            if (this.tragedy == null) {
                this.tragedy = tragedy;
            }
        }
        object = this.commitLock;
        synchronized (object) {
            if (!this.closing) {
                try {
                    this.rollback();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
        }
        IOUtils.reThrow(tragedy);
    }

    public Throwable getTragicException() {
        return this.tragedy;
    }

    public boolean isOpen() {
        return !this.closing && !this.closed;
    }

    private final void testPoint(String message) {
        if (this.enableTestPoints) {
            assert (this.infoStream.isEnabled("TP"));
            this.infoStream.message("TP", message);
        }
    }

    synchronized boolean nrtIsCurrent(SegmentInfos infos) {
        boolean isCurrent;
        this.ensureOpen();
        boolean bl = isCurrent = infos.version == this.segmentInfos.version && !this.docWriter.anyChanges() && !this.bufferedUpdatesStream.any();
        if (this.infoStream.isEnabled("IW") && !isCurrent) {
            this.infoStream.message("IW", "nrtIsCurrent: infoVersion matches: " + (infos.version == this.segmentInfos.version) + "; DW changes: " + this.docWriter.anyChanges() + "; BD changes: " + this.bufferedUpdatesStream.any());
        }
        return isCurrent;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void deleteUnusedFiles() throws IOException {
        this.ensureOpen(false);
        this.deleter.deletePendingFiles();
        this.deleter.revisitPolicy();
    }

    private synchronized void deletePendingFiles() throws IOException {
        this.deleter.deletePendingFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void createCompoundFile(InfoStream infoStream, TrackingDirectoryWrapper directory, SegmentInfo info2, IOContext context) throws IOException {
        block7: {
            HashSet<String> cfsFiles;
            if (!directory.getCreatedFiles().isEmpty()) {
                throw new IllegalStateException("pass a clean trackingdir for CFS creation");
            }
            if (infoStream.isEnabled("IW")) {
                infoStream.message("IW", "create compound file");
            }
            boolean success = false;
            try {
                info2.getCodec().compoundFormat().write(directory, info2, context);
                success = true;
                if (success) break block7;
                cfsFiles = new HashSet<String>(directory.getCreatedFiles());
            }
            catch (Throwable throwable) {
                if (!success) {
                    HashSet<String> cfsFiles2 = new HashSet<String>(directory.getCreatedFiles());
                    for (String file2 : cfsFiles2) {
                        IOUtils.deleteFilesIgnoringExceptions(directory, file2);
                    }
                }
                throw throwable;
            }
            for (String file3 : cfsFiles) {
                IOUtils.deleteFilesIgnoringExceptions(directory, file3);
            }
        }
        HashSet<String> siFiles = new HashSet<String>(directory.getCreatedFiles());
        info2.setFiles(siFiles);
    }

    final synchronized void deleteNewFiles(Collection<String> files) throws IOException {
        this.deleter.deleteNewFiles(files);
    }

    final synchronized void flushFailed(SegmentInfo info2) throws IOException {
        this.deleter.refresh(info2.name);
    }

    final int purge(boolean forced) throws IOException {
        return this.docWriter.purgeBuffer(this, forced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void applyDeletesAndPurge(boolean forcePurge) throws IOException {
        try {
            this.purge(forcePurge);
        }
        finally {
            if (this.applyAllDeletesAndUpdates()) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
            }
            this.flushCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doAfterSegmentFlushed(boolean triggerMerge, boolean forcePurge) throws IOException {
        try {
            this.purge(forcePurge);
        }
        finally {
            if (triggerMerge) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
            }
        }
    }

    synchronized void incRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.incRef(segmentInfos, false);
    }

    synchronized void decRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.decRef(segmentInfos);
    }

    private boolean processEvents(boolean triggerMerge, boolean forcePurge) throws IOException {
        return this.processEvents(this.eventQueue, triggerMerge, forcePurge);
    }

    private boolean processEvents(Queue<Event> queue, boolean triggerMerge, boolean forcePurge) throws IOException {
        boolean processed = false;
        if (this.tragedy == null) {
            Event event;
            while ((event = queue.poll()) != null) {
                processed = true;
                event.process(this, triggerMerge, forcePurge);
            }
        }
        return processed;
    }

    private static boolean slowFileExists(Directory dir2, String fileName) throws IOException {
        try {
            dir2.openInput(fileName, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e2) {
            return false;
        }
    }

    private void reserveDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        if (this.pendingNumDocs.addAndGet(addedNumDocs) > (long)actualMaxDocs) {
            this.pendingNumDocs.addAndGet(-addedNumDocs);
            this.tooManyDocs(addedNumDocs);
        }
    }

    private void testReserveDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        if (this.pendingNumDocs.get() + addedNumDocs > (long)actualMaxDocs) {
            this.tooManyDocs(addedNumDocs);
        }
    }

    private void tooManyDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        throw new IllegalArgumentException("number of documents in the index cannot exceed " + actualMaxDocs + " (current document count is " + this.pendingNumDocs.get() + "; added numDocs is " + addedNumDocs + ")");
    }

    private Directory addMergeRateLimiters(Directory in) {
        return new FilterDirectory(in){

            @Override
            public IndexOutput createOutput(String name2, IOContext context) throws IOException {
                this.ensureOpen();
                IndexWriter.this.ensureOpen(false);
                assert (context.context == IOContext.Context.MERGE) : "got context=" + (Object)((Object)context.context);
                MergeRateLimiter rateLimiter = IndexWriter.this.rateLimiters.get();
                assert (rateLimiter != null);
                return new RateLimitedIndexOutput(rateLimiter, this.in.createOutput(name2, context));
            }
        };
    }

    static interface Event {
        public void process(IndexWriter var1, boolean var2, boolean var3) throws IOException;
    }

    public static abstract class IndexReaderWarmer {
        protected IndexReaderWarmer() {
        }

        public abstract void warm(LeafReader var1) throws IOException;
    }

    private static class MergedDeletesAndUpdates {
        ReadersAndUpdates mergedDeletesAndUpdates = null;
        MergePolicy.DocMap docMap = null;
        boolean initializedWritableLiveDocs = false;

        MergedDeletesAndUpdates() {
        }

        final void init(ReaderPool readerPool, MergePolicy.OneMerge merge2, MergeState mergeState, boolean initWritableLiveDocs) throws IOException {
            if (this.mergedDeletesAndUpdates == null) {
                this.mergedDeletesAndUpdates = readerPool.get(merge2.info, true);
                this.docMap = merge2.getDocMap(mergeState);
                assert (this.docMap.isConsistent(merge2.info.info.maxDoc()));
            }
            if (initWritableLiveDocs && !this.initializedWritableLiveDocs) {
                this.mergedDeletesAndUpdates.initWritableLiveDocs();
                this.initializedWritableLiveDocs = true;
            }
        }
    }

    class ReaderPool
    implements Closeable {
        private final Map<SegmentCommitInfo, ReadersAndUpdates> readerMap = new HashMap<SegmentCommitInfo, ReadersAndUpdates>();

        ReaderPool() {
        }

        public synchronized boolean infoIsLive(SegmentCommitInfo info2) {
            int idx = IndexWriter.this.segmentInfos.indexOf(info2);
            assert (idx != -1) : "info=" + info2 + " isn't live";
            assert (IndexWriter.this.segmentInfos.info(idx) == info2) : "info=" + info2 + " doesn't match live info in segmentInfos";
            return true;
        }

        public synchronized void drop(SegmentCommitInfo info2) throws IOException {
            ReadersAndUpdates rld = this.readerMap.get(info2);
            if (rld != null) {
                assert (info2 == rld.info);
                this.readerMap.remove(info2);
                rld.dropReaders();
            }
        }

        public synchronized boolean anyPendingDeletes() {
            for (ReadersAndUpdates rld : this.readerMap.values()) {
                if (rld.getPendingDeleteCount() == 0) continue;
                return true;
            }
            return false;
        }

        public synchronized void release(ReadersAndUpdates rld) throws IOException {
            this.release(rld, true);
        }

        public synchronized void release(ReadersAndUpdates rld, boolean assertInfoLive) throws IOException {
            rld.decRef();
            assert (rld.refCount() >= 1);
            if (!IndexWriter.this.poolReaders && rld.refCount() == 1) {
                if (rld.writeLiveDocs(IndexWriter.this.directory)) {
                    assert (!assertInfoLive || this.infoIsLive(rld.info));
                    IndexWriter.this.checkpointNoSIS();
                }
                rld.dropReaders();
                this.readerMap.remove(rld.info);
            }
        }

        @Override
        public void close() throws IOException {
            this.dropAll(false);
        }

        synchronized void dropAll(boolean doSave) throws IOException {
            Throwable priorE = null;
            Iterator<Map.Entry<SegmentCommitInfo, ReadersAndUpdates>> it = this.readerMap.entrySet().iterator();
            while (it.hasNext()) {
                ReadersAndUpdates rld;
                block10: {
                    rld = it.next().getValue();
                    try {
                        if (doSave && rld.writeLiveDocs(IndexWriter.this.directory)) {
                            assert (this.infoIsLive(rld.info));
                            IndexWriter.this.checkpointNoSIS();
                        }
                    }
                    catch (Throwable t) {
                        if (doSave) {
                            IOUtils.reThrow(t);
                        }
                        if (priorE != null) break block10;
                        priorE = t;
                    }
                }
                it.remove();
                try {
                    rld.dropReaders();
                }
                catch (Throwable t) {
                    if (doSave) {
                        IOUtils.reThrow(t);
                        continue;
                    }
                    if (priorE != null) continue;
                    priorE = t;
                }
            }
            assert (this.readerMap.size() == 0);
            IOUtils.reThrow(priorE);
        }

        public synchronized void commit(SegmentInfos infos) throws IOException {
            for (SegmentCommitInfo info2 : infos) {
                ReadersAndUpdates rld = this.readerMap.get(info2);
                if (rld == null) continue;
                assert (rld.info == info2);
                if (!rld.writeLiveDocs(IndexWriter.this.directory)) continue;
                assert (this.infoIsLive(info2));
                IndexWriter.this.checkpointNoSIS();
            }
        }

        public synchronized ReadersAndUpdates get(SegmentCommitInfo info2, boolean create) {
            IndexWriter.this.ensureOpen(false);
            assert (info2.info.dir == IndexWriter.this.directory) : "info.dir=" + info2.info.dir + " vs " + IndexWriter.access$100(IndexWriter.this);
            ReadersAndUpdates rld = this.readerMap.get(info2);
            if (rld == null) {
                if (!create) {
                    return null;
                }
                rld = new ReadersAndUpdates(IndexWriter.this, info2);
                this.readerMap.put(info2, rld);
            } else assert (rld.info == info2) : "rld.info=" + rld.info + " info=" + info2 + " isLive?=" + this.infoIsLive(rld.info) + " vs " + this.infoIsLive(info2);
            if (create) {
                rld.incRef();
            }
            assert (this.noDups());
            return rld;
        }

        private boolean noDups() {
            HashSet<String> seen = new HashSet<String>();
            for (SegmentCommitInfo info2 : this.readerMap.keySet()) {
                assert (!seen.contains(info2.info.name));
                seen.add(info2.info.name);
            }
            return true;
        }
    }
}

