/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;

public class BeanUtil {
    public static String okNameForGetter(AnnotatedMethod am, boolean stdNaming) {
        String name2 = am.getName();
        String str2 = BeanUtil.okNameForIsGetter(am, name2, stdNaming);
        if (str2 == null) {
            str2 = BeanUtil.okNameForRegularGetter(am, name2, stdNaming);
        }
        return str2;
    }

    public static String okNameForRegularGetter(AnnotatedMethod am, String name2, boolean stdNaming) {
        if (name2.startsWith("get")) {
            if ("getCallbacks".equals(name2) ? BeanUtil.isCglibGetCallbacks(am) : "getMetaClass".equals(name2) && BeanUtil.isGroovyMetaClassGetter(am)) {
                return null;
            }
            return stdNaming ? BeanUtil.stdManglePropertyName(name2, 3) : BeanUtil.legacyManglePropertyName(name2, 3);
        }
        return null;
    }

    public static String okNameForIsGetter(AnnotatedMethod am, String name2, boolean stdNaming) {
        Class<?> rt;
        if (name2.startsWith("is") && ((rt = am.getRawType()) == Boolean.class || rt == Boolean.TYPE)) {
            return stdNaming ? BeanUtil.stdManglePropertyName(name2, 2) : BeanUtil.legacyManglePropertyName(name2, 2);
        }
        return null;
    }

    public static String okNameForSetter(AnnotatedMethod am, boolean stdNaming) {
        String name2 = BeanUtil.okNameForMutator(am, "set", stdNaming);
        if (!(name2 == null || "metaClass".equals(name2) && BeanUtil.isGroovyMetaClassSetter(am))) {
            return name2;
        }
        return null;
    }

    public static String okNameForMutator(AnnotatedMethod am, String prefix, boolean stdNaming) {
        String name2 = am.getName();
        if (name2.startsWith(prefix)) {
            return stdNaming ? BeanUtil.stdManglePropertyName(name2, prefix.length()) : BeanUtil.legacyManglePropertyName(name2, prefix.length());
        }
        return null;
    }

    @Deprecated
    public static String okNameForGetter(AnnotatedMethod am) {
        return BeanUtil.okNameForGetter(am, false);
    }

    @Deprecated
    public static String okNameForRegularGetter(AnnotatedMethod am, String name2) {
        return BeanUtil.okNameForRegularGetter(am, name2, false);
    }

    @Deprecated
    public static String okNameForIsGetter(AnnotatedMethod am, String name2) {
        return BeanUtil.okNameForIsGetter(am, name2, false);
    }

    @Deprecated
    public static String okNameForSetter(AnnotatedMethod am) {
        return BeanUtil.okNameForSetter(am, false);
    }

    @Deprecated
    public static String okNameForMutator(AnnotatedMethod am, String prefix) {
        return BeanUtil.okNameForMutator(am, prefix, false);
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod am) {
        Class<?> rt = am.getRawType();
        if (rt == null || !rt.isArray()) {
            return false;
        }
        Class<?> compType = rt.getComponentType();
        String pkgName = ClassUtil.getPackageName(compType);
        return pkgName != null && pkgName.contains(".cglib") && (pkgName.startsWith("net.sf.cglib") || pkgName.startsWith("org.hibernate.repackage.cglib") || pkgName.startsWith("org.springframework.cglib"));
    }

    protected static boolean isGroovyMetaClassSetter(AnnotatedMethod am) {
        Class<?> argType = am.getRawParameterType(0);
        String pkgName = ClassUtil.getPackageName(argType);
        return pkgName != null && pkgName.startsWith("groovy.lang");
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod am) {
        Class<?> rt = am.getRawType();
        if (rt == null || rt.isArray()) {
            return false;
        }
        String pkgName = ClassUtil.getPackageName(rt);
        return pkgName != null && pkgName.startsWith("groovy.lang");
    }

    protected static String legacyManglePropertyName(String basename, int offset) {
        char d;
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c = basename.charAt(offset);
        if (c == (d = Character.toLowerCase(c))) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(d);
        for (int i = offset + 1; i < end; ++i) {
            c = basename.charAt(i);
            if (c == (d = Character.toLowerCase(c))) {
                sb.append(basename, i, end);
                break;
            }
            sb.append(d);
        }
        return sb.toString();
    }

    protected static String stdManglePropertyName(String basename, int offset) {
        char c1;
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c0 = basename.charAt(offset);
        if (c0 == (c1 = Character.toLowerCase(c0))) {
            return basename.substring(offset);
        }
        if (offset + 1 < end && Character.isUpperCase(basename.charAt(offset + 1))) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(c1);
        sb.append(basename, offset + 1, end);
        return sb.toString();
    }
}

