/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import opennlp.ccgbank.extract.ExtractGrammar;
import opennlp.ccgbank.extract.FreqTally;

public class RulesTally {
    public static int RULE_FREQ_CUTOFF = 1;
    public static boolean KEEP_UNMATCHED = true;
    private static Map<String, Integer> ruleFreq = new HashMap<String, Integer>();
    private static Map<String, List<String>> ruleOccur = new HashMap<String, List<String>>();
    private static String id = "";

    public static void reset() {
        ruleFreq = new HashMap<String, Integer>();
        ruleOccur = new HashMap<String, List<String>>();
        id = "";
    }

    public String storeId(String x) {
        if (x.length() > 0) {
            id = x;
            int posEquals = x.indexOf(61);
            if (posEquals > 0) {
                id = x.substring(posEquals + 1);
            }
        }
        return id;
    }

    public String loadTally(String res, String arg) throws FileNotFoundException {
        List<Object> temp;
        arg = arg.replaceAll("_\\d", "");
        res = res.replaceAll("_\\d", "");
        String rule = arg + "_to_" + res;
        if (!ruleFreq.containsKey(rule)) {
            ruleFreq.put(rule, 1);
            temp = new ArrayList<String>(4);
            temp.add(id);
            ruleOccur.put(rule, temp);
        } else {
            int freq = ruleFreq.get(rule) + 1;
            ruleFreq.put(rule, freq);
            temp = ruleOccur.get(rule);
        }
        if (temp.size() < 4 && !temp.contains(id)) {
            temp.add(id);
            ruleOccur.put(rule, temp);
        }
        return rule;
    }

    public static void printTally(ExtractGrammar.ExtractionProperties extractProps) throws FileNotFoundException {
        RulesTally.printTally(new File(extractProps.tempDir));
    }

    public static void printTally(File directory) throws FileNotFoundException {
        System.out.println("Generating RuleFreq.html");
        File freqFile = new File(directory, "RuleFreq.html");
        PrintWriter output = new PrintWriter(new FileOutputStream(freqFile));
        List<String> ruleList = FreqTally.sortTally(ruleFreq);
        output.flush();
        output.println("<html>");
        output.println("<head>");
        output.println("<title>");
        output.println("Unary Rule Info");
        output.println("</title>");
        output.println("</head>");
        output.println("<body>");
        output.flush();
        String ccgbankHome = System.getProperty("CCGBANK_HOME", "/home/corpora/EN/ccgbank");
        for (int i = 0; i < ruleList.size(); ++i) {
            String rule = ruleList.get(i);
            int freq = ruleFreq.get(rule);
            output.flush();
            output.println("<p>");
            output.println(i + 1 + " Rule: " + rule + " Freq: " + freq);
            output.println("<p>");
            output.flush();
            List<String> rules = ruleOccur.get(rule);
            output.flush();
            output.println("<ul>");
            output.println("<li>");
            output.flush();
            for (int j = 0; j < rules.size(); ++j) {
                output.println("<ul>");
                id = rules.get(j);
                String[] idInfo = id.split("\\.");
                StringTokenizer st = new StringTokenizer(id, ".");
                String idLink = "";
                String sentNo = "";
                String dir = "";
                if (idInfo.length == 2) {
                    idLink = st.nextToken() + ".html";
                    sentNo = "#Sentence " + st.nextToken();
                    dir = id.substring(4, 6);
                } else {
                    idLink = idInfo[0];
                    sentNo = "#Sentence " + idInfo[0];
                    dir = idInfo[0];
                }
                output.println("<li>");
                output.println(id);
                output.println(" <a href=file://" + ccgbankHome + "/original/data/HTML/" + dir + "/" + idLink + " target=" + sentNo + ">");
                output.println(idLink);
                output.println("</a>");
                output.println("</li>");
                output.println("</ul>");
            }
            output.flush();
            output.println("</li>");
            output.println("</ul>");
            output.println("");
            output.flush();
        }
        output.flush();
        output.println("</body>");
        output.println("</html>");
        output.flush();
        output.close();
    }

    public boolean checkRuleStatus(String rule) {
        Integer freq = ruleFreq.get(rule);
        return freq != null && freq == 1;
    }

    public boolean checkRuleFreqStatus(String rule) {
        int freq = ruleFreq.get(rule);
        return freq >= RULE_FREQ_CUTOFF;
    }

    public boolean keepUnmatched() {
        return KEEP_UNMATCHED;
    }
}

