/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.util.HashSet;
import java.util.Set;
import opennlp.ccgbank.extract.FreqTally;

public class MorphExtrHelper {
    private FreqTally aFreqTally = new FreqTally();
    private Set<String> seenLexPos = new HashSet<String>();
    public String whLex = "";

    public boolean checkFreqAndNoveltyStatus(String lex, String stem, String cat, String pos, String semClass) {
        if (!this.aFreqTally.checkFreqStatus(lex, cat, pos)) {
            return false;
        }
        String key = lex + "_" + stem + "__" + pos + "_" + semClass;
        if (this.seenLexPos.contains(key)) {
            return false;
        }
        this.seenLexPos.add(key);
        return true;
    }

    public String macroNamer(String macro, String semClass, String pos, String lex) {
        macro = semClass.startsWith("PER") && pos.startsWith("N") || pos.equals("DT") ? macro + " @anim-nom" : (pos.startsWith("PP") || lex.equals("those") || pos.startsWith("PRP") && !lex.startsWith("it") ? macro + " @anim-nom" : macro + " @non-anim-nom");
        macro = macro.trim();
        if (semClass.contains("STATE") || semClass.contains("NATION") || semClass.startsWith("ORG_DESC") || semClass.contains("DATE") || semClass.contains("TIME") || semClass.contains("QUANTITY") || semClass.contains("CARDINAL") || semClass.contains("PERCENT")) {
            macro = "";
        }
        if (lex.equals("audience") || lex.equals("band") || lex.equals("group") || lex.equals("team") || lex.equals("club") || lex.equals("congregation")) {
            macro = "";
        }
        return macro;
    }

    public String agrMacroDecider(String macro, String semClass, String pos, String lex) {
        if (pos.equals("NN")) {
            if (lex.equals("couple") || semClass.startsWith("ORG_DESC") || lex.equals("following") || lex.equals("rest") || semClass.contains("STATE") || semClass.contains("NATION") || semClass.contains("DATE") || semClass.contains("TIME") || semClass.contains("QUANTITY") || semClass.contains("CARDINAL") || semClass.contains("PERCENT") || semClass.endsWith("'S")) {
                macro = "";
            }
            if (semClass.length() == 0) {
                macro = "";
            }
        }
        return macro;
    }

    public void storeWHLex(String whLex) {
        this.whLex = whLex;
    }

    public String getWHLex() {
        return this.whLex;
    }
}

