/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.ccgbank.extract.CatNode;
import opennlp.ccgbank.extract.ExtractGrammar;

public class FreqTally {
    public static int CAT_FREQ_CUTOFF = 1;
    public static int LEX_FREQ_CUTOFF = 1;
    public static int OPEN_FREQ_CUTOFF = 100;
    private static Map<String, CatNode> catInfo = new HashMap<String, CatNode>();
    private static Map<String, Integer> catFreq = new HashMap<String, Integer>();
    private static String id = "";
    private static Set<String> observedLexCombos = new HashSet<String>();

    public static void reset() {
        catInfo = new HashMap<String, CatNode>();
        catFreq = new HashMap<String, Integer>();
        id = "";
        observedLexCombos = new HashSet<String>();
    }

    public String storeId(String x) {
        if (x.length() > 0) {
            id = x;
            int posEquals = x.indexOf(61);
            if (posEquals > 0) {
                id = x.substring(posEquals + 1);
            }
        }
        return id;
    }

    public String changeCase(String lex, String pos) {
        return lex;
    }

    public boolean loadTally(String lex, String cat, String pos) {
        boolean retval;
        CatNode cn;
        String key = FreqTally.catPosKey(cat, pos);
        if (!catFreq.containsKey(key)) {
            cn = new CatNode(cat, pos);
            catInfo.put(key, cn);
            catFreq.put(key, 1);
            retval = true;
        } else {
            cn = catInfo.get(key);
            catFreq.put(key, catFreq.get(key) + 1);
            retval = false;
        }
        cn.lexInsert(lex, id);
        return retval;
    }

    public static String catPosKey(String cat, String pos) {
        return cat + "-" + pos;
    }

    public static List<String> sortTally(Map<String, Integer> x) {
        ArrayList<String> sortedList = new ArrayList<String>();
        ArrayList<Integer> vals1 = new ArrayList<Integer>(x.values());
        Collections.sort(vals1);
        ArrayList<Integer> vals = new ArrayList<Integer>(vals1.size());
        int prev = -1;
        for (Integer freq : vals1) {
            if (freq != prev) {
                vals.add(freq);
            }
            prev = freq;
        }
        for (int i = vals.size() - 1; i >= 0; --i) {
            int sortedFreq = (Integer)vals.get(i);
            for (String key : x.keySet()) {
                int freq = x.get(key);
                if (freq != sortedFreq) continue;
                sortedList.add(key);
            }
        }
        return sortedList;
    }

    public static void printTally(ExtractGrammar.ExtractionProperties extractProps) throws FileNotFoundException {
        FreqTally.printTally(new File(extractProps.tempDir));
    }

    public static void printTally(File directory) throws FileNotFoundException {
        System.out.println("Generating CorpFreq.html");
        File freqFile = new File(directory, "CorpFreq.html");
        PrintWriter output = new PrintWriter(new FileOutputStream(freqFile));
        List<String> sortedCatKeys = FreqTally.sortTally(catFreq);
        output.println("<html>");
        output.println("<head>");
        output.println("<title>");
        output.println("Lexical Info");
        output.println("</title>");
        output.println("</head>");
        output.println("<body>");
        output.flush();
        for (int i = 0; i < sortedCatKeys.size(); ++i) {
            String key = sortedCatKeys.get(i);
            CatNode cn = catInfo.get(key);
            String cat = cn.cat;
            String pos = cn.pos;
            int freq = catFreq.get(key);
            output.println("<p>");
            output.println(i + 1 + " Category: " + cat + " POS: " + pos + " Freq: " + freq);
            output.println("</p>");
            output.println();
            cn.printTally(output);
            output.flush();
        }
        output.println("</body>");
        output.println("</html>");
    }

    public boolean firstLexCombo(String lex, String stem, String rel, String cat, String pos, String semClass) {
        String key = lex + "_" + stem + "_" + rel + "_" + cat + "_" + pos + "_" + semClass;
        if (observedLexCombos.contains(key)) {
            return false;
        }
        observedLexCombos.add(key);
        return true;
    }

    private int getFreq(String key) {
        Integer freq = catFreq.get(key);
        return freq != null ? freq : 0;
    }

    public int getFreq(String cat, String pos) {
        String key = FreqTally.catPosKey(cat, pos);
        return this.getFreq(key);
    }

    public boolean checkFreqStatus(String cat, String pos) {
        return this.getFreq(cat, pos) >= CAT_FREQ_CUTOFF;
    }

    public boolean checkFreqStatus(String lex, String cat, String pos) {
        String key = FreqTally.catPosKey(cat, pos);
        if (cat.contains("pp[")) {
            return true;
        }
        if (this.getFreq(key) < CAT_FREQ_CUTOFF) {
            return false;
        }
        CatNode cn = catInfo.get(key);
        return cn.getLexFreq(lex) >= LEX_FREQ_CUTOFF;
    }

    public boolean isOpen(String cat, String pos) {
        if (this.getFreq(cat, pos) < OPEN_FREQ_CUTOFF) {
            return false;
        }
        if (pos.startsWith("NN") || pos.equals("CD")) {
            return true;
        }
        return pos.startsWith("JJ") && (cat.equals("n_~1/n_1") || cat.equals("s[adj]_1\np_2"));
    }
}

