/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.convert;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MorphLookup {
    private static Map<String, String> stemMap = null;
    static File words;
    static File stems;

    public static void init(File wordsFile, File stemsFile) throws IOException {
        String wordsLine;
        words = wordsFile;
        stems = stemsFile;
        if (words == null) {
            throw new IllegalArgumentException("words file not specified");
        }
        if (stems == null) {
            throw new IllegalArgumentException("stems file not specified");
        }
        stemMap = new HashMap<String, String>();
        BufferedReader wordsReader = new BufferedReader(new FileReader(words));
        BufferedReader stemsReader = new BufferedReader(new FileReader(stems));
        while ((wordsLine = wordsReader.readLine()) != null) {
            String stemsLine = stemsReader.readLine();
            String[] tokens = wordsLine.split("\\s+");
            String word = tokens[0];
            String pos = tokens[1];
            String stem = stemsLine.trim().toLowerCase();
            String key = word + "_" + pos;
            String key2 = word.toLowerCase() + "_" + pos;
            stemMap.put(key, stem);
            stemMap.put(key2, stem);
        }
        wordsReader.close();
        stemsReader.close();
    }

    public String getStem(String word, String pos) {
        String retval = "";
        String key = word + "_" + pos;
        if (stemMap.containsKey(key)) {
            retval = stemMap.get(word + "_" + pos);
        }
        if (retval.length() == 0) {
            System.out.println("addStems: No stem for: " + key);
        }
        return retval;
    }
}

