/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class MWHelper {
    private String lex = "";
    private String pos = "";
    private String term_no = "";
    private ArrayList<Integer> prtTally = new ArrayList();
    private Hashtable<Integer, String> prtIndex = new Hashtable();

    public void initSettings() {
        this.prtTally = new ArrayList();
        this.prtIndex = new Hashtable();
    }

    public void concatWords(String lex, String pos, String term_no) {
        this.lex = this.lex + "_" + lex;
        this.pos = this.pos + " " + pos;
        this.term_no = this.term_no + " " + term_no;
    }

    public String getInfo(int choice) {
        String retVal = "";
        switch (choice) {
            case 1: {
                retVal = this.lex.trim().replaceFirst("_", "");
                this.lex = "";
                break;
            }
            case 2: {
                retVal = this.pos.trim();
                this.pos = "";
                break;
            }
            case 3: {
                retVal = this.term_no.trim();
                this.term_no = "";
            }
        }
        return retVal;
    }

    public void storePrt(String prt_term_no, String prt) {
        this.prtTally.add(Integer.parseInt(prt_term_no));
        this.prtIndex.put(Integer.parseInt(prt_term_no), prt);
    }

    public String peekPrt(int nextPrnNo) {
        String retVal = "";
        if (this.prtIndex.containsKey(nextPrnNo)) {
            retVal = this.prtIndex.get(nextPrnNo);
        }
        return retVal;
    }

    public String getPrt() {
        Collections.sort(this.prtTally);
        String retVal = "";
        if (this.prtTally.size() > 0) {
            retVal = this.prtTally.get(this.prtTally.size() - 1).toString();
            this.prtTally.remove(this.prtTally.size() - 1);
        }
        return retVal;
    }
}

