/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.convert;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class ApposTally {
    private String id = "";
    private String balStatus = "";
    private String lexMtl = "";
    private ArrayList<String> featInfo = new ArrayList();
    private ArrayList<String> headInfo1 = new ArrayList();
    private ArrayList<String> headInfo2 = new ArrayList();
    private static ArrayList<String> cueList = new ArrayList();

    public void openCueFile(String fileName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = "";
        while ((line = br.readLine()) != null) {
            if (cueList.contains(line)) continue;
            cueList.add(line);
        }
        br.close();
    }

    public String storeId(String x) {
        this.id = "";
        this.id = x;
        return null;
    }

    public void flushVars() {
        this.balStatus = "conj";
        this.lexMtl = "";
        this.headInfo1.clear();
        this.headInfo2.clear();
        this.featInfo.clear();
    }

    public void storeBalance(String status) {
        this.balStatus = status;
    }

    public String getBalance() {
        return this.balStatus;
    }

    public String getCaps(String x) {
        return x.toUpperCase();
    }

    public void storeLex(String word, String pos) {
        String info = "";
        info = pos.equals("X") ? word : word + "/" + pos;
        this.lexMtl = this.lexMtl + " " + info;
    }

    public void printLex() {
        this.lexMtl = this.id + " " + this.lexMtl;
        this.lexMtl = "";
    }

    public void storeHead(String word, String pos, int npNo) {
        String info = "";
        if (pos.equals("NNS")) {
            pos = "NN";
        }
        if (pos.equals("NNPS")) {
            pos = "NNP";
        }
        info = word + "/" + pos;
        if (npNo == 1) {
            this.headInfo1.add(info);
        } else {
            this.headInfo2.add(info);
        }
    }

    public String cueAnalysis() {
        String[] sent = this.lexMtl.split("X");
        if (sent[0].contains("'s/POS") && this.headInfo1.size() > 0) {
            this.headInfo1.remove(0);
        }
        if (sent[1].contains("'s/POS") && this.headInfo2.size() > 0) {
            this.headInfo2.remove(0);
        }
        String res = "";
        boolean flag = false;
        String[] np1head = new String[2];
        if (this.headInfo1.size() == 0 || this.headInfo2.size() == 0) {
            this.headInfo1.add("X1/ECK");
            np1head = this.headInfo1.get(this.headInfo1.size() - 1).split("/");
        } else {
            np1head = this.headInfo1.get(this.headInfo1.size() - 1).split("/");
        }
        for (String x : this.headInfo2) {
            String[] np2head = x.split("/");
            if (np2head[1].equals(np1head[1])) {
                flag = true;
                continue;
            }
            flag = false;
            break;
        }
        if (flag && this.headInfo1.size() == 1 && this.headInfo2.size() == 1) {
            flag = false;
        }
        if (flag && sent[0].contains("/CC") && !sent[0].contains(",")) {
            flag = false;
        }
        if (!flag && sent[1].contains("/CC")) {
            this.headInfo2.add("X2/ECK");
            String[] np2head = this.headInfo2.get(0).split("/");
            if (np2head[1].equals(np1head[1])) {
                flag = true;
            }
        }
        res = flag ? "conj" : "appos";
        return res;
    }
}

