/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import opennlp.ccgbank.InputSourceAdapter;
import opennlp.ccgbank.XSLTProcessor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class TemplatesProcessor
extends XSLTProcessor {
    List<Templates> templates = null;

    TemplatesProcessor(ErrorListener errorListener) {
        super(errorListener);
    }

    void addTemplates(Templates t) {
        if (this.templates == null) {
            this.templates = new ArrayList<Templates>();
        }
        this.templates.add(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void process(InputSource inputSource) throws IOException, SAXException, TransformerException {
        if (this.templates == null) {
            this.templates = this.makeTemplates(this.taskTemplatesList);
        }
        InputSourceAdapter input = new InputSourceAdapter(inputSource);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytesIn = null;
        try {
            Iterator<Templates> i = this.templates.iterator();
            StreamSource memorySource = null;
            while (i.hasNext()) {
                StreamSource source;
                if (bytesIn == null) {
                    source = input;
                } else {
                    ByteArrayInputStream in = new ByteArrayInputStream(bytesIn);
                    if (memorySource == null) {
                        memorySource = new StreamSource(in);
                    } else {
                        memorySource.setInputStream(in);
                    }
                    source = memorySource;
                }
                Templates template = i.next();
                Transformer transformer = template.newTransformer();
                transformer.setOutputProperties(xmlProperties);
                transformer.setErrorListener(this.errorListener);
                boolean ihn = i.hasNext();
                StreamResult result = ihn ? new StreamResult(buffer) : new StreamResult(new BufferedOutputStream(this.serializer.getOutputStream()));
                transformer.transform(source, result);
                if (!ihn) continue;
                bytesIn = buffer.toByteArray();
                buffer.reset();
            }
        }
        finally {
            bytesIn = null;
            try {
                buffer.close();
            }
            catch (IOException iOException) {}
        }
    }
}

