/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XmlScanner
extends DefaultHandler {
    private boolean seenRoot = false;
    private Element current = null;

    public void handleRoot(Element e) {
    }

    public abstract void handleElement(Element var1);

    public void parse(URL url) throws IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.parse(url.toString());
        }
        catch (ParserConfigurationException exc) {
            throw (IOException)new IOException().initCause(exc);
        }
        catch (SAXException exc) {
            throw (IOException)new IOException().initCause(exc);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if (!this.seenRoot) {
            this.seenRoot = true;
            Element root = this.createElement(uri, localName, qname, attributes);
            this.handleRoot(root);
            return;
        }
        Element parent = this.current;
        this.current = this.createElement(uri, localName, qname, attributes);
        if (parent != null) {
            parent.addContent((Content)this.current);
        }
    }

    protected Element createElement(String uri, String localName, String qname, Attributes attributes) {
        Element retval = new Element(qname);
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                String attrQName = attributes.getQName(i);
                if (attrQName.indexOf(58) >= 0) continue;
                String attrValue = attributes.getValue(i);
                retval.setAttribute(attrQName, attrValue);
            }
        }
        return retval;
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.current == null) {
            return;
        }
        Element parent = (Element)this.current.getParent();
        if (parent == null) {
            this.handleElement(this.current);
        }
        this.current = parent;
    }

    public static void main(String[] args) throws IOException {
        String filename = args[0];
        MyScanner myScanner = new MyScanner();
        myScanner.parse(new File(filename).toURI().toURL());
        System.out.println("top-level elements: " + myScanner.count);
        System.out.println("second-level elements: " + myScanner.second);
    }

    public static class MyScanner
    extends XmlScanner {
        int count = 0;
        int second = 0;

        @Override
        public void handleRoot(Element e) {
            System.out.println("root name: " + e.getName());
            System.out.print("root attributes: ");
            List attrs = e.getAttributes();
            for (Attribute attr : attrs) {
                System.out.print(attr.getName() + "=" + attr.getValue() + " ");
            }
            System.out.println();
        }

        @Override
        public void handleElement(Element e) {
            ++this.count;
            this.second += e.getContentSize();
        }
    }
}

