/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;

public class StructureSharingList<T>
extends AbstractList<T>
implements Serializable {
    private static final long serialVersionUID = 6692080357319326492L;
    public final List<T> first;
    public final List<T> second;
    private int hashcode = -1;
    private final int size;

    public StructureSharingList(List<T> first, List<T> second) {
        this.first = first;
        this.second = second;
        this.size = first.size() + second.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int i) {
        if (i < this.first.size()) {
            return this.first.get(i);
        }
        return this.second.get(i - this.first.size());
    }

    @Override
    public int hashCode() {
        if (this.hashcode != -1) {
            return this.hashcode;
        }
        int hc = 1;
        for (int i = 0; i < this.size(); ++i) {
            hc = 31 * hc + System.identityHashCode(this.get(i));
        }
        this.hashcode = hc;
        return hc;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        if (list instanceof StructureSharingList) {
            StructureSharingList ssl = (StructureSharingList)list;
            if (this.first == ssl.first && this.second == ssl.second) {
                return true;
            }
        }
        if (this.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == list.get(i)) continue;
            return false;
        }
        return true;
    }
}

