/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import opennlp.ccg.util.Filter;

public class FilteredSet<E>
extends AbstractSet<E> {
    Collection<? extends E> originalCollection;
    Filter<? super E> filter;
    private final Set<E> set = new LinkedHashSet();

    public FilteredSet(Collection<? extends E> originalCollection, Filter<? super E> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        this.filter = filter;
        this.originalCollection = originalCollection;
        this.addAll(originalCollection);
    }

    public Collection<? extends E> getOriginalCollection() {
        return this.originalCollection;
    }

    public Filter<? super E> getFilter() {
        return this.filter;
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean add(E e) {
        return this.filter.allows(e) && this.set.add(e);
    }
}

