/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.unify;

import gnu.trove.TIntIntHashMap;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.CategoryFcnAdapter;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.GFeatStruc;
import opennlp.ccg.unify.GFeatVar;
import opennlp.ccg.unify.Indexed;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Mutable;
import opennlp.ccg.unify.Variable;

public class UnifyControl {
    private static int _varIndex = 0;
    private static ModFcn uniqueFcn = new ModFcn(){

        @Override
        public void modify(Mutable m) {
            if (m instanceof Indexed && m instanceof Variable) {
                ((Indexed)((Object)m)).setIndex(_varIndex);
            }
        }
    };
    private static int _fsIndex = 1;
    private static TIntIntHashMap _reindexed = new TIntIntHashMap();
    private static CategoryFcn indexFcn = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            int index;
            FeatureStructure fs = c.getFeatureStructure();
            if (fs != null && (index = fs.getIndex()) > 0) {
                int $index = _reindexed.get(index);
                if ($index == 0) {
                    $index = _fsIndex++;
                    _reindexed.put(index, $index);
                }
                fs.setIndex($index);
            }
        }
    };

    public static void startUnifySequence() {
        _varIndex = 0;
        _fsIndex = 1;
    }

    public static void reindex(Category cat) {
        UnifyControl.reindex(cat, null);
    }

    public static void reindex(Category cat, Category anotherCat) {
        _reindexed.clear();
        cat.forall(indexFcn);
        cat.deepMap(uniqueFcn);
        if (cat != anotherCat && anotherCat != null) {
            anotherCat.forall(indexFcn);
            anotherCat.deepMap(uniqueFcn);
        }
        ++_varIndex;
    }

    public static int getUniqueVarIndex() {
        return ++_varIndex;
    }

    public static int getUniqueFeatureStructureIndex() {
        return ++_fsIndex;
    }

    public static Object copy(Object o) {
        if (o instanceof Category) {
            return ((Category)o).copy();
        }
        if (o instanceof GFeatVar) {
            return ((GFeatVar)o).copy();
        }
        if (o instanceof LF) {
            return ((LF)o).copy();
        }
        if (o instanceof GFeatStruc) {
            return ((GFeatStruc)o).copy();
        }
        return o;
    }
}

