/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.ngrams.NgramPrecisionModel;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.realize.Chart;
import opennlp.ccg.realize.Realizer;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.test.RegressionInfo;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class GenTargets {
    private Grammar grammar;
    private Realizer realizer;
    private NgramScorer ngramScorer;
    private Set<String> uniqueTargets = new HashSet<String>();

    private GenTargets(URL grammarURL, File regressionFile) throws IOException {
        System.out.println("Loading grammar from: " + grammarURL);
        this.grammar = new Grammar(grammarURL);
        System.out.println("Loading target phrases from: " + regressionFile);
        RegressionInfo rinfo = new RegressionInfo(this.grammar, regressionFile);
        String[] targets = new String[rinfo.numberOfItems()];
        for (int i = 0; i < targets.length; ++i) {
            String target;
            targets[i] = target = rinfo.getItem((int)i).sentence;
        }
        this.ngramScorer = new NgramPrecisionModel(targets, true);
        this.realizer = new Realizer(this.grammar);
    }

    private void realize(Element lfElt, Element outRoot) throws IOException {
        LF lf = Realizer.getLfFromElt(lfElt);
        this.realizer.realize(lf, this.ngramScorer);
        Chart chart = this.realizer.getChart();
        String target = chart.bestEdge.getSign().getOrthography();
        if (this.uniqueTargets.contains(target)) {
            System.out.println("Duplicate realization: " + target);
            return;
        }
        this.uniqueTargets.add(target);
        System.out.println("Best realization: " + target);
        Element testElt = RegressionInfo.makeTestItem(this.grammar, target, 1, lf);
        outRoot.addContent((Content)testElt);
        if (!chart.bestEdge.complete()) {
            System.out.println("NB: realization incomplete!");
            testElt.setAttribute("complete", "false");
        }
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: java opennlp.ccg.test.GenTargets (-g <grammarfile>) (-tb <testbedfile>) <inputfile> <outputfile>";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String grammarfile = "grammar.xml";
        String testbedfile = "testbed.xml";
        String inputfile = null;
        String outputfile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-g")) {
                grammarfile = args[++i];
                continue;
            }
            if (args[i].equals("-tb")) {
                testbedfile = args[++i];
                continue;
            }
            if (inputfile == null) {
                inputfile = args[i];
                continue;
            }
            if (outputfile != null) continue;
            outputfile = args[i];
        }
        if (inputfile == null || outputfile == null) {
            System.out.println(usage);
            System.exit(0);
        }
        File gFile = new File(grammarfile);
        URL grammarURL = gFile.toURI().toURL();
        File tbFile = new File(testbedfile);
        if (!tbFile.exists()) {
            tbFile = new File(gFile.getParentFile(), testbedfile);
        }
        GenTargets gen = new GenTargets(grammarURL, tbFile);
        System.out.println("Loading LFs from: " + inputfile);
        Document doc = gen.grammar.loadFromXml(inputfile);
        Document outDoc = new Document();
        Element outRoot = new Element("regression");
        outDoc.setRootElement(outRoot);
        System.out.println("Realizing LFs ...");
        Element root = doc.getRootElement();
        List lfElts = root.getChildren("lf");
        for (int i = 0; i < lfElts.size(); ++i) {
            Element lfElt = (Element)lfElts.get(i);
            try {
                gen.realize(lfElt, outRoot);
                continue;
            }
            catch (Exception exc) {
                System.out.println("Warning: unable to realize LF " + i + ": " + exc);
            }
        }
        System.out.println("Saving results to: " + outputfile);
        FileOutputStream out = new FileOutputStream(outputfile);
        gen.grammar.serializeXml(outDoc, out);
        out.close();
        System.out.println("Done.");
    }
}

