/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import java.io.Serializable;
import opennlp.ccg.synsem.Modality;
import opennlp.ccg.synsem.VarModality;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Element;

public final class SlashMode
implements Modality,
Serializable {
    private static final long serialVersionUID = -2387797559890373347L;
    public static final byte All = 0;
    public static final byte ApplicationOnly = 1;
    public static final byte Associative = 2;
    public static final byte Permutative = 3;
    public static final byte PermutativeRight = 4;
    public static final byte PermutativeLeft = 5;
    public static final byte APRight = 6;
    public static final byte APLeft = 7;
    private byte _mode;

    public SlashMode(Element el) {
        String m = el.getAttributeValue("mode");
        if (m == null) {
            m = el.getAttributeValue("m");
        }
        if (m == null) {
            m = ".";
        }
        this._mode = SlashMode.byteVal(m);
    }

    public SlashMode() {
        this(".");
    }

    public SlashMode(String m) {
        this._mode = SlashMode.byteVal(m);
    }

    private SlashMode(byte m) {
        this._mode = m;
    }

    @Override
    public Object copy() {
        return new SlashMode(this._mode);
    }

    public int hashCode() {
        return 31 * this._mode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SlashMode m = (SlashMode)obj;
        return this._mode == m._mode;
    }

    @Override
    public boolean occurs(Variable var) {
        return false;
    }

    @Override
    public void unifyCheck(Object o) throws UnifyFailure {
        if (!(o instanceof VarModality || o instanceof SlashMode && SlashMode.modesMatch(this._mode, ((SlashMode)o)._mode))) {
            throw new UnifyFailure();
        }
    }

    @Override
    public Object unify(Object o, Substitution sub) throws UnifyFailure {
        if (o instanceof VarModality) {
            return ((VarModality)o).unify(this, sub);
        }
        if (o instanceof SlashMode) {
            if (SlashMode.modesMatch(this._mode, ((SlashMode)o)._mode)) {
                return this.copy();
            }
            throw new UnifyFailure();
        }
        throw new UnifyFailure();
    }

    @Override
    public Object fill(Substitution sub) throws UnifyFailure {
        return this.copy();
    }

    @Override
    public String toString(byte slashDir) {
        if (slashDir == this.getDirection()) {
            switch (this._mode) {
                case 4: {
                    return "x";
                }
                case 5: {
                    return "x";
                }
                case 6: {
                    return "";
                }
                case 7: {
                    return "";
                }
            }
            return this.toString();
        }
        return this.toString();
    }

    public String toString() {
        switch (this._mode) {
            case 0: {
                return ".";
            }
            case 1: {
                return "*";
            }
            case 2: {
                return "^";
            }
            case 3: {
                return "x";
            }
            case 4: {
                return "x>";
            }
            case 5: {
                return "<x";
            }
            case 6: {
                return ">";
            }
            case 7: {
                return "<";
            }
        }
        return ".";
    }

    @Override
    public String toTeX(byte slashDir) {
        if (slashDir == this.getDirection()) {
            switch (this._mode) {
                case 4: {
                    return "x";
                }
                case 5: {
                    return "x";
                }
                case 6: {
                    return "";
                }
                case 7: {
                    return "";
                }
            }
            return this.toTeX();
        }
        return this.toTeX();
    }

    @Override
    public String toTeX() {
        switch (this._mode) {
            case 0: {
                return ".";
            }
            case 1: {
                return "*";
            }
            case 2: {
                return "\\diamond";
            }
            case 3: {
                return "x";
            }
            case 4: {
                return "x>";
            }
            case 5: {
                return "<x";
            }
            case 6: {
                return ">";
            }
            case 7: {
                return "<";
            }
        }
        return ".";
    }

    private static byte byteVal(String m) {
        if (m.equals(".")) {
            return 0;
        }
        if (m.equals(">")) {
            return 6;
        }
        if (m.equals("<")) {
            return 7;
        }
        if (m.equals("*")) {
            return 1;
        }
        if (m.equals("^")) {
            return 2;
        }
        if (m.equals("x")) {
            return 3;
        }
        if (m.equals("x>")) {
            return 4;
        }
        if (m.equals("<x")) {
            return 5;
        }
        return 0;
    }

    @Override
    public byte getDirection() {
        switch (this._mode) {
            case 4: {
                return 2;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 0;
            }
        }
        return 1;
    }

    private static boolean modesMatch(byte m1, byte m2) {
        boolean doMatch = m1 == m2 ? true : (m1 == 0 || m2 == 0 ? true : (m1 == 1 && m2 == 1 ? true : (m1 == 1 || m2 == 1 ? false : (m1 == 2 ? m2 == 6 || m2 == 7 : (m1 == 6 ? m2 == 4 || m2 == 3 || m2 == 2 : (m1 == 7 ? m2 == 5 || m2 == 3 || m2 == 2 : (m1 == 4 ? m2 == 6 || m2 == 3 : (m1 == 5 || m2 == 3 ? m2 == 7 : (m1 == 3 ? m2 == 7 || m2 == 6 || m2 == 4 || m2 == 5 : false)))))))));
        return doMatch;
    }
}

