/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.TObjectIntHashMap;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.Rule;
import opennlp.ccg.grammar.RuleGroup;
import opennlp.ccg.grammar.TypeChangingRule;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.LexDependency;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.DerivationHistory;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.LexSemOrigin;
import opennlp.ccg.util.Interner;
import opennlp.ccg.util.Pair;
import opennlp.ccg.util.SingletonList;
import opennlp.ccg.util.StructureSharingList;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class Sign
implements LexSemOrigin,
Serializable {
    private static final long serialVersionUID = 1072712272514007274L;
    protected List<Word> _words;
    protected Category _cat;
    protected DerivationHistory _history;
    protected Sign _lexHead;
    protected LinkedList<Object> data = null;

    protected Sign() {
    }

    protected Sign(List<Word> words, Category cat, DerivationHistory dh, Sign lexHead) {
        this._words = (List)Interner.globalIntern(words);
        this._cat = cat;
        this._history = dh;
        this._lexHead = lexHead;
    }

    public Sign(List<Word> words, Category cat) {
        this(words, cat, null, null);
        this._history = new DerivationHistory(this);
        this._lexHead = this;
    }

    public Sign(Word word, Category cat) {
        this(new SingletonList<Word>(word), cat);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._words = (List)Interner.globalIntern(this._words);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        LinkedList<Object> tmp = this.data;
        if (tmp != null) {
            this.data = new LinkedList();
            for (Object e : tmp) {
                if (!(e instanceof Serializable)) continue;
                this.data.add(e);
            }
            if (this.data.isEmpty()) {
                this.data = null;
            }
        }
        stream.defaultWriteObject();
        this.data = tmp;
    }

    public static Sign createCoartSign(Category cat, Sign lexSign, Sign coartSign) {
        Sign retval;
        List<Word> words = lexSign.getWords();
        if (words.size() > 1) {
            throw new RuntimeException("Can't create coarticulation sign from multiple words.");
        }
        Word word = words.get(0);
        Word coartWord = coartSign.getWords().get(0);
        Word wordPlus = Word.createWordWithAttrs(word, coartWord);
        retval._lexHead = retval = new Sign(new SingletonList<Word>(wordPlus), cat, null, null);
        Rule coartRule = new Rule(){

            @Override
            public String name() {
                return "coart";
            }

            @Override
            public int arity() {
                return 1;
            }

            @Override
            public List<Category> applyRule(Category[] inputs) {
                throw new RuntimeException("Not supported.");
            }

            @Override
            public RuleGroup getRuleGroup() {
                throw new RuntimeException("Not supported.");
            }

            @Override
            public void setRuleGroup(RuleGroup ruleGroup) {
                throw new RuntimeException("Not supported.");
            }

            @Override
            public Element toXml() {
                throw new RuntimeException("Not supported.");
            }
        };
        retval._history = new DerivationHistory(new Sign[]{lexSign, coartSign}, retval, coartRule);
        return retval;
    }

    public static Sign createDerivedSign(Category cat, Sign[] inputs, Rule rule, Sign lexHead) {
        return new Sign(cat, inputs, rule, lexHead);
    }

    public static Sign createDerivedSignWithNewLF(Category cat, Sign[] inputs, Rule rule, Sign lexHead) {
        Category copyCat = cat.shallowCopy();
        LF lf = null;
        for (int i = 0; i < inputs.length; ++i) {
            lf = HyloHelper.append(lf, inputs[i].getCategory().getLF());
        }
        if (rule instanceof TypeChangingRule) {
            TypeChangingRule tcr = (TypeChangingRule)rule;
            lf = HyloHelper.append(lf, tcr.getResult().getLF());
        }
        if (lf != null) {
            HyloHelper.sort(lf);
        }
        copyCat.setLF(lf);
        return new Sign(copyCat, inputs, rule, lexHead);
    }

    protected Sign(Category cat, Sign[] inputs, Rule rule, Sign lexHead) {
        this(Sign.getRemainingWords(inputs, 0), cat, null, lexHead);
        this._history = new DerivationHistory(inputs, this, rule);
    }

    private static List<Word> getRemainingWords(Sign[] inputs, int index) {
        if (index == inputs.length - 1) {
            return inputs[index]._words;
        }
        return new StructureSharingList<Word>(inputs[index]._words, Sign.getRemainingWords(inputs, index + 1));
    }

    public List<Word> getWords() {
        return this._words;
    }

    public String getOrthography() {
        return Grammar.theGrammar.lexicon.tokenizer.getOrthography(this._words);
    }

    public Category getCategory() {
        return this._cat;
    }

    public boolean isLexical() {
        return this._history.isEmpty();
    }

    public void setDerivationHistory(DerivationHistory dh) {
        this._history = dh;
    }

    public DerivationHistory getDerivationHistory() {
        return this._history;
    }

    public Sign getLexHead() {
        return this._lexHead;
    }

    public int hashCode() {
        return System.identityHashCode(this._words) + this._cat.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)obj;
        return this._words == sign._words && this._cat.equals(sign._cat);
    }

    public int surfaceWordHashCode() {
        return this.surfaceWordHashCode(false);
    }

    public int surfaceWordHashCode(boolean ignoreLF) {
        if (this._history.getInputs() == null) {
            return this.hashCode();
        }
        int hc = 1;
        for (int i = 0; i < this._words.size(); ++i) {
            Word word = this._words.get(i);
            hc = 31 * hc + word.surfaceWordHashCode();
        }
        return hc += ignoreLF ? this._cat.hashCodeNoLF() : this._cat.hashCode();
    }

    public boolean surfaceWordEquals(Object obj) {
        return this.surfaceWordEquals(obj, false);
    }

    public boolean surfaceWordEquals(Object obj, boolean ignoreLF) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)obj;
        if (this._history.getInputs() == null || sign._history.getInputs() == null) {
            return this.equals(sign);
        }
        if (this._words.size() != sign._words.size()) {
            return false;
        }
        for (int i = 0; i < this._words.size(); ++i) {
            Word signWord;
            Word word = this._words.get(i);
            if (word.surfaceWordEquals(signWord = sign._words.get(i))) continue;
            return false;
        }
        return ignoreLF ? this._cat.equalsNoLF(sign._cat) : this._cat.equals(sign._cat);
    }

    public String toString() {
        return this.getOrthography() + " :- " + this._cat.toString();
    }

    public Document getWordsInXml() {
        Set<Nominal> emptySet = Collections.emptySet();
        return this.getWordsInXml(emptySet);
    }

    public Document getWordsInXml(Set<Nominal> nominals) {
        TObjectIntHashMap nominalsMap = new TObjectIntHashMap();
        this.setMaxOrthLengths(nominals, nominalsMap);
        Document doc = new Document();
        Element root = new Element("seg");
        doc.setRootElement(root);
        this.addWordsToXml(root, nominalsMap);
        return doc;
    }

    private void setMaxOrthLengths(Set<Nominal> nominals, TObjectIntHashMap nominalsMap) {
        Sign[] inputs;
        Nominal index = this._cat.getIndexNominal();
        if (index != null && nominals.contains(index)) {
            int orthLen = this.getOrthography().length();
            if (!nominalsMap.containsKey((Object)index) || orthLen > nominalsMap.get((Object)index)) {
                nominalsMap.put((Object)index, orthLen);
            }
        }
        if ((inputs = this._history.getInputs()) == null) {
            return;
        }
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i].setMaxOrthLengths(nominals, nominalsMap);
        }
    }

    private void addWordsToXml(Element parent, TObjectIntHashMap nominalsMap) {
        Sign[] inputs;
        Nominal index = this._cat.getIndexNominal();
        if (index != null && nominalsMap.containsKey((Object)index) && nominalsMap.get((Object)index) == this.getOrthography().length()) {
            nominalsMap.remove((Object)index);
            Element span = new Element("span");
            span.setAttribute("label", index.toString());
            parent.addContent((Content)span);
            parent = span;
        }
        if ((inputs = this._history.getInputs()) == null) {
            Word word = this._words.get(0);
            if (Grammar.isBoundaryTone(word.getForm())) {
                Element boundary = new Element("boundary");
                boundary.setAttribute("type", word.getForm());
                parent.addContent((Content)boundary);
                return;
            }
            if (word.getPitchAccent() != null) {
                Element pitchaccent = new Element("pitchaccent");
                pitchaccent.setAttribute("type", word.getPitchAccent());
                this.addWords(pitchaccent, word);
                parent.addContent((Content)pitchaccent);
                return;
            }
            this.addWords(parent, word);
            return;
        }
        if (inputs.length == 1) {
            inputs[0].addWordsToXml(parent, nominalsMap);
            return;
        }
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i].addWordsToXml(parent, nominalsMap);
        }
    }

    private void addWords(Element parent, Word word) {
        Element child;
        List<String> orthWords = Grammar.theGrammar.lexicon.tokenizer.expandWord(word);
        if (orthWords.size() == 1) {
            Element wordElt = new Element("word");
            wordElt.addContent(orthWords.get(0));
            child = wordElt;
        } else {
            Element multiwordElt = new Element("multiword");
            for (int i = 0; i < orthWords.size(); ++i) {
                Element wordElt = new Element("word");
                wordElt.addContent(orthWords.get(i));
                multiwordElt.addContent((Content)wordElt);
            }
            child = multiwordElt;
        }
        Iterator<Pair<String, String>> it = word.getAttrValPairs();
        while (it.hasNext()) {
            Pair<String, String> p = it.next();
            String attr = (String)p.a;
            String val = (String)p.b;
            child.setAttribute(attr, val);
        }
        parent.addContent((Content)child);
    }

    public String getBracketedString() {
        Sign[] inputs = this._history.getInputs();
        if (inputs == null) {
            return this.getOrthography();
        }
        if (inputs.length == 1) {
            return inputs[0].getBracketedString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < inputs.length; ++i) {
            sb.append(inputs[i].getBracketedString());
            if (i >= inputs.length - 1) continue;
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getSupertag() {
        return this._cat.getSupertag();
    }

    public String getWordForm() {
        return this._words.get(0).getForm();
    }

    @Override
    public String getPOS() {
        return this._words.get(0).getPOS();
    }

    @Override
    public void setOrigin() {
        HyloHelper.setOrigin(this._cat.getLF(), this);
    }

    public int wordIndex(Sign lexSign) {
        return this.wordIndex(lexSign, new int[]{0});
    }

    private int wordIndex(Sign lexSign, int[] offset) {
        if (this == lexSign) {
            return offset[0];
        }
        if (this.isLexical()) {
            offset[0] = offset[0] + this._words.size();
            return -1;
        }
        Sign[] inputs = this._history.getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            int retval = inputs[i].wordIndex(lexSign, offset);
            if (retval < 0) continue;
            return retval;
        }
        return -1;
    }

    public void addData(Object obj) {
        if (this.data == null) {
            this.data = new LinkedList();
        }
        this.data.addFirst(obj);
    }

    public Object getData(Class<?> objClass) {
        if (this.data == null) {
            return null;
        }
        for (Object e : this.data) {
            if (e.getClass() != objClass) continue;
            return e;
        }
        return null;
    }

    public List<LexDependency> getUnfilledDeps() {
        UnfilledDeps udeps = (UnfilledDeps)this.getData(UnfilledDeps.class);
        if (udeps != null) {
            return udeps.unfilledDeps;
        }
        if (this.isLexical()) {
            List<LexDependency> unfilledDeps = HyloHelper.getUnfilledLexDeps(this._cat.getLF());
            this.addData(new UnfilledDeps(unfilledDeps));
            return unfilledDeps;
        }
        this.getFilledDeps();
        udeps = (UnfilledDeps)this.getData(UnfilledDeps.class);
        return udeps.unfilledDeps;
    }

    public List<LexDependency> getFilledDeps() {
        if (this.isLexical()) {
            return Collections.emptyList();
        }
        FilledDeps fdeps = (FilledDeps)this.getData(FilledDeps.class);
        if (fdeps != null) {
            return fdeps.filledDeps;
        }
        ArrayList<LexDependency> unfilledDeps = new ArrayList<LexDependency>(5);
        Sign[] inputs = this._history.getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            unfilledDeps.addAll(inputs[i].getUnfilledDeps());
        }
        List<LexDependency> filledDeps = HyloHelper.getFilledLexDeps(unfilledDeps, this._cat.getLF());
        this.addData(new UnfilledDeps(unfilledDeps));
        this.addData(new FilledDeps(filledDeps));
        return filledDeps;
    }

    public List<LexDependency> getSiblingFilledDeps() {
        List<LexDependency> filledDeps = this.getFilledDeps();
        if (filledDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LexDependency> retval = new ArrayList<LexDependency>(5);
        Sign[] inputs = this._history.getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i].addSiblingFilledDeps(retval, filledDeps);
        }
        return retval;
    }

    private void addSiblingFilledDeps(List<LexDependency> retval, List<LexDependency> filledDeps) {
        if (this.isLexical()) {
            return;
        }
        List<LexDependency> candDeps = this.getFilledDeps();
        if (!candDeps.isEmpty()) {
            List<LexDependency> sibs = LexDependency.filterSameHead(candDeps, filledDeps);
            if (sibs.isEmpty()) {
                return;
            }
            retval.addAll(sibs);
        }
        Sign[] inputs = this._history.getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i].addSiblingFilledDeps(retval, filledDeps);
        }
    }

    public Sign getSignHeadedByDep(LexDependency lexdep) {
        if (!this.isLexical() && this._lexHead == lexdep.lexHead) {
            Sign[] inputs = this._history.getInputs();
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i]._lexHead == lexdep.lexDep) {
                    return inputs[i];
                }
                Sign retval = inputs[i].getSignHeadedByDep(lexdep);
                if (retval == null) continue;
                return retval;
            }
        }
        return null;
    }

    public void debugSerialization() throws IOException, ClassNotFoundException {
        String filename = "tmp.ser";
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
        System.out.println("Writing this: " + this);
        System.out.println(this.getDerivationHistory());
        out.writeObject(this);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        System.out.print("Reading sign: ");
        Sign sign = (Sign)in.readObject();
        System.out.println(sign);
        System.out.println(sign.getDerivationHistory());
        in.close();
        System.out.println("this == sign?: " + (this == sign));
        System.out.println("this.equals(sign)?: " + this.equals(sign));
    }

    public static class FilledDeps {
        public List<LexDependency> filledDeps;

        public FilledDeps(List<LexDependency> filledDeps) {
            this.filledDeps = filledDeps;
        }
    }

    public static class UnfilledDeps {
        public List<LexDependency> unfilledDeps;

        public UnfilledDeps(List<LexDependency> unfilledDeps) {
            this.unfilledDeps = unfilledDeps;
        }
    }
}

