/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import java.util.ArrayList;
import opennlp.ccg.lexicon.SupertaggerAdapter;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureList;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignScorer;

public class LexLogProbFeatureExtractor
implements FeatureExtractor,
SignScorer {
    public static String lexlogprobkey = "lexlogprob";
    protected Alphabet alphabet = null;
    protected Alphabet.Feature lexlogprobFeature = null;

    @Override
    public void setAlphabet(Alphabet alphabet) {
        this.alphabet = alphabet;
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(lexlogprobkey);
        this.lexlogprobFeature = alphabet.closed() ? alphabet.index(keys) : alphabet.add(keys);
    }

    @Override
    public FeatureVector extractFeatures(Sign sign, boolean complete) {
        return this.lexLogProbVector(this.getLexLogProb(sign, complete));
    }

    protected float getLexLogProb(Sign sign, boolean complete) {
        SupertaggerAdapter.LexLogProb lexlogprob = (SupertaggerAdapter.LexLogProb)sign.getData(SupertaggerAdapter.LexLogProb.class);
        if (lexlogprob != null) {
            return lexlogprob.logprob;
        }
        float logprob = 0.0f;
        if (!sign.isLexical()) {
            Sign[] inputs = sign.getDerivationHistory().getInputs();
            if (inputs.length == 1) {
                logprob = this.getLexLogProb(inputs[0], false);
            } else if (inputs.length == 2) {
                logprob = this.getLexLogProb(inputs[0], false) + this.getLexLogProb(inputs[1], false);
            }
        }
        sign.addData(new SupertaggerAdapter.LexLogProb(logprob));
        return logprob;
    }

    protected FeatureVector lexLogProbVector(float logprob) {
        FeatureList retval = new FeatureList(1);
        if (this.lexlogprobFeature != null) {
            retval.add(this.lexlogprobFeature, Float.valueOf(logprob));
        }
        return retval;
    }

    @Override
    public double score(Sign sign, boolean complete) {
        return this.getLexLogProb(sign, complete);
    }
}

