/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.TargetCat;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractCat
implements Category,
Serializable {
    private static final long serialVersionUID = 1L;
    protected FeatureStructure _featStruc;
    protected LF _lf;
    private transient int _hashCode = -1;
    private transient int _hashCodeNoLF = -1;
    private transient TObjectIntHashMap _varMap = null;
    protected String _supertag = null;

    public AbstractCat() {
    }

    public AbstractCat(LF lf) {
        this._lf = lf;
    }

    public AbstractCat(Element elt) {
        Element lfElt = elt.getChild("lf");
        if (lfElt != null) {
            this._lf = HyloHelper.flattenLF(HyloHelper.getLF(lfElt));
        }
    }

    public void toXml(Element catElt) {
        if (this._lf != null) {
            catElt.addContent((Content)HyloHelper.toXml(this._lf));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this._supertag != null) {
            this._supertag = this._supertag.intern();
        }
        this._varMap = null;
    }

    @Override
    public FeatureStructure getFeatureStructure() {
        return this._featStruc;
    }

    @Override
    public void setFeatureStructure(FeatureStructure fs) {
        this._featStruc = fs;
    }

    @Override
    public LF getLF() {
        return this._lf;
    }

    @Override
    public void setLF(LF lf) {
        this._lf = lf;
    }

    public abstract String toString();

    @Override
    public abstract String getSupertag();

    @Override
    public String toTeX() {
        return this.toString();
    }

    @Override
    public abstract Category copy();

    @Override
    public abstract Category shallowCopy();

    @Override
    public abstract Object fill(Substitution var1) throws UnifyFailure;

    @Override
    public abstract void unifyCheck(Object var1) throws UnifyFailure;

    @Override
    public abstract Object unify(Object var1, Substitution var2) throws UnifyFailure;

    @Override
    public abstract TargetCat getTarget();

    @Override
    public boolean shallowEquals(Object o) {
        return this.equals(o);
    }

    @Override
    public void deepMap(ModFcn mf) {
        if (this._lf != null) {
            this._lf.deepMap(mf);
        }
        mf.modify(this);
    }

    @Override
    public void forall(CategoryFcn f) {
        f.forall(this);
    }

    @Override
    public boolean occurs(Variable v) {
        if (this._lf == null) {
            return false;
        }
        return this._lf.occurs(v);
    }

    public String prettyPrint() {
        return this.prettyPrint("");
    }

    protected String prettyPrint(String pad) {
        return pad + this.toString();
    }

    protected int prettyLength(String s) {
        int max = 0;
        int cur = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                max = Math.max(cur, max);
                cur = 0;
                continue;
            }
            ++cur;
        }
        return Math.max(max, cur);
    }

    @Override
    public int hashCode() {
        this._varMap = new TObjectIntHashMap();
        this._hashCode = this._hashCodeNoLF = this.hashCodeNoLF(this._varMap);
        if (this._lf != null) {
            this._hashCode += this._lf.hashCode(this._varMap);
        }
        return this._hashCode;
    }

    @Override
    public int hashCodeNoLF() {
        this._varMap = new TObjectIntHashMap();
        this._hashCodeNoLF = this.hashCodeNoLF(this._varMap);
        return this._hashCodeNoLF;
    }

    @Override
    public abstract int hashCodeNoLF(TObjectIntHashMap var1);

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    @Override
    public boolean equalsNoLF(Object obj) {
        return this.equals(obj, false);
    }

    private boolean equals(Object obj, boolean checkLF) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractCat ac = (AbstractCat)obj;
        if (checkLF) {
            this.hashCode();
            ac.hashCode();
        } else {
            this.hashCodeNoLF();
            ac.hashCodeNoLF();
        }
        if (checkLF) {
            if (this._lf != null && ac._lf == null) {
                return false;
            }
            if (this._lf == null && ac._lf != null) {
                return false;
            }
        }
        if (!this.equalsNoLF(obj, this._varMap, ac._varMap)) {
            return false;
        }
        return !checkLF || this._lf == null || this._lf.equals(ac._lf, this._varMap, ac._varMap);
    }

    @Override
    public abstract boolean equalsNoLF(Object var1, TObjectIntHashMap var2, TObjectIntHashMap var3);

    @Override
    public Nominal getIndexNominal() {
        Object index;
        TargetCat target = this.getTarget();
        FeatureStructure fs = target.getFeatureStructure();
        if (fs != null && (index = fs.getValue("index")) instanceof Nominal) {
            return (Nominal)index;
        }
        return null;
    }

    @Override
    public boolean isFragment() {
        return false;
    }
}

