/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize.hypertagger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.supertagger.io.XMLPOSDictionaryReader;
import opennlp.ccg.parse.supertagger.io.XMLWordDictionaryReader;
import opennlp.ccg.parse.supertagger.ml.STPriorModel;
import opennlp.ccg.parse.supertagger.util.STTaggerPOSDictionary;
import opennlp.ccg.parse.supertagger.util.STTaggerWordDictionary;
import opennlp.ccg.parse.tagger.util.ConfigFileProcessor;
import opennlp.ccg.parse.tagger.util.ResultSink;
import opennlp.ccg.realize.Hypertagger;
import opennlp.ccg.realize.hypertagger.FeatureExtractionException;
import opennlp.ccg.realize.hypertagger.LFInfo;
import opennlp.ccg.realize.hypertagger.LFLoader;
import opennlp.ccg.realize.hypertagger.TagExtractor;
import opennlp.ccg.realize.hypertagger.ZLMaxentModel;
import opennlp.ccg.realize.hypertagger.ZLPOSTagger;
import opennlp.ccg.util.Pair;

public class ZLMaxentHypertagger
extends TagExtractor
implements Hypertagger {
    File hypertagModelFilename;
    File posModelFilename;
    public ZLMaxentModel hypertagModel;
    ZLMaxentModel posModel;
    ZLPOSTagger postagger;
    ZLMaxentModel protoHTModel;
    double protoHTBeta = 0.01;
    TagExtractor.LfGraphNode currentPred;
    String LFNum;
    protected double[] betas = new double[7];
    int currentBeta;
    private boolean goldStdTagInsert = false;
    private HashMap<String, String> goldPred2Tag;
    private STPriorModel priorModel;
    double priorBeta = 0.4;
    private HashMap<String, String> goldPredPOS;
    private STTaggerWordDictionary wdict;
    private STTaggerPOSDictionary posdict;
    int dictK;
    public BufferedWriter tdErr;

    void fillFeatures(TagExtractor.LfGraphNode n, TagExtractor.FeatureList f) {
        f.addFeatureWithProb("FO", Integer.toString(n.getNumChildren()));
        for (String string : n.getAttribs().keySet()) {
            f.addFeatureWithProb("Z" + string.substring(0, 1).toUpperCase(), n.getAttribs().get(string));
        }
        f.addFeatureWithProb("PN", n.getPredicateName());
        if (n.getMultiParents().size() > 0) {
            for (TagExtractor.LfGraphNode lfGraphNode : n.getMultiParents()) {
                f.addFeatureWithProb("RN", lfGraphNode.getPredicateName());
                f.addFeatureWithProb("PP", this.getPOS(lfGraphNode));
                String string = lfGraphNode.getPred().getNominal().toString();
                if (string == null || string.indexOf(58) <= 0) continue;
                String string2 = string.substring(string.indexOf(58) + 1);
                f.addFeatureWithProb("XP", string2);
            }
        } else {
            f.addFeatureWithProb("RN", "0");
        }
        int argchildren = 0;
        for (TagExtractor.LfGraphLink lfGraphLink : n.getChildren()) {
            f.addFeatureWithProb("CT", lfGraphLink.getLabel());
            if (lfGraphLink.getTarget() == null) continue;
            f.addFeatureWithProb("CN", lfGraphLink.getTarget().getPredicateName());
            String string = (String)this.argNameMap.get(lfGraphLink.getLabel());
            if (string != null) {
                ++argchildren;
                f.addFeatureWithProb(string + "N", lfGraphLink.getTarget().getPredicateName());
                f.addFeatureWithProb(string + "P", this.getPOS(lfGraphLink.getTarget()));
                String cls = lfGraphLink.getTarget().getPred().getNominal().toString();
                if (cls == null || cls.indexOf(58) <= 0) continue;
                String cfeat = cls.substring(cls.indexOf(58) + 1);
                String argNumOrName = string.startsWith("A") ? string.substring(1) : string;
                f.addFeatureWithProb("X" + argNumOrName + "D", cfeat);
                continue;
            }
            f.addFeatureWithProb("MP", this.getPOS(lfGraphLink.getTarget()));
            String cls2 = lfGraphLink.getTarget().getPred().getNominal().toString();
            if (cls2 == null || cls2.indexOf(58) <= 0) continue;
            String cfeat2 = cls2.substring(cls2.indexOf(58) + 1);
            f.addFeatureWithProb("XM", cfeat2);
        }
        f.addFeatureWithProb("NA", Integer.toString(argchildren));
        if (this.posModel == null) {
            f.addFeatureWithProb("PT", this.getPOS(n));
        } else {
            ArrayList<Pair<String, Double>> arrayList = this.getBetaBestPOS(n);
            for (Pair<String, Double> pair : arrayList) {
                f.addFeatureWithProb("PT", (String)pair.a, (Double)pair.b);
                n.setPOS((String)pair.a);
            }
        }
        Nominal nominal = n.getPred().getNominal();
        String string = nominal.toString();
        if (string != null && string.indexOf(58) > 0) {
            String string3 = string.substring(string.indexOf(58) + 1);
            f.addFeatureWithProb("XC", string3);
        }
        if (this.priorModel != null) {
            Word word = Word.createWord(n.getPredicateName(), null, null, n.getPredicateName(), this.getPOS(n), null, null);
            this.priorModel.computePriors(word);
            List<Pair<String, Double>> tags = this.priorModel.getBetaBestPriors(word, this.priorBeta);
            for (Pair<String, Double> t : tags) {
                f.addFeatureWithProb("PR_ST", DefaultTokenizer.unescape((String)t.a), (Double)t.b);
            }
        }
    }

    private void fillTwoPassFeatures(TagExtractor.LfGraphNode n, TagExtractor.FeatureList f) {
        for (Pair<String, Double> p : n.getSTList()) {
            f.addFeatureWithProb("ST", (String)p.a, (Double)p.b);
        }
        for (TagExtractor.LfGraphNode pl : n.getMultiParents()) {
            for (Pair<String, Double> p : pl.getSTList()) {
                f.addFeatureWithProb("STP", (String)p.a, (Double)p.b);
            }
        }
        for (TagExtractor.LfGraphLink cl : n.getChildren()) {
            TagExtractor.LfGraphNode c = cl.getTarget();
            if (c == null) continue;
            for (Pair<String, Double> p : c.getSTList()) {
                f.addFeatureWithProb("STC", (String)p.a, (Double)p.b);
            }
        }
    }

    public ZLMaxentHypertagger() {
        this.betas[0] = 0.16;
        this.betas[1] = 0.05;
        this.betas[2] = 0.0058;
        this.betas[3] = 0.00175;
        this.betas[4] = 6.25E-4;
        this.betas[5] = 1.25E-4;
        this.betas[6] = 5.8E-5;
        this.currentBeta = 0;
        this.goldPred2Tag = new HashMap();
        this.goldPredPOS = new HashMap();
    }

    public ZLMaxentHypertagger(File posModelFile, File hyperModelFile) throws IOException {
        this();
        this.posModelFilename = posModelFile;
        if (posModelFile != null) {
            this.posModel = new ZLMaxentModel();
            this.posModel.load(posModelFile);
            this.postagger = new ZLPOSTagger(this.posModel);
            this.postagger.setPrefixLength(4);
            this.postagger.setSuffixLength(4);
            this.postagger.argNameMap = this.argNameMap;
        }
        this.hypertagModelFilename = hyperModelFile;
        this.hypertagModel = new ZLMaxentModel();
        this.hypertagModel.load(hyperModelFile);
    }

    public ZLMaxentHypertagger(ZLPOSTagger ptag, File hyperModelFile) {
        this();
        this.postagger = ptag;
        this.postagger.argNameMap = this.argNameMap;
        this.hypertagModelFilename = hyperModelFile;
        this.hypertagModel = new ZLMaxentModel();
        this.hypertagModel.load(hyperModelFile);
    }

    public ZLMaxentHypertagger(File posModelFile) throws IOException {
        this();
        this.posModelFilename = posModelFile;
        this.posModel = new ZLMaxentModel();
        this.posModel.load(posModelFile);
        this.postagger = new ZLPOSTagger(this.posModel);
        this.postagger.setPrefixLength(4);
        this.postagger.setSuffixLength(4);
        this.postagger.argNameMap = this.argNameMap;
    }

    public static ZLMaxentHypertagger ZLMaxentHypertaggerFactory(String configFile) throws IOException {
        ZLMaxentHypertagger hypertagger = new ZLMaxentHypertagger();
        ZLPOSTagger postagger = null;
        String[] pathKeys = new String[]{"priormodel", "priormodelvocab", "wdict", "posdict", "maxentmodel", "posconfig"};
        Map<String, String> opts = ConfigFileProcessor.readInConfig(configFile, pathKeys);
        String posConfig = opts.get("posconfig");
        if (posConfig != null) {
            postagger = ZLPOSTagger.ZLPOSTaggerFactory(posConfig);
        }
        hypertagger.postagger = postagger;
        String priorModelPath = opts.get("priormodel");
        String wdictPath = opts.get("wdict");
        if (priorModelPath != null) {
            String vocabPath = opts.get("priormodelvocab");
            if (vocabPath == null) {
                throw new IOException("You must specify a vocab filename along with the prior model filename.");
            }
            hypertagger.loadPriorModel(new File(priorModelPath), new File(vocabPath));
        } else if (wdictPath != null) {
            String posdictPath = opts.get("posdict");
            if (posdictPath == null) {
                throw new IOException("You must specify both a word-level dict and a POS dict.");
            }
            XMLWordDictionaryReader wdr = new XMLWordDictionaryReader(new File(wdictPath));
            XMLPOSDictionaryReader pdr = new XMLPOSDictionaryReader(new File(posdictPath));
            STTaggerWordDictionary wdict = wdr.read();
            STTaggerPOSDictionary posdict = pdr.read();
            hypertagger.wdict = wdict;
            hypertagger.posdict = posdict;
            String kstring = opts.get("dictk");
            if (kstring != null) {
                hypertagger.dictK = Integer.parseInt(kstring);
            }
        }
        String maxentModelPath = opts.get("maxentmodel");
        if (maxentModelPath == null) {
            System.err.println("Maxent model path must be specified with key \"maxentmodel\".");
            throw new IOException();
        }
        String protoHTModelPath = opts.get("protomodel");
        String betaString = opts.get("betas");
        if (betaString != null) {
            String[] bs = betaString.split("\\s+");
            double[] betaVals = new double[bs.length];
            for (int i = 0; i < bs.length; ++i) {
                betaVals[i] = Double.parseDouble(bs[i]);
            }
            hypertagger.betas = betaVals;
        }
        hypertagger.hypertagModel = new ZLMaxentModel(maxentModelPath);
        if (protoHTModelPath != null) {
            hypertagger.protoHTModel = new ZLMaxentModel(protoHTModelPath);
            System.err.println("Two-pass model instantiated. Initializing hyperdrive.");
        }
        String argnames = opts.get("argnames");
        hypertagger.setArgNames(argnames);
        return hypertagger;
    }

    private String getPOS(TagExtractor.LfGraphNode n) {
        if (this.postagger == null) {
            String posTag = this.goldPredPOS.get(n.getPred().getNominal().getName());
            if (posTag == null) {
                posTag = "UNK";
            }
            return posTag;
        }
        if (n.getPOS() == null) {
            TagExtractor.FeatureList feats = this.postagger.getFeatures(n);
            ArrayList<Pair<String, Double>> pos = this.postagger.getBetaBestPOS(feats);
            n.setPOS((String)pos.get((int)0).a);
        }
        return n.getPOS();
    }

    private String getGoldSupertag(TagExtractor.LfGraphNode n) {
        return this.goldPred2Tag.get(n.getPred().getNominal().getName());
    }

    private ArrayList<Pair<String, Double>> getBetaBestPOS(TagExtractor.LfGraphNode n) {
        if (n.getPOSList() == null) {
            TagExtractor.FeatureList feats = this.postagger.getFeatures(n);
            ArrayList<Pair<String, Double>> pos = null;
            pos = this.postagger.getBetaBestPOS(feats);
            n.setPOSList(pos);
        }
        return n.getPOSList();
    }

    @Override
    protected TagExtractor.FeatureList getFeatures(TagExtractor.LfGraphNode n) {
        TagExtractor.FeatureList feats = n.getFeatures();
        if (feats != null) {
            return feats;
        }
        feats = new TagExtractor.FeatureList();
        this.fillFeatures(n, feats);
        return feats;
    }

    @Override
    public String getAllFeaturesAndAnswer() {
        StringBuilder output = new StringBuilder();
        for (TagExtractor.LfGraphNode n : this.nomTable.values()) {
            TagExtractor.FeatureList feats = this.getFeatures(n);
            String context = feats.getAllFeatures();
            String tag = this.goldPred2Tag.get(n.getPred().getNominal().getName());
            output = output.append(tag + " " + context);
            output = output.append("\n");
        }
        return output.toString();
    }

    private void assignAllFeatures() {
        TagExtractor.FeatureList feats;
        for (TagExtractor.LfGraphNode n : this.nomTable.values()) {
            feats = this.getFeatures(n);
            n.setFeatures(feats);
            if (this.protoHTModel == null) continue;
            n.setSTList(this.getProtoSupertagsAndProbs(n, this.protoHTBeta));
        }
        if (this.protoHTModel != null) {
            for (TagExtractor.LfGraphNode n : this.nomTable.values()) {
                feats = this.getFeatures(n);
                this.fillTwoPassFeatures(n, feats);
                n.setFeatures(feats);
            }
        }
    }

    public ZLMaxentModel getPosModel() {
        return this.posModel;
    }

    public File getPosModelFilename() {
        return this.posModelFilename;
    }

    @Override
    public void setLF(List<SatOp> preds) throws FeatureExtractionException {
        super.setLF(preds);
        if (this.postagger != null) {
            this.postagger.setLF(preds);
        }
        this.assignAllFeatures();
    }

    public String getLFNum() {
        return this.LFNum;
    }

    public void setLFNum(String s) {
        this.LFNum = s;
    }

    public void setPOSModelFilename(File posModelFilename) throws IOException {
        this.posModelFilename = posModelFilename;
        this.posModel = new ZLMaxentModel();
        this.posModel.load(posModelFilename);
        this.postagger = new ZLPOSTagger(this.posModel);
    }

    public File getHypertagModelFilename() {
        return this.hypertagModelFilename;
    }

    public void setHypertagModelFilename(File hypertagModelFilename) throws IOException {
        this.hypertagModelFilename = hypertagModelFilename;
        this.hypertagModel = new ZLMaxentModel();
        this.hypertagModel.load(hypertagModelFilename);
    }

    @Override
    public void mapPreds(List<SatOp> preds) {
        try {
            this.setLF(preds);
        }
        catch (FeatureExtractionException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    @Override
    public void setPred(int index) {
        this.currentPred = this.findNode(index);
    }

    @Override
    public void resetBeta() {
        this.currentBeta = 0;
    }

    @Override
    public void resetBetaToMax() {
        this.currentBeta = this.betas.length - 1;
    }

    @Override
    public void nextBeta() {
        if (this.currentBeta < this.betas.length - 1) {
            ++this.currentBeta;
        }
    }

    @Override
    public void previousBeta() {
        if (this.currentBeta > 0) {
            --this.currentBeta;
        }
    }

    @Override
    public boolean hasMoreBetas() {
        return this.currentBeta < this.betas.length - 1;
    }

    @Override
    public boolean hasLessBetas() {
        return this.currentBeta > 0 && this.hasMoreBetas();
    }

    @Override
    public Map<String, Double> getSupertags() {
        Set<Pair<String, Double>> tp = this.getSupertagsAndProbs(this.currentPred, this.betas[this.currentBeta]);
        if (tp == null) {
            return null;
        }
        HashMap<String, Double> tagMap = new HashMap<String, Double>(tp.size());
        for (Pair<String, Double> p : tp) {
            tagMap.put((String)p.a, (Double)p.b);
        }
        return tagMap;
    }

    private List<Pair<Double, String>> getSupertagsAsList() {
        Set<Pair<String, Double>> tp = this.getSupertagsAndProbs(this.currentPred, this.betas[this.currentBeta]);
        ArrayList<Pair<Double, String>> ret = new ArrayList<Pair<Double, String>>();
        for (Pair<String, Double> p : tp) {
            ret.add(new Pair(p.b, p.a));
        }
        return ret;
    }

    private ArrayList<ProbIndexPair> getModelOutcomes(TagExtractor.FeatureList f, ZLMaxentModel m) {
        ArrayList<ProbIndexPair> probList = new ArrayList<ProbIndexPair>();
        double[] probs = m.eval(f.getAllFeaturesForMaxent(), true);
        for (int i = 0; i < probs.length; ++i) {
            probList.add(new ProbIndexPair(probs[i], i));
        }
        Collections.sort(probList);
        Collections.reverse(probList);
        return probList;
    }

    private HashSet<Pair<String, Double>> betaSearch(ArrayList<ProbIndexPair> probList, double beta) {
        double maxProb = probList.get((int)0).prob;
        HashSet<Pair<String, Double>> names = new HashSet<Pair<String, Double>>();
        for (int i = 0; i < probList.size() && probList.get((int)i).prob >= beta * maxProb; ++i) {
            names.add(new Pair<String, Double>(this.protoHTModel.getOutcome(probList.get((int)i).index), probList.get((int)i).prob));
        }
        return names;
    }

    public Set<Pair<String, Double>> getProtoSupertagsAndProbs(TagExtractor.LfGraphNode n, double beta) {
        ArrayList<ProbIndexPair> probList = new ArrayList();
        probList = this.getModelOutcomes(n.getFeatures(), this.protoHTModel);
        HashSet<Pair<String, Double>> names = this.betaSearch(probList, beta);
        return names;
    }

    public Set<Pair<String, Double>> getSupertagsAndProbs(TagExtractor.LfGraphNode n, double beta) {
        String nomId;
        if (this.currentPred == null) {
            return null;
        }
        double bestOCProb = 0.0;
        double curOCProb = 0.0;
        HashSet<Pair<String, Double>> names = new HashSet<Pair<String, Double>>();
        HashSet<String> tagList = new HashSet<String>();
        ArrayList<Object> probList = new ArrayList();
        probList = this.getModelOutcomes(n.getFeatures(), this.hypertagModel);
        if (this.wdict != null) {
            String pos;
            String predName = n.getPredicateName();
            Collection<String> permittedOutcomes = this.wdict.getEntry(predName, this.dictK);
            if (permittedOutcomes == null && (permittedOutcomes = this.posdict.getEntry(pos = this.getPOS(n))) == null) {
                System.err.println("!! No pos dict entries for " + pos);
            }
            ArrayList<String> po = new ArrayList<String>();
            for (String s : permittedOutcomes) {
                po.add(DefaultTokenizer.unescape(s));
            }
            permittedOutcomes = po;
            if (permittedOutcomes != null) {
                String oc = "";
                for (ProbIndexPair probIndexPair : probList) {
                    oc = this.hypertagModel.getOutcome(probIndexPair.index);
                    curOCProb = probIndexPair.prob;
                    if (permittedOutcomes.contains(oc)) {
                        if (bestOCProb == 0.0) {
                            bestOCProb = curOCProb;
                        }
                        if (curOCProb >= bestOCProb * beta) {
                            names.add(new Pair<String, Double>(oc, probIndexPair.prob));
                            tagList.add(oc);
                            if (!(curOCProb > bestOCProb)) continue;
                            bestOCProb = curOCProb;
                            continue;
                        }
                        break;
                    }
                    String nomId2 = this.currentPred.pred.getNominal().getName();
                    String gsTag = "";
                    String gsPos = "";
                    if (this.goldPred2Tag.containsKey(nomId2)) {
                        gsTag = this.goldPred2Tag.get(nomId2);
                        gsPos = this.goldPredPOS.get(nomId2);
                    }
                    if (!gsTag.equals(oc)) continue;
                    try {
                        this.tdErr.write(predName + "\t" + this.currentPred.index + "\t" + this.LFNum + "\t" + gsTag + "\t" + gsPos + "\n");
                        this.tdErr.flush();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        } else {
            double maxProb = ((ProbIndexPair)probList.get((int)0)).prob;
            for (int i = 0; i < probList.size() && ((ProbIndexPair)probList.get((int)i)).prob >= beta * maxProb; ++i) {
                names.add(new Pair<String, Double>(this.hypertagModel.getOutcome(((ProbIndexPair)probList.get((int)i)).index), ((ProbIndexPair)probList.get((int)i)).prob));
                tagList.add(this.hypertagModel.getOutcome(((ProbIndexPair)probList.get((int)i)).index));
            }
        }
        if (this.goldPred2Tag.containsKey(nomId = this.currentPred.pred.getNominal().getName())) {
            String goldStdTag = this.goldPred2Tag.get(nomId);
            if (this.goldStdTagInsert && !tagList.contains(goldStdTag)) {
                names.add(new Pair<String, Double>(goldStdTag, 1.0));
            }
        }
        return names;
    }

    @Override
    public double getCurrentBetaValue() {
        if (this.currentBeta < this.betas.length) {
            return this.betas[this.currentBeta];
        }
        return 0.0;
    }

    @Override
    public double[] getBetas() {
        return this.betas;
    }

    @Override
    public void setBetas(double[] betas) {
        this.betas = betas;
    }

    public void setPOSBeta(double beta) {
        this.postagger.setBeta(beta);
    }

    public double getPOSBeta() {
        return this.postagger.getBeta();
    }

    @Override
    public void storeGoldStdPredInfo(String predInfo) {
        String[] preds = predInfo.split("\\s+");
        if (preds != null) {
            for (int i = 0; i < preds.length; ++i) {
                String[] info = preds[i].split(":");
                if (info.length != 4) {
                    System.err.println("Malformed pred-info field, skipping (value was \"" + preds[i] + "\")\nPRED-INFO: " + predInfo + "\n");
                    continue;
                }
                this.goldPred2Tag.put(info[0], DefaultTokenizer.unescape(info[1]));
                this.goldPredPOS.put(info[0], DefaultTokenizer.unescape(info[2]));
            }
        }
    }

    @Override
    public void setIncludeGold(boolean v) {
        this.goldStdTagInsert = v;
    }

    @Override
    public void loadPriorModel(File priorModelFile, File vocabFile) {
        try {
            this.priorModel = new STPriorModel(priorModelFile.getAbsolutePath(), vocabFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("Unable to load prior model or vocab file");
            e.printStackTrace();
        }
    }

    @Override
    public void loadProtoModel(File hyperModelFile) {
        this.protoHTModel = new ZLMaxentModel(hyperModelFile.getAbsolutePath());
    }

    public String getSRILMFactors() {
        StringBuilder out = new StringBuilder();
        out.append("<s> ");
        for (TagExtractor.LfGraphNode n : this.nomTable.values()) {
            if (this.goldPred2Tag.get(n.getPred().getNominal().getName()) == null) continue;
            out.append(DefaultTokenizer.escape(n.getPredicateName()));
            out.append(":S-");
            out.append(DefaultTokenizer.escape(n.getPredicateName()));
            out.append(":P-");
            out.append(DefaultTokenizer.escape(this.getPOS(n)));
            out.append(":T-");
            out.append(DefaultTokenizer.escape(this.goldPred2Tag.get(n.getPred().getNominal().getName())));
            out.append(" ");
        }
        out.append("</s>\n");
        return out.toString();
    }

    public Word getPredAsWord(int idx) {
        TagExtractor.LfGraphNode n = this.findNode(idx);
        Word w = Word.createWord(n.getPredicateName(), null, null, n.getPredicateName(), this.getPOS(n), this.getGoldSupertag(n), null);
        return w;
    }

    private Word getPredAsWord() {
        Word w = Word.createWord(this.currentPred.getPredicateName(), null, null, this.currentPred.getPredicateName(), this.getPOS(this.currentPred), this.getGoldSupertag(this.currentPred), null);
        return w;
    }

    public static void main(String[] args) throws IOException {
        int i;
        String usage = "\nhypertagger (-i <input>) (-o <output> [defaults to <stdout>]) (-c <config file>)\n";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        OptionParser o = new OptionParser();
        o.acceptsAll(Arrays.asList("help", "h"), "this message");
        o.acceptsAll(Arrays.asList("quiet", "q"), "print no status messages");
        ArgumentAcceptingOptionSpec b_s = o.acceptsAll(Arrays.asList("beta", "b"), "ignore betas in config file and use this value").withRequiredArg().ofType(Double.class);
        ArgumentAcceptingOptionSpec gr_s = o.acceptsAll(Arrays.asList("g", "grammar")).withRequiredArg().ofType(File.class).describedAs("grammar filename");
        ArgumentAcceptingOptionSpec corpusDir_s = o.acceptsAll(Arrays.asList("d", "lf-dir")).withRequiredArg().ofType(File.class).describedAs("Directory to change to before searching for XML files");
        ArgumentAcceptingOptionSpec configFile_s = o.acceptsAll(Arrays.asList("c", "config")).withRequiredArg().ofType(File.class).describedAs("configfilename");
        ArgumentAcceptingOptionSpec output_s = o.acceptsAll(Arrays.asList("o", "output")).withRequiredArg().ofType(File.class).describedAs("output filename");
        ArgumentAcceptingOptionSpec dump_s = o.acceptsAll(Arrays.asList("dump-tags", "T")).withRequiredArg().ofType(File.class).describedAs("dump predicted tags to file");
        o.acceptsAll(Arrays.asList("goldstd", "G"), "include gold-standard supertags in tag dump");
        OptionSet options = o.parse(args);
        File outputF = (File)options.valueOf((OptionSpec)output_s);
        File dumpF = (File)options.valueOf((OptionSpec)dump_s);
        File configFile = (File)options.valueOf((OptionSpec)configFile_s);
        BufferedWriter out = null;
        BufferedWriter dump = null;
        boolean quiet = options.has("q");
        int lfcount = 0;
        try {
            out = output_s.equals("stdout") ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(outputF));
        }
        catch (IOException ex) {
            System.err.print("Output file " + outputF + " could not be opened.  Exiting...");
            Logger.getLogger(STPriorModel.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(1);
        }
        ZLMaxentHypertagger ht = ZLMaxentHypertagger.ZLMaxentHypertaggerFactory(configFile.getAbsolutePath());
        if (options.has("T")) {
            try {
                dump = new BufferedWriter(new FileWriter(dumpF));
            }
            catch (IOException e) {
                System.err.print("Output file " + dumpF + " could not be opened.  Exiting...");
                System.exit(1);
            }
        }
        if (options.has("b")) {
            double beta = (Double)options.valueOf((OptionSpec)b_s);
            ht.betas = new double[1];
            ht.betas[0] = beta;
        }
        ArrayList<ResultSink> resBetas = new ArrayList<ResultSink>(ht.betas.length);
        for (int i2 = 0; i2 < ht.betas.length; ++i2) {
            ResultSink r = new ResultSink();
            resBetas.add(r);
        }
        ArrayList<BufferedWriter> errFiles = new ArrayList<BufferedWriter>();
        for (int i3 = 0; i3 < ht.betas.length; ++i3) {
            File logdir = new File("logs");
            if (!logdir.exists()) {
                logdir.mkdirs();
            }
            BufferedWriter b = new BufferedWriter(new FileWriter(new File("logs/tagdict.err.out." + i3)));
            b.write("### beta = " + ht.betas[i3] + "\n");
            errFiles.add(b);
        }
        LFLoader lfs = new LFLoader((File)options.valueOf((OptionSpec)gr_s), (File)options.valueOf((OptionSpec)corpusDir_s), options.nonOptionArguments());
        while (lfs.hasNext()) {
            ++lfcount;
            LFInfo lfi = lfs.next();
            try {
                ht.setLF(lfi.getLF());
                ht.storeGoldStdPredInfo(lfi.getFullWords());
                ht.setLFNum(lfi.getLFNum());
            }
            catch (FeatureExtractionException e) {
                e.printStackTrace();
            }
            ArrayList<List<Pair<Double, String>>> lfTagging = new ArrayList<List<Pair<Double, String>>>();
            ArrayList<Word> gsTagging = new ArrayList<Word>();
            for (int bi = 0; bi < ht.betas.length; ++bi) {
                gsTagging = new ArrayList();
                lfTagging = new ArrayList();
                ht.setBetaIndex(bi);
                ht.tdErr = (BufferedWriter)errFiles.get(bi);
                for (int i4 = 0; i4 < ht.maxIndex(); ++i4) {
                    ht.setPred(i4);
                    if (ht.currentPred == null) continue;
                    Word w = ht.getPredAsWord();
                    List<Pair<Double, String>> tags = ht.getSupertagsAsList();
                    lfTagging.add(tags);
                    gsTagging.add(w);
                    if (dump == null) continue;
                    if (options.has("G") && w.getSupertag() != null) {
                        dump.write(w.getSupertag() + " ");
                    }
                    dump.write(w.getForm() + " ");
                    for (int j = 0; j < tags.size(); ++j) {
                        dump.write(tags.get((int)j).a + " " + (String)tags.get((int)j).b + " ");
                    }
                    dump.write("\n");
                }
                ((ResultSink)resBetas.get(bi)).addSent(lfTagging, gsTagging);
                if (!quiet) {
                    System.err.println("LFs processed:       " + lfcount + "\r");
                }
                ht.tdErr.flush();
            }
        }
        if (dump != null) {
            dump.flush();
            dump.close();
        }
        for (i = 0; i < ht.betas.length; ++i) {
            ((BufferedWriter)errFiles.get(i)).close();
        }
        for (i = 0; i < ht.betas.length; ++i) {
            out.write("---------------\n");
            out.write("BETA: " + ht.betas[i] + "\n");
            out.write(((ResultSink)resBetas.get(i)).report());
        }
        out.flush();
        out.close();
    }

    private void setBetaIndex(int bi) {
        this.currentBeta = bi;
    }

    public class ProbIndexPair
    implements Comparable<Object> {
        public double prob;
        public int index;

        public ProbIndexPair(double prob, int index) {
            this.prob = prob;
            this.index = index;
        }

        @Override
        public int compareTo(Object o) {
            if (this.prob < ((ProbIndexPair)o).prob) {
                return -1;
            }
            if (this.prob == ((ProbIndexPair)o).prob) {
                return 0;
            }
            return 1;
        }
    }
}

