/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.hylo.NominalAtom;
import opennlp.ccg.hylo.NominalVar;
import opennlp.ccg.lexicon.LicensingFeature;
import opennlp.ccg.realize.EdgeFactory;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.CategoryFcnAdapter;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.SimpleSubstitution;
import opennlp.ccg.unify.Unifier;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;

public class FeatureLicenser {
    private final EdgeFactory edgeFactory;
    private final LicensingFeature[] licensingFeatures;
    private int wordCounter = 0;
    private Map<String, String> wordIndexMap = new HashMap<String, String>();
    private CategoryFcn semanticallyNullWordIndexer = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            if (!(c instanceof AtomCat)) {
                return;
            }
            FeatureStructure fs = c.getFeatureStructure();
            if (fs == null) {
                return;
            }
            if (!fs.hasAttribute("lex")) {
                return;
            }
            Object indexVal = fs.getValue("index");
            if (indexVal == null || indexVal instanceof NominalVar) {
                NominalAtom nom;
                String lexVal = fs.getValue("lex").toString();
                String index = (String)FeatureLicenser.this.wordIndexMap.get(lexVal);
                if (index == null) {
                    while (((FeatureLicenser)FeatureLicenser.this).edgeFactory.nominals.containsKey((Object)(nom = new NominalAtom(index = "w" + ++FeatureLicenser.this.wordCounter)))) {
                    }
                    FeatureLicenser.this.wordIndexMap.put(lexVal, index);
                    ((FeatureLicenser)FeatureLicenser.this).edgeFactory.nominals.put((Object)nom, ((FeatureLicenser)FeatureLicenser.this).edgeFactory.nominals.size());
                } else {
                    nom = new NominalAtom(index);
                }
                fs.setFeature("index", nom);
            }
        }
    };
    private Map<String, Map<String, Set<Category>>> featureMap = new HashMap<String, Map<String, Set<Category>>>();
    private Map<String, Map<String, Set<Category>>> catFeatureMap = new HashMap<String, Map<String, Set<Category>>>();
    private Map<String, Map<String, Set<Category>>> currentFeatureMap = null;
    private List<Category> allInitialAtomCats = new ArrayList<Category>();
    private CategoryFcn featureMapUpdater = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            FeatureStructure fs;
            if (!(c instanceof AtomCat)) {
                return;
            }
            if (FeatureLicenser.this.currentFeatureMap == FeatureLicenser.this.featureMap) {
                FeatureLicenser.this.allInitialAtomCats.add(c);
            }
            if ((fs = c.getFeatureStructure()) == null) {
                return;
            }
            for (int i = 0; i < FeatureLicenser.this.licensingFeatures.length; ++i) {
                HashSet<Category> acSet;
                String attr = ((FeatureLicenser)FeatureLicenser.this).licensingFeatures[i].attr;
                Object val = fs.getValue(attr);
                if (val == null || val instanceof Variable) continue;
                String valStr = val.toString();
                String fVal = ((FeatureLicenser)FeatureLicenser.this).licensingFeatures[i].val;
                List<String> alsoList = ((FeatureLicenser)FeatureLicenser.this).licensingFeatures[i].alsoLicensedBy;
                if (fVal != null && !fVal.equals(valStr) && !alsoList.contains(valStr)) continue;
                HashMap<String, HashSet<Category>> valMap = (HashMap<String, HashSet<Category>>)FeatureLicenser.this.currentFeatureMap.get(attr);
                if (valMap == null) {
                    valMap = new HashMap<String, HashSet<Category>>();
                    FeatureLicenser.this.currentFeatureMap.put(attr, valMap);
                }
                if ((acSet = (HashSet<Category>)valMap.get(valStr)) == null) {
                    acSet = new HashSet<Category>();
                    valMap.put(valStr, acSet);
                }
                acSet.add(c);
            }
        }
    };
    private LicensingFeature currentLicensingFeature = null;
    private SimpleSubstitution simpleSubst = new SimpleSubstitution();

    public FeatureLicenser(EdgeFactory edgeFactory) {
        this.edgeFactory = edgeFactory;
        this.licensingFeatures = edgeFactory.grammar.lexicon.getLicensingFeatures();
    }

    public FeatureLicenser(EdgeFactory edgeFactory, LicensingFeature[] licensingFeatures) {
        this.edgeFactory = edgeFactory;
        this.licensingFeatures = licensingFeatures;
    }

    public void indexSemanticallyNullWords(Category cat) {
        cat.forall(this.semanticallyNullWordIndexer);
    }

    public void updateFeatureMap(Category cat) {
        this.currentFeatureMap = this.featureMap;
        cat.forall(this.featureMapUpdater);
        this.currentFeatureMap = null;
    }

    private void updateCatFeatureMap(Category cat) {
        this.catFeatureMap.clear();
        this.currentFeatureMap = this.catFeatureMap;
        cat.forall(this.featureMapUpdater);
        this.currentFeatureMap = null;
    }

    public boolean needsLicensing(Category cat) {
        return this.checkLicensing(cat, true);
    }

    public boolean isLicensed(Category cat) {
        return this.checkLicensing(cat, false);
    }

    private boolean checkLicensing(Category cat, boolean needsLicensing) {
        this.currentLicensingFeature = null;
        boolean emptyCat = cat.getLF() == null;
        this.updateCatFeatureMap(cat);
        Category target = this.getTarget(cat);
        for (int i = 0; i < this.licensingFeatures.length; ++i) {
            Collection<String> vals;
            String attr;
            Map<String, Set<Category>> valMap;
            if (emptyCat && !this.licensingFeatures[i].licenseEmptyCats || !emptyCat && !this.licensingFeatures[i].licenseMarkedCats || (valMap = this.catFeatureMap.get(attr = this.licensingFeatures[i].attr)) == null) continue;
            String fVal = this.licensingFeatures[i].val;
            if (fVal != null) {
                if (!valMap.containsKey(fVal)) continue;
                vals = new ArrayList(1);
                vals.add(fVal);
            } else {
                vals = valMap.keySet();
            }
            byte loc = this.licensingFeatures[i].loc;
            for (String val : vals) {
                Set<Category> atomCats = valMap.get(val);
                if (loc != 1 ? loc == 2 && atomCats.contains(target) : atomCats.size() != 1 || !atomCats.contains(target)) continue;
                if (needsLicensing) {
                    return true;
                }
                Map<String, Set<Category>> fmValMap = this.featureMap.get(attr);
                if (fmValMap == null) {
                    return false;
                }
                boolean foundLicensingVal = fmValMap.containsKey(val);
                if (!foundLicensingVal) {
                    List<String> alsoList = this.licensingFeatures[i].alsoLicensedBy;
                    for (int j = 0; j < alsoList.size(); ++j) {
                        if (!fmValMap.containsKey(alsoList.get(j))) continue;
                        foundLicensingVal = true;
                        break;
                    }
                }
                if (!foundLicensingVal) {
                    return false;
                }
                this.currentLicensingFeature = this.licensingFeatures[i];
                return true;
            }
        }
        return false;
    }

    private Category getTarget(Category cat) {
        Category target = cat;
        if (cat instanceof ComplexCat) {
            target = ((ComplexCat)cat).getTarget();
        }
        return target;
    }

    public void licenseEmptyCat(Category cat, Set<Category> instantiatedCats, Set<Category> uninstantiatedCats) {
        Map<String, Set<Category>> valMap;
        UnifyControl.reindex(cat);
        if (!this.needsLicensing(cat)) {
            uninstantiatedCats.add(cat);
            return;
        }
        if (!this.isLicensed(cat)) {
            return;
        }
        if (this.currentLicensingFeature == null) {
            for (int i = 0; i < this.licensingFeatures.length; ++i) {
                if (!this.catFeatureMap.containsKey(this.licensingFeatures[i].attr)) continue;
                valMap = this.catFeatureMap.get(this.licensingFeatures[i].attr);
                String fVal = this.licensingFeatures[i].val;
                if (fVal != null && !valMap.containsKey(fVal)) continue;
                this.currentLicensingFeature = this.licensingFeatures[i];
                break;
            }
            if (this.currentLicensingFeature == null) {
                uninstantiatedCats.add(cat);
                return;
            }
        }
        if (!this.currentLicensingFeature.instantiate) {
            uninstantiatedCats.add(cat);
            return;
        }
        String attr = this.currentLicensingFeature.attr;
        valMap = this.catFeatureMap.get(attr);
        if (valMap.size() > 1) {
            uninstantiatedCats.add(cat);
            return;
        }
        String val = valMap.keySet().iterator().next();
        Set<Category> atomCats = valMap.get(val);
        for (Category ac : atomCats) {
            FeatureStructure fs = ac.getFeatureStructure();
            if (fs.hasAttribute("lex") && !fs.hasAttribute("index")) {
                fs.setFeature("index", new NominalVar("W"));
                UnifyControl.reindex(ac);
            }
            Collection<Category> initialCats = null;
            if (!this.currentLicensingFeature.licenseEmptyCats) {
                initialCats = this.allInitialAtomCats;
            } else {
                Map<String, Set<Category>> fmValMap = this.featureMap.get(attr);
                initialCats = fmValMap.get(val);
                List<String> alsoList = this.currentLicensingFeature.alsoLicensedBy;
                if (alsoList.size() > 0) {
                    initialCats = initialCats != null ? new HashSet<Category>(initialCats) : new HashSet();
                    for (int i = 0; i < alsoList.size(); ++i) {
                        Set<Category> alsoSet = fmValMap.get(alsoList.get(i));
                        if (alsoSet == null) continue;
                        initialCats.addAll(alsoSet);
                    }
                }
            }
            if (initialCats == null) {
                System.out.println("Warning, unable to find initial cats for feature " + attr + "=" + val);
                uninstantiatedCats.add(cat);
                return;
            }
            for (Category initialAC : initialCats) {
                Object index;
                FeatureStructure initialFS = initialAC.getFeatureStructure();
                if (initialFS == null || !((index = initialFS.getValue("index")) instanceof NominalAtom)) continue;
                if (this.edgeFactory.boundVarNominals.contains(index)) {
                    instantiatedCats.clear();
                    uninstantiatedCats.add(cat);
                    return;
                }
                this.simpleSubst.clear();
                try {
                    Unifier.unify(ac.getFeatureStructure(), initialFS, this.simpleSubst);
                    if (!this.simpleSubst.containsValue(index)) continue;
                    Iterator it2 = this.simpleSubst.values().iterator();
                    while (it2.hasNext()) {
                        if (it2.next().equals(index)) continue;
                        it2.remove();
                    }
                    Category instCat = (Category)cat.fill(this.simpleSubst);
                    instantiatedCats.add(instCat);
                }
                catch (UnifyFailure unifyFailure) {}
            }
        }
    }
}

