/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.hylo.Alt;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.ngrams.NgramPrecisionModel;
import opennlp.ccg.parse.DerivationHistory;
import opennlp.ccg.realize.Edge;
import opennlp.ccg.realize.EdgeFactory;
import opennlp.ccg.realize.EdgeHash;
import opennlp.ccg.realize.PruningStrategy;
import opennlp.ccg.realize.RuleInstance;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.util.Pair;

public class Chart {
    public static final String TIME_LIMIT = "Time Limit";
    public static final String NEW_BEST_TIME_LIMIT = "New Best Time Limit";
    public static final int NO_TIME_LIMIT = 0;
    public static final String EDGE_LIMIT = "Edge Limit";
    public static final int NO_EDGE_LIMIT = 0;
    public static final String PRUNING_VALUE = "Pruning Value";
    public static final String CELL_PRUNING_VALUE = "Cell Pruning Value";
    public static final int NO_PRUNING = 0;
    public static final String USE_COMBOS = "Use Combos";
    public static final String USE_PACKING = "Use Packing";
    public static final String DO_UNPACKING = "Do Unpacking";
    public final EdgeFactory edgeFactory;
    public final PruningStrategy pruningStrategy;
    public boolean depthFirst = false;
    public int newBestTimeLimit = 0;
    public double newBestTimeLimitPct = 0.0;
    public int edgeLimit = 0;
    public int pruningValue = 0;
    public int cellPruningValue = 0;
    public boolean collectCombos = true;
    public boolean usePacking = false;
    public boolean doUnpacking = true;
    public boolean joinFragments = false;
    public boolean gluingFragments = false;
    private List<Edge> agenda = new ArrayList<Edge>();
    private List<Edge> edges = new ArrayList<Edge>();
    private List<Edge> allEdges = new ArrayList<Edge>();
    private List<Edge> supercededEdgesPendingRemoval = new ArrayList<Edge>();
    private Map<Sign, Edge> signMap = new IdentityHashMap<Sign, Edge>();
    private EdgeHash edgeHash = new EdgeHash();
    private Map<Edge, Edge> catMap = new THashMap(new TObjectHashingStrategy(){
        private static final long serialVersionUID = 1L;

        public int computeHashCode(Object o) {
            Edge edge = (Edge)o;
            return edge.bitset.hashCode() + edge.sign.getCategory().hashCodeNoLF();
        }

        public boolean equals(Object o1, Object o2) {
            Edge edge1 = (Edge)o1;
            Edge edge2 = (Edge)o2;
            return edge1.bitset.equals(edge2.bitset) && edge1.sign.getCategory().equalsNoLF(edge2.sign.getCategory());
        }
    });
    private Map<BitSet, Integer> cellMap = new HashMap<BitSet, Integer>();
    private Set<BitSet> nonEmptyCells = null;
    private transient BitSet tmpBitSet = new BitSet();
    public Edge bestEdge = null;
    public Edge bestJoinedEdge = null;
    public boolean done = false;
    public int numNominals = 0;
    public int numPreds = 0;
    public int numEdges = 0;
    public int numPrunedRemoved = 0;
    public int numPrunedNeverAdded = 0;
    public int newBest = 0;
    public int cellMax = 0;
    protected long startTime = System.currentTimeMillis();
    public int timeTilLex = 0;
    public int timeTilFirst = 0;
    public int timeTilBest = 0;
    public int timeTilStopped = 0;
    public int timeTilPacked = 0;
    public int timeTilDone = 0;
    private transient List<Edge> bestEdges = null;
    public PrintWriter out = new PrintWriter(System.out);
    public static final Comparator<Edge> edgeComparator = new Comparator<Edge>(){

        @Override
        public int compare(Edge edge1, Edge edge2) {
            return -1 * Double.compare(edge1.score, edge2.score);
        }
    };
    public static final Comparator<Edge> edgeSizeComparator = new Comparator<Edge>(){

        @Override
        public int compare(Edge edge1, Edge edge2) {
            int retval = -1 * Float.compare(edge1.completeness, edge2.completeness);
            if (retval != 0) {
                return retval;
            }
            return -1 * Double.compare(edge1.score, edge2.score);
        }
    };

    public Chart(EdgeFactory edgeFactory, PruningStrategy pruningStrategy) {
        this.edgeFactory = edgeFactory;
        this.pruningStrategy = pruningStrategy;
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        this.newBestTimeLimitPct = prefs.getDouble(NEW_BEST_TIME_LIMIT, 0.0);
        if (this.newBestTimeLimitPct >= 1.0) {
            this.newBestTimeLimit = (int)this.newBestTimeLimitPct;
            this.newBestTimeLimitPct = 0.0;
        }
        this.edgeLimit = prefs.getInt(EDGE_LIMIT, 0);
        this.pruningValue = prefs.getInt(PRUNING_VALUE, 0);
        this.cellPruningValue = prefs.getInt(CELL_PRUNING_VALUE, 0);
        this.usePacking = prefs.getBoolean(USE_PACKING, false);
        this.collectCombos = !this.usePacking && prefs.getBoolean(USE_COMBOS, true);
        this.doUnpacking = this.usePacking && prefs.getBoolean(DO_UNPACKING, true);
    }

    public int numEdgesInChart() {
        return this.edges.size();
    }

    public int numUnprunedEdges() {
        return this.allEdges.size();
    }

    public void initialize() {
        this.numNominals = this.edgeFactory.nominals.size();
        this.numPreds = this.edgeFactory.preds.size();
        for (Edge edge : this.edgeFactory.createInitialEdges()) {
            this.addEdgeToAgenda(edge);
        }
        long currentTime = System.currentTimeMillis();
        this.timeTilLex = (int)(currentTime - this.startTime);
    }

    public boolean noUncoveredPreds() {
        return !this.edgeFactory.hasUncoveredPreds;
    }

    public void reInitForGluing() {
        if (!this.usePacking) {
            throw new RuntimeException("Packing mode required for gluing fragments.");
        }
        this.gluingFragments = true;
        this.edgeFactory.gluingFragments = true;
        this.edgeFactory.useIndexing = false;
        if (!this.edgeFactory.useRelaxedRelationMatching) {
            this.edgeFactory.addLFOptsForUncoveredPreds();
        }
        this.edgeFactory.addLFOptsForRuleInstances();
        this.nonEmptyCells = new HashSet<BitSet>(this.cellMap.keySet());
        for (Edge edge : this.edges) {
            this.addEdgeToAgenda(edge);
        }
    }

    public void combine(int timeLimitMS, boolean waitForCompleteEdge) {
        while (!this.agenda.isEmpty()) {
            boolean bestEdgeComplete;
            long currentTime = System.currentTimeMillis();
            int timeSoFar = (int)(currentTime - this.startTime);
            int timeSinceFirst = timeSoFar - this.timeTilFirst;
            boolean bl = bestEdgeComplete = this.bestEdge != null && this.bestEdge.complete();
            if (this.edgeLimit != 0 && this.numEdges > this.edgeLimit && (!waitForCompleteEdge || bestEdgeComplete) || timeLimitMS != 0 && timeSoFar > timeLimitMS && (!waitForCompleteEdge || bestEdgeComplete) || !this.usePacking && bestEdgeComplete && (this.newBestTimeLimit != 0 && timeSinceFirst > this.newBestTimeLimit || this.newBestTimeLimitPct != 0.0 && (double)timeSinceFirst / (double)this.timeTilFirst > this.newBestTimeLimitPct)) {
                if (!this.allEdges.contains(this.bestEdge)) {
                    this.addEdgeToChart(this.bestEdge);
                }
                this.timeTilStopped = timeSoFar;
                break;
            }
            Edge next = this.agenda.remove(0);
            boolean actuallyAdded = this.addEdgeToChart(next);
            if (!actuallyAdded) continue;
            this.doEdgeCombos(next);
        }
        if (this.usePacking) {
            long donePackingTime = System.currentTimeMillis();
            this.timeTilPacked = (int)(donePackingTime - this.startTime);
            if (this.doUnpacking) {
                this.doUnpacking();
            }
        }
        this.done = this.agenda.isEmpty();
        if (this.done) {
            long endTime = System.currentTimeMillis();
            this.timeTilDone = (int)(endTime - this.startTime);
        }
        if (this.joinFragments && !this.bestEdge.complete()) {
            this.joinBestFragments();
        }
    }

    private void doEdgeCombos(Edge next) {
        Edge nextRep;
        if (this.gluingFragments && next.bitset.isEmpty()) {
            return;
        }
        if (this.collectCombos && next != (nextRep = this.catMap.get(next))) {
            this.addNewEdges(this.edgeFactory.createAltEdges(next, nextRep));
            this.pruneSupercededEdges();
            return;
        }
        List<Edge> edgesToUse = this.usePacking || this.collectCombos ? this.edges : this.allEdges;
        for (Edge edge : edgesToUse) {
            if (edge == next) continue;
            if (this.gluingFragments) {
                if (edge.bitset.isEmpty()) continue;
                this.tmpBitSet.clear();
                this.tmpBitSet.or(edge.bitset);
                this.tmpBitSet.or(next.bitset);
                if (this.nonEmptyCells.contains(this.tmpBitSet)) continue;
            }
            this.addNewEdges(this.edgeFactory.createNewEdges(edge, next, this.collectCombos));
        }
        this.addNewEdges(this.edgeFactory.createNewEdges(next, this.collectCombos));
        this.pruneSupercededEdges();
    }

    private void addNewEdges(List<Edge> newEdges) {
        for (Edge newEdge : newEdges) {
            this.addEdgeToAgenda(newEdge);
        }
    }

    protected void joinBestFragments() {
        this.bestJoinedEdge = this.bestEdge;
        ArrayList<Edge> fragments = new ArrayList<Edge>();
        BitSet bitset = this.bestEdge.bitset;
        while (true) {
            Edge bestFrag = null;
            for (Edge edge : this.allEdges) {
                bestFrag = this.chooseBestFrag(bitset, bestFrag, edge);
            }
            for (Edge edge : this.agenda) {
                bestFrag = this.chooseBestFrag(bitset, bestFrag, edge);
            }
            if (bestFrag == null) break;
            fragments.add(bestFrag);
            bitset = (BitSet)bitset.clone();
            bitset.or(bestFrag.bitset);
        }
        while (fragments.size() > 0) {
            Edge nextJoinedEdge = null;
            Edge nextFrag = null;
            for (Edge edge : fragments) {
                Edge joinedEdge = this.edgeFactory.makeJoinedEdge(this.bestJoinedEdge, edge);
                if (nextJoinedEdge == null || nextJoinedEdge.score < joinedEdge.score) {
                    nextJoinedEdge = joinedEdge;
                    nextFrag = edge;
                }
                Edge joinedEdgeR = this.edgeFactory.makeJoinedEdge(edge, this.bestJoinedEdge);
                if (!(nextJoinedEdge.score < joinedEdgeR.score)) continue;
                nextJoinedEdge = joinedEdgeR;
                nextFrag = edge;
            }
            this.bestJoinedEdge = nextJoinedEdge;
            fragments.remove(nextFrag);
        }
    }

    private Edge chooseBestFrag(BitSet bitset, Edge bestFrag, Edge edge) {
        if (edge.bitset.isEmpty() || edge.bitset.intersects(bitset)) {
            return bestFrag;
        }
        if (bestFrag == null) {
            return edge;
        }
        if (bestFrag.completeness < edge.completeness) {
            return edge;
        }
        if (bestFrag.completeness == edge.completeness && bestFrag.score < edge.score) {
            return edge;
        }
        return bestFrag;
    }

    protected void doUnpacking() {
        THashSet unpacked = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
        boolean foundComplete = this.bestEdge.complete();
        for (Edge edge : this.edges) {
            if (foundComplete && !edge.complete()) continue;
            this.unpack(edge, (Set<Edge>)unpacked);
            this.updateBestEdge(edge.altEdges.get(0));
        }
    }

    private void unpack(Edge edge, Set<Edge> unpacked) {
        if (unpacked.contains(edge)) {
            return;
        }
        unpacked.add(edge);
        EdgeHash merged = new EdgeHash();
        if (edge.altEdges == null) {
            throw new RuntimeException("No alts for: " + edge);
        }
        for (Edge alt : edge.altEdges) {
            this.unpackAlt(alt, unpacked, merged);
        }
        ArrayList<Edge> mergedList = new ArrayList<Edge>(merged.asEdgeSet());
        Collections.sort(mergedList, edgeComparator);
        List<Edge> prunedEdges = this.pruningStrategy.pruneEdges(mergedList);
        this.numPrunedNeverAdded += prunedEdges.size();
        edge.altEdges.clear();
        edge.altEdges.addAll(mergedList);
        this.allEdges.addAll(mergedList);
        for (Edge mergedEdge : mergedList) {
            if (this.signMap.containsKey(mergedEdge.sign)) continue;
            this.signMap.put(mergedEdge.sign, mergedEdge);
        }
    }

    private void unpackAlt(Edge alt, Set<Edge> unpacked, EdgeHash merged) {
        if (alt.optCompletes != null) {
            Edge inputEdge = alt.optCompletes;
            this.unpack(inputEdge, unpacked);
            for (Edge inputAlt : inputEdge.altEdges) {
                Edge edgeToAdd = inputAlt.sign == alt.sign ? alt : this.edgeFactory.makeAltEdge(inputAlt.sign, alt);
                merged.insert(edgeToAdd);
            }
            return;
        }
        DerivationHistory history = alt.sign.getDerivationHistory();
        Sign[] inputSigns = history.getInputs();
        if (inputSigns == null) {
            merged.insert(alt);
            return;
        }
        Edge[] inputEdges = new Edge[inputSigns.length];
        for (int i = 0; i < inputSigns.length; ++i) {
            inputEdges[i] = this.signMap.get(inputSigns[i]);
            this.unpack(inputEdges[i], unpacked);
        }
        Category resultCat = alt.sign.getCategory();
        boolean lefthead = alt.sign.getLexHead() == inputSigns[0].getLexHead();
        List<Sign[]> altCombos = this.inputCombos(inputEdges, 0);
        for (Sign[] combo : altCombos) {
            Sign lexHead = lefthead ? combo[0].getLexHead() : combo[1].getLexHead();
            Sign sign = Sign.createDerivedSignWithNewLF(resultCat, combo, history.getRule(), lexHead);
            Edge edgeToAdd = sign.equals(alt.sign) ? alt : this.edgeFactory.makeAltEdge(sign, alt);
            merged.insert(edgeToAdd);
        }
    }

    private List<Sign[]> inputCombos(Edge[] inputEdges, int index) {
        Edge edge = inputEdges[index];
        if (index == inputEdges.length - 1) {
            List<Edge> altEdges = edge.altEdges;
            ArrayList<Sign[]> retval = new ArrayList<Sign[]>(altEdges.size());
            for (Edge alt : altEdges) {
                retval.add(new Sign[]{alt.sign});
            }
            return retval;
        }
        List<Sign[]> nextCombos = this.inputCombos(inputEdges, index + 1);
        List<Edge> altEdges = edge.altEdges;
        ArrayList<Sign[]> retval = new ArrayList<Sign[]>(altEdges.size() * nextCombos.size());
        for (Edge alt : altEdges) {
            for (int i = 0; i < nextCombos.size(); ++i) {
                Sign[] nextSigns = nextCombos.get(i);
                Sign[] newCombo = new Sign[nextSigns.length + 1];
                newCombo[0] = alt.sign;
                System.arraycopy(nextSigns, 0, newCombo, 1, nextSigns.length);
                retval.add(newCombo);
            }
        }
        return retval;
    }

    public List<Edge> bestEdges() {
        if (this.bestEdges != null) {
            return this.bestEdges;
        }
        this.bestEdges = new ArrayList<Edge>();
        if (!this.bestEdge.complete()) {
            return this.bestEdges;
        }
        List<Edge> edgesToUse = this.usePacking && !this.doUnpacking ? this.edges : this.allEdges;
        for (Edge edge : edgesToUse) {
            if (!edge.complete()) continue;
            this.bestEdges.add(edge);
        }
        Collections.sort(this.bestEdges, edgeComparator);
        this.pruningStrategy.pruneEdges(this.bestEdges);
        return this.bestEdges;
    }

    public Pair<Edge, Boolean> oracleBest(String target) {
        List<Edge> edges = this.bestEdges();
        for (Edge edge : edges) {
            if (!edge.getSign().getOrthography().equals(target)) continue;
            return new Pair<Edge, Boolean>(edge, true);
        }
        Edge retval = null;
        double bestScore = 0.0;
        NgramPrecisionModel oracle = new NgramPrecisionModel(new String[]{target});
        for (Edge edge : edges) {
            double score = oracle.score(edge.getSign(), true);
            if (!(score > bestScore)) continue;
            retval = edge;
            bestScore = score;
        }
        return new Pair<Object, Boolean>(retval, false);
    }

    public void printBestEdge() {
        this.printEdge(this.bestEdge);
        if (!this.edgeFactory.labeledNominals.isEmpty()) {
            try {
                ByteArrayOutputStream bstr = new ByteArrayOutputStream();
                this.edgeFactory.grammar.serializeXml(this.bestEdge.sign.getWordsInXml(this.edgeFactory.labeledNominals), bstr);
                this.out.println(bstr.toString());
            }
            catch (IOException exc) {
                throw (RuntimeException)new RuntimeException().initCause(exc);
            }
        }
        this.out.println(this.bestEdge.sign.getBracketedString());
        this.out.flush();
    }

    public void printBestJoinedEdge() {
        if (this.bestJoinedEdge == null) {
            return;
        }
        this.printEdge(this.bestJoinedEdge);
        this.out.println(this.bestJoinedEdge.sign.getBracketedString());
        this.out.flush();
    }

    public void printTiming() {
        this.out.println();
        if (!this.usePacking) {
            if (this.bestEdge != null && this.bestEdge.complete()) {
                this.out.println("time 'til first   (ms): " + this.timeTilFirst);
            }
            if (this.bestEdge != null) {
                this.out.println("time 'til best    (ms): " + this.timeTilBest);
            }
            if (this.timeTilStopped != 0) {
                this.out.println("time 'til stopped (ms): " + this.timeTilStopped);
            }
        } else {
            this.out.println("time 'til packed  (ms): " + this.timeTilPacked);
        }
        if (this.timeTilDone != 0) {
            this.out.println("time 'til done    (ms): " + this.timeTilDone);
        }
        this.out.println();
        this.out.println("rule apps:   " + this.edgeFactory.ruleApps());
        this.out.println("# edges:     " + this.edges.size());
        this.out.println("# unpruned edges:     " + this.allEdges.size());
        if (!this.usePacking) {
            this.out.println("# pruned:    " + this.numPrunedRemoved + " removed, " + this.numPrunedNeverAdded + " never added");
        }
        if (this.doUnpacking) {
            this.out.println("# pruned:    " + this.numPrunedNeverAdded);
        }
        this.out.println("cell max:    " + this.cellMax);
        this.out.flush();
    }

    public void printEdges() {
        this.printEdges(false);
    }

    public void printEdges(boolean complete) {
        this.printEdges(complete, false);
    }

    public void printEdges(boolean complete, boolean sort) {
        List<Edge> edgeList;
        List<Edge> list = edgeList = this.usePacking && !this.doUnpacking ? this.edges : this.allEdges;
        if (sort) {
            edgeList = new ArrayList<Edge>(edgeList);
            Collections.sort(edgeList, edgeComparator);
        }
        for (int i = 0; i < edgeList.size(); ++i) {
            Edge edge = edgeList.get(i);
            if (complete && !edge.complete()) continue;
            if (!sort) {
                this.printEdge(edge, i, edgeList);
                continue;
            }
            this.printEdge(edge);
        }
        this.out.flush();
    }

    public void printAgenda() {
        for (Edge edge : this.agenda) {
            this.printEdge(edge);
        }
        this.out.flush();
    }

    public void printInitialEdges() {
        for (Edge edge : this.edgeFactory.initialEdges) {
            this.printEdge(edge);
        }
        this.out.flush();
    }

    private void printEdge(Edge edge) {
        this.printEdge(edge, -1, null);
    }

    private void printEdge(Edge edge, int index, List<Edge> edgeList) {
        String str = "";
        if (index >= 0) {
            str = str + index + ". ";
        }
        str = str + edge.toString();
        if (edge.incompleteLfChunk != null) {
            int id = this.edgeFactory.lfChunks.indexOf(edge.incompleteLfChunk);
            str = str + " <[" + id + "]>";
        }
        if (edge.activeLfAlts.size() > 0) {
            str = str + " ";
        }
        for (List altSet : edge.activeLfAlts) {
            for (Alt alt : altSet) {
                str = str + "?" + alt.altSet + "." + alt.numInSet;
            }
        }
        str = str + this.edgeDerivation(edge, index, edgeList);
        this.out.println(str);
        if (this.usePacking && !this.doUnpacking && edge.isDisjunctive()) {
            for (Edge alt : edge.altEdges) {
                if (alt == edge) continue;
                this.out.println(" \\_ " + alt + this.edgeDerivation(alt, index, edgeList));
            }
        }
    }

    private String edgeDerivation(Edge edge, int index, List<Edge> edgeList) {
        if (index < 0) {
            return "";
        }
        if (edge.optCompletes != null) {
            return " (" + edgeList.indexOf(edge.optCompletes) + " optC)";
        }
        DerivationHistory history = edge.sign.getDerivationHistory();
        Sign[] inputs = history.getInputs();
        if (inputs == null) {
            return " (lex)";
        }
        String retval = " (";
        for (Sign sign : inputs) {
            Edge repEdge = this.signMap.get(sign);
            if (repEdge == null) continue;
            retval = retval + edgeList.indexOf(repEdge) + " ";
        }
        retval = retval + history.getRule().name() + ")";
        return retval;
    }

    public void printMarkedEdges() {
        for (Edge edge : this.edgeFactory.markedEdges) {
            this.printEdge(edge);
        }
        this.out.flush();
    }

    public void printInstantiatedNoSemEdges() {
        for (Edge edge : this.edgeFactory.instantiatedNoSemEdges) {
            this.printEdge(edge);
        }
        this.out.flush();
    }

    public void printNoSemEdges() {
        for (Edge edge : this.edgeFactory.noSemEdges) {
            this.out.println(edge.toString());
        }
        this.out.flush();
    }

    public void printRuleInstances() {
        Iterator<RuleInstance> it = this.edgeFactory.ruleInstances.iterator();
        while (it.hasNext()) {
            this.out.println(((Object)it.next()).toString());
        }
        this.out.flush();
    }

    public void printLfChunks() {
        List<BitSet> chunks = this.edgeFactory.lfChunks;
        for (int i = 0; i < chunks.size(); ++i) {
            BitSet chunk = chunks.get(i);
            this.out.println("chunk[" + i + "]:  " + Edge.toString(chunk));
        }
        this.out.flush();
    }

    public void printLfAlts() {
        for (List<Alt> altSet : this.edgeFactory.lfAlts) {
            for (Alt alt : altSet) {
                this.out.print("alt[" + alt.altSet + "." + alt.numInSet + "]: ");
                this.out.println(Edge.toString(alt.bitset));
            }
        }
        this.out.flush();
    }

    public void printLfOpts() {
        List<BitSet> opts = this.edgeFactory.lfOpts;
        for (int i = 0; i < opts.size(); ++i) {
            BitSet opt = opts.get(i);
            this.out.println("opt[" + i + "]:  " + Edge.toString(opt));
        }
        this.out.flush();
    }

    public void printEPs() {
        List<SatOp> preds = this.edgeFactory.preds;
        for (int i = 0; i < preds.size(); ++i) {
            SatOp lf_i = preds.get(i);
            this.out.println("ep[" + i + "]:  " + lf_i);
        }
        this.out.flush();
    }

    private void addEdgeToAgenda(Edge edge) {
        ++this.numEdges;
        if (!this.usePacking) {
            boolean inChart;
            Edge repEdge;
            boolean onAgenda;
            Edge oldEdge;
            boolean actuallyInserted;
            Edge retEdge = this.edgeHash.insert(edge);
            boolean bl = actuallyInserted = retEdge != null;
            if (!actuallyInserted) {
                return;
            }
            Edge edge2 = oldEdge = retEdge != edge ? retEdge : null;
            if (oldEdge != null && !(onAgenda = this.agenda.remove(oldEdge)) && (repEdge = this.catMap.get(oldEdge)) != null && (inChart = repEdge.altEdges.remove(oldEdge))) {
                this.supercededEdgesPendingRemoval.add(oldEdge);
            }
        }
        if (this.depthFirst) {
            this.agenda.add(0, edge);
        } else if (edge.score == 0.0) {
            this.agenda.add(edge);
        } else {
            this.addSorted(this.agenda, edge);
        }
        this.updateBestEdge(edge);
    }

    private void updateBestEdge(Edge edge) {
        if (this.bestEdge == null) {
            this.bestEdge = edge;
            long endTime = System.currentTimeMillis();
            this.timeTilBest = (int)(endTime - this.startTime);
            if (this.bestEdge.complete()) {
                this.timeTilFirst = this.timeTilBest;
            }
            return;
        }
        if (this.bestEdge.completeness > edge.completeness) {
            return;
        }
        if (this.bestEdge.completeness < edge.completeness) {
            this.bestEdge = edge;
            long endTime = System.currentTimeMillis();
            this.timeTilBest = (int)(endTime - this.startTime);
            if (this.bestEdge.complete()) {
                this.timeTilFirst = this.timeTilBest;
            }
            return;
        }
        if (edge.score > this.bestEdge.score) {
            this.bestEdge = edge;
            long endTime = System.currentTimeMillis();
            this.timeTilBest = (int)(endTime - this.startTime);
            if (this.bestEdge.complete()) {
                ++this.newBest;
            }
        }
    }

    private void pruneSupercededEdges() {
        for (Edge oldEdge : this.supercededEdgesPendingRemoval) {
            this.allEdges.remove(oldEdge);
            ++this.numPrunedRemoved;
        }
        this.supercededEdgesPendingRemoval.clear();
    }

    private boolean addEdgeToChart(Edge edge) {
        if (this.cellPruningValue != 0 && this.cellCount(edge) >= this.cellPruningValue) {
            ++this.numPrunedNeverAdded;
            return false;
        }
        this.incCellCount(edge);
        Edge repEdge = this.catMap.get(edge);
        if (edge == repEdge) {
            return true;
        }
        if (repEdge == null) {
            edge.initAltEdges();
            if (this.collectCombos) {
                edge.initEdgeCombos();
            }
            this.catMap.put(edge, edge);
            this.edges.add(edge);
            this.signMap.put(edge.sign, edge);
            if (!this.usePacking) {
                this.allEdges.add(edge);
            }
            return true;
        }
        this.addSorted(repEdge.altEdges, edge);
        if (this.usePacking) {
            return false;
        }
        if (this.pruningValue == 0) {
            this.allEdges.add(edge);
            this.signMap.put(edge.sign, edge);
            return true;
        }
        List<Edge> prunedEdges = this.pruningStrategy.pruneEdges(repEdge.altEdges);
        boolean edgeItselfPruned = false;
        for (Edge prunedEdge : prunedEdges) {
            if (prunedEdge != edge) {
                this.allEdges.remove(prunedEdge);
                ++this.numPrunedRemoved;
                continue;
            }
            edgeItselfPruned = true;
        }
        if (!edgeItselfPruned) {
            this.allEdges.add(edge);
            this.signMap.put(edge.sign, edge);
            return true;
        }
        ++this.numPrunedNeverAdded;
        return false;
    }

    private int cellCount(Edge edge) {
        Integer count = this.cellMap.get(edge.bitset);
        return count == null ? 0 : count;
    }

    private void incCellCount(Edge edge) {
        int count = this.cellCount(edge);
        this.cellMap.put(edge.bitset, ++count);
        if (count > this.cellMax) {
            this.cellMax = count;
        }
    }

    private void addSorted(List<Edge> list, Edge edge) {
        Comparator<Edge> comparator = this.gluingFragments ? edgeSizeComparator : edgeComparator;
        int index = Collections.binarySearch(list, edge, comparator);
        if (index >= 0) {
            Edge existingEdge;
            while (index < list.size() && comparator.compare(existingEdge = list.get(index), edge) == 0) {
                ++index;
            }
        } else {
            index = Math.abs(index) - 1;
        }
        list.add(index, edge);
    }
}

