/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.perceptron;

import java.util.ArrayList;
import java.util.Iterator;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureVector;

public class FeatureList
implements FeatureVector {
    private static final long serialVersionUID = 325935806787566283L;
    private ArrayList<Alphabet.Feature> features;
    private ArrayList<Float> values;

    public FeatureList() {
        this.features = new ArrayList();
        this.values = new ArrayList();
    }

    public FeatureList(int size) {
        this.features = new ArrayList(size);
        this.values = new ArrayList(size);
    }

    public FeatureList(FeatureVector fv) {
        FeatureVector.Iterator it = fv.iterator();
        while (it.hasNext()) {
            this.add(it.nextFeature(), it.nextValue());
        }
    }

    public void add(Alphabet.Feature feature, Float value) {
        this.features.add(feature);
        this.values.add(value);
    }

    public void add(FeatureVector fv) {
        this.features.ensureCapacity(this.size() + fv.size());
        this.values.ensureCapacity(this.size() + fv.size());
        FeatureVector.Iterator it = fv.iterator();
        while (it.hasNext()) {
            this.add(it.nextFeature(), it.nextValue());
        }
    }

    public Alphabet.Feature getFeature(int index) {
        return this.features.get(index);
    }

    public Float getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public int size() {
        return this.features.size();
    }

    @Override
    public FeatureVector.Iterator iterator() {
        return new FeatureVector.Iterator(){
            Iterator<Alphabet.Feature> itF;
            Iterator<Float> itV;
            {
                this.itF = FeatureList.this.features.iterator();
                this.itV = FeatureList.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itF.hasNext();
            }

            @Override
            public Alphabet.Feature nextFeature() {
                return this.itF.next();
            }

            @Override
            public Float nextValue() {
                return this.itV.next();
            }
        };
    }

    public String toString() {
        String retval = "features: ";
        for (int i = 0; i < this.features.size(); ++i) {
            retval = retval + "<" + this.getFeature(i).name() + "," + this.getValue(i) + "> ";
        }
        return retval;
    }
}

