/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.perceptron;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.perceptron.EventFile;
import opennlp.ccg.perceptron.FeatureMap;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.util.TrieMap;

public class Alphabet {
    private Feature dict;
    private List<Feature> dictInv;
    private int size = 0;
    private boolean closed = false;

    public Alphabet(int size) {
        this.init(size);
    }

    public Alphabet(String filename) throws IOException {
        Reader reader = EventFile.openReader(new File(filename));
        StreamTokenizer tokenizer = EventFile.initTokenizer(reader);
        tokenizer.nextToken();
        int size = Integer.parseInt(tokenizer.sval);
        this.init(size);
        for (int i = 0; i < size; ++i) {
            tokenizer.nextToken();
            this.add(tokenizer.sval);
            tokenizer.nextToken();
        }
        reader.close();
        this.closed = true;
    }

    private void init(int size) {
        this.dict = new Feature(null);
        this.dictInv = new ArrayList<Feature>(size);
    }

    public int size() {
        return this.size;
    }

    public boolean closed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Feature add(String feat) {
        return this.add(Alphabet.parseKeys(feat));
    }

    public Feature add(Feature f) {
        return this.add(f.traceKeys());
    }

    public Feature add(List<String> keys) {
        if (this.closed) {
            throw new RuntimeException("Can't add to a closed alphabet!");
        }
        Feature node = (Feature)this.dict.findChildFromList(keys);
        return this.addNode(node);
    }

    public Feature addLazy(List<TrieMap.KeyExtractor<String>> keyExtractors) {
        if (this.closed) {
            throw new RuntimeException("Can't add to a closed alphabet!");
        }
        Feature node = (Feature)this.dict.findChildFromLazyList(keyExtractors);
        return this.addNode(node);
    }

    private Feature addNode(Feature node) {
        if (node.data != null) {
            return node;
        }
        node.data = this.size++;
        this.dictInv.add(node);
        return node;
    }

    public static List<String> parseKeys(String feat) {
        ArrayList<String> retval = new ArrayList<String>();
        int current = 0;
        while (current < feat.length()) {
            String key;
            int breakpos = feat.indexOf(":", current);
            if (breakpos >= 0) {
                key = feat.substring(current, breakpos);
                current = breakpos + 1;
            } else {
                key = feat.substring(current);
                current = feat.length();
            }
            retval.add(DefaultTokenizer.unescape(key).intern());
        }
        return retval;
    }

    public Feature index(String feat) {
        return this.index(Alphabet.parseKeys(feat));
    }

    public Feature index(Feature f) {
        return this.index(f.traceKeys());
    }

    public Feature index(List<String> keys) {
        if (!this.closed) {
            return this.add(keys);
        }
        Feature node = (Feature)this.dict.getChildFromList(keys);
        return node;
    }

    public Feature indexLazy(List<TrieMap.KeyExtractor<String>> keyExtractors) {
        if (!this.closed) {
            return this.addLazy(keyExtractors);
        }
        Feature node = (Feature)this.dict.getChildFromLazyList(keyExtractors);
        return node;
    }

    public Feature feature(int index) {
        return this.dictInv.get(index);
    }

    /*
     * WARNING - void declaration
     */
    public static void createAlphabet(String eventfile, String alphabetfile, int tablesize, int pruningthreshold) throws IOException {
        void var12_24;
        EventFile.Block block;
        EventFile eventFile = new EventFile(eventfile);
        PrintWriter out = EventFile.openWriter(new File(alphabetfile));
        HashMap<Feature, Integer> freqTally = new HashMap<Feature, Integer>(tablesize * 2);
        FeatureMap goldMap = new FeatureMap();
        HashSet<Feature> seenFeats = new HashSet<Feature>();
        while ((block = eventFile.nextBlock()) != null) {
            Feature feat;
            goldMap.clear();
            seenFeats.clear();
            for (EventFile.Event event : block.events) {
                if (event.count <= 0) continue;
                goldMap.add(event.features);
            }
            for (EventFile.Event event : block.events) {
                if (event.count > 0) continue;
                FeatureVector.Iterator iterator = event.features.iterator();
                while (iterator.hasNext()) {
                    feat = iterator.nextFeature();
                    float val = iterator.nextValue().floatValue();
                    seenFeats.add(feat);
                    float goldVal = goldMap.get(feat);
                    if (val == goldVal) continue;
                    Integer tally = (Integer)freqTally.get(feat);
                    if (tally != null) {
                        tally = tally + 1;
                        freqTally.put(feat, tally);
                        continue;
                    }
                    freqTally.put(feat, 1);
                }
            }
            for (EventFile.Event event : block.events) {
                if (event.count == 0) continue;
                FeatureVector.Iterator iterator = event.features.iterator();
                while (iterator.hasNext()) {
                    feat = iterator.nextFeature();
                    if (seenFeats.contains(feat)) continue;
                    Integer tally = (Integer)freqTally.get(feat);
                    if (tally != null) {
                        tally = tally + 1;
                        freqTally.put(feat, tally);
                        continue;
                    }
                    freqTally.put(feat, 1);
                }
            }
        }
        ArrayList tallies = new ArrayList(freqTally.size());
        if (pruningthreshold > 0) {
            for (Map.Entry entry : freqTally.entrySet()) {
                if ((Integer)entry.getValue() < pruningthreshold) continue;
                tallies.add(entry);
            }
        } else {
            tallies.addAll(freqTally.entrySet());
        }
        Collections.sort(tallies, new Comparator<Map.Entry<Feature, Integer>>(){

            @Override
            public int compare(Map.Entry<Feature, Integer> entry1, Map.Entry<Feature, Integer> entry2) {
                int val2;
                int val1 = entry1.getValue();
                if (val1 > (val2 = entry2.getValue().intValue())) {
                    return -1;
                }
                if (val1 < val2) {
                    return 1;
                }
                return 0;
            }
        });
        int n = tallies.size();
        out.println(Integer.toString(n));
        boolean bl = false;
        while (var12_24 < n) {
            Map.Entry entry = (Map.Entry)tallies.get((int)var12_24);
            out.println(((Feature)entry.getKey()).name() + " " + entry.getValue());
            ++var12_24;
        }
        eventFile.close();
        out.close();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: java perceptron.Alphabet <eventfile> <alphabetfile> (-s <tablesize>) (-p <pruningthreshold>");
            System.exit(0);
        }
        String eventfile = args[0];
        String alphabetfile = args[1];
        int tablesize = 1000000;
        int pruningthreshold = 0;
        for (int i = 2; i < args.length; ++i) {
            if (args[i].equals("-s")) {
                tablesize = Integer.valueOf(args[++i]);
            }
            if (!args[i].equals("-p")) continue;
            pruningthreshold = Integer.valueOf(args[++i]);
        }
        System.out.println("Writing alphabet to " + alphabetfile + " from event file " + eventfile);
        if (pruningthreshold > 0) {
            System.out.println("with pruning threshold " + pruningthreshold);
        }
        Alphabet.createAlphabet(eventfile, alphabetfile, tablesize, pruningthreshold);
    }

    public static class Feature
    extends TrieMap<String, Integer> {
        public Feature(Integer index) {
            super(index);
        }

        protected Feature createNode() {
            return new Feature(null);
        }

        public String name() {
            StringBuffer namebuf = new StringBuffer();
            List keys = this.traceKeys();
            for (int i = 0; i < keys.size(); ++i) {
                namebuf.append(DefaultTokenizer.escape((String)keys.get(i)));
                if (i + 1 >= keys.size()) continue;
                namebuf.append(':');
            }
            return namebuf.toString();
        }

        public Integer getIndex() {
            return (Integer)this.data;
        }
    }
}

