/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.tagger.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigFileProcessor {
    public static Map<String, String> readInConfig(String configFile) {
        return ConfigFileProcessor.readInConfig(configFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readInConfig(String configFile, String[] pathKeys) {
        Set paths = Collections.emptySet();
        if (pathKeys != null) {
            paths = new HashSet<String>(Arrays.asList(pathKeys));
        }
        BufferedReader cf = null;
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            File infile = new File(configFile);
            File parentDir = infile.getParentFile();
            cf = new BufferedReader(new FileReader(infile));
            String ln = cf.readLine();
            while (ln != null) {
                if (ln.trim().equals("") || ln.trim().startsWith("#")) {
                    ln = cf.readLine();
                    continue;
                }
                String[] parts = ln.trim().split("=");
                String key = parts[0].trim().toLowerCase();
                String val = parts[1].trim();
                if (paths.contains(key)) {
                    File f = new File(parentDir, val);
                    if (!f.exists() && !(f = new File(val)).exists()) {
                        throw new FileNotFoundException("Can't resolve filename: " + val);
                    }
                    val = f.getPath();
                }
                opts.put(key, val);
                ln = cf.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ConfigFileProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ConfigFileProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                cf.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ConfigFileProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return opts;
    }
}

