/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.tagger.sequencescoring;

import java.util.ArrayList;
import java.util.List;

public class Trellis<A> {
    private int cols;
    private int rows;
    private ArrayList<ArrayList<A>> trellis;

    public Trellis(List<List<A>> inpt) {
        this.reshape(inpt.size(), inpt.get(0).size(), inpt);
    }

    public Trellis(int cols, int rows, A dummy) {
        ArrayList<List<A>> tr = new ArrayList<List<A>>(cols);
        for (int i = 0; i < cols; ++i) {
            ArrayList<A> tmp = new ArrayList<A>(rows);
            for (int j = 0; j < rows; ++j) {
                tmp.add(dummy);
            }
            tr.add(tmp);
        }
        this.reshape(cols, rows, tr);
    }

    public void reshape(int cols, int rows, List<List<A>> inpt) {
        this.cols = cols;
        this.rows = rows;
        this.trellis = new ArrayList(cols);
        for (List<A> la : inpt) {
            ArrayList<A> row = new ArrayList<A>(rows);
            for (A a : la) {
                row.add(a);
            }
            this.trellis.add(row);
        }
    }

    public int getWidth() {
        return this.rows;
    }

    public int getLength() {
        return this.cols;
    }

    public void clear() {
        for (int i = 0; i < this.cols; ++i) {
            this.trellis.add(new ArrayList(this.rows));
        }
    }

    public ArrayList<A> getOptions(int i) {
        return this.trellis.get(i);
    }

    public A getCoord(int i, int j) {
        try {
            return this.trellis.get(i).get(j);
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    public void setCoord(int i, int j, A val) {
        this.trellis.get(i).set(j, val);
    }
}

