/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.postagger.ml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.postagger.ml.POSPriorModel;
import opennlp.ccg.parse.supertagger.ml.FeatureExtractor;
import opennlp.ccg.parse.tagger.Constants;
import opennlp.ccg.parse.tagger.TaggedWord;
import opennlp.ccg.parse.tagger.io.SRILMFactoredBundleCorpusIterator;
import opennlp.ccg.util.Pair;

public class POSTagFex
implements FeatureExtractor {
    private POSPriorModel posPrior = null;
    public static final String curL = "X";
    public static final String prevL = "X-1";
    public static final String prevPrevL = "X-2";
    public static final String nextL = "X+1";
    public static final String nextNextL = "X+2";
    private static final String[] lxfLabs = new String[]{"X-2", "X-1", "X", "X+1", "X+2"};
    private static final String prefix = "prefix";
    private static final String suffix = "suffix";
    private static final String hyphen = "containsHyphen";
    private static final String caps = "containsUC";
    private static final String num = "containsNum";
    private static final String neConn = "containsNEConnector";
    private static final String priorF = "PPOS";
    private String neConnecter = "_";

    public POSTagFex(POSPriorModel posPrior) {
        this.posPrior = posPrior;
    }

    public POSTagFex() {
        this(null);
    }

    @Override
    public Collection<Pair<String, Double>> getFeatures(Map<Integer, TaggedWord> sentence, Integer wordIndex) {
        return this.getFeatures(sentence, wordIndex, false);
    }

    @Override
    public List<Collection<Pair<String, Double>>> getSentenceFeatures(Map<Integer, TaggedWord> sentence) {
        return this.getSentenceFeatures(sentence, false);
    }

    @Override
    public Collection<Pair<String, Double>> getFeatures(Map<Integer, TaggedWord> sentence, Integer wordIndex, boolean training) {
        TaggedWord nextNext;
        TaggedWord next;
        TaggedWord prevPrev;
        TaggedWord prev;
        ArrayList<Pair<String, Double>> result = new ArrayList<Pair<String, Double>>(30);
        TaggedWord current = sentence.get(wordIndex);
        int wind = wordIndex;
        if (wind > 1) {
            prev = sentence.get(wind - 1);
            prevPrev = sentence.get(wind - 2);
        } else if (wind > 0) {
            prev = sentence.get(wind - 1);
            prevPrev = Constants.OOB;
        } else {
            prev = prevPrev = Constants.OOB;
        }
        int tempSize = sentence.size();
        if (tempSize - (wind + 1) >= 2) {
            next = sentence.get(wind + 1);
            nextNext = sentence.get(wind + 2);
        } else if (tempSize - (wind + 1) >= 1) {
            next = sentence.get(wind + 1);
            nextNext = Constants.OOB;
        } else {
            next = nextNext = Constants.OOB;
        }
        Double activation = Constants.one;
        if (training) {
            result.add(new Pair<String, Double>(current.getPOS(), activation));
        }
        result.add(new Pair<String, Double>("X=" + current.getForm(), activation));
        result.add(new Pair<String, Double>("X-1=" + prev.getForm(), activation));
        result.add(new Pair<String, Double>("X-2=" + prevPrev.getForm(), activation));
        result.add(new Pair<String, Double>("X+1=" + next.getForm(), activation));
        result.add(new Pair<String, Double>("X+2=" + nextNext.getForm(), activation));
        if (this.posPrior != null) {
            List<Pair<Double, String>> priors = this.posPrior.getPriors(current.getWord());
            double beta = 0.1;
            double best = (Double)priors.get((int)0).a;
            String wform = current.getForm();
            for (Pair<Double, String> prior : priors) {
                if (!((Double)prior.a > beta * best)) break;
                result.add(new Pair("PPOS=" + (String)prior.b, prior.a));
                result.add(new Pair("PPOS_word=" + (String)prior.b + "_" + wform, prior.a));
            }
        }
        TaggedWord[] wds = new TaggedWord[]{prevPrev, prev, current, next, nextNext};
        for (int j = 1; j < wds.length; ++j) {
            result.add(new Pair<String, Double>(lxfLabs[j - 1] + "|" + lxfLabs[j] + "=" + wds[j - 1].getForm() + "|" + wds[j].getForm(), activation));
            if (j != 2) continue;
            result.add(new Pair<String, Double>(lxfLabs[j - 1] + "|" + lxfLabs[j + 1] + "=" + wds[j - 1].getForm() + "|" + wds[j + 1].getForm(), activation));
        }
        if (current.getForm().length() > 4) {
            StringBuffer prefixes = new StringBuffer(4);
            StringBuffer suffixes = new StringBuffer(4);
            char[] wdForm = current.getForm().toCharArray();
            int cursor = 0;
            for (cursor = 0; cursor < 4; ++cursor) {
                prefixes.append(wdForm[cursor]);
                result.add(new Pair<String, Double>("prefix=" + prefixes.toString(), Constants.one));
            }
            for (cursor = wdForm.length - 1; cursor >= wdForm.length - 5; --cursor) {
                suffixes.insert(0, wdForm[cursor]);
                result.add(new Pair<String, Double>("suffix=" + suffixes.toString(), Constants.one));
            }
        }
        if (current.getForm().contains("-")) {
            result.add(new Pair<String, Double>(hyphen, Constants.one));
        }
        if (current.getForm().matches(".*[0-9]+.*")) {
            result.add(new Pair<String, Double>(num, Constants.one));
        }
        if (!current.getForm().toLowerCase().equals(current.getForm())) {
            result.add(new Pair<String, Double>(caps, Constants.one));
        }
        if (current.getForm().contains(this.neConnecter)) {
            result.add(new Pair<String, Double>(neConn, Constants.one));
        }
        return result;
    }

    @Override
    public List<Collection<Pair<String, Double>>> getSentenceFeatures(Map<Integer, TaggedWord> sentence, boolean training) {
        ArrayList<Collection<Pair<String, Double>>> result = new ArrayList<Collection<Pair<String, Double>>>(30);
        ArrayList<Integer> keys = new ArrayList<Integer>(sentence.keySet().size());
        for (Integer wordIndex : sentence.keySet()) {
            keys.add(wordIndex);
        }
        Collections.sort(keys);
        for (Integer wordIndex : keys) {
            result.add(this.getFeatures(sentence, wordIndex, training));
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        String usage = "POSTagFex (-h [gets this message]) (-i <input> [defaults to <stdin>]) (-o <output> [defaults to <stdout>])\n          (-p <posPriorModel> [.flm] -v <priorModVocab>)\n";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String input = "<stdin>";
        String output = "<stdout>";
        String priorModF = null;
        String priorVocab = null;
        for (int j = 0; j < args.length; ++j) {
            if (args[j].equals("-i")) {
                input = args[++j];
                continue;
            }
            if (args[j].equals("-o")) {
                output = args[++j];
                continue;
            }
            if (args[j].equals("-p")) {
                priorModF = args[++j];
                continue;
            }
            if (args[j].equals("-v")) {
                priorVocab = args[++j];
                continue;
            }
            System.err.println("Unrecognized option: " + args[j]);
        }
        SRILMFactoredBundleCorpusIterator corp = new SRILMFactoredBundleCorpusIterator(input.equals("<stdin>") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(input))));
        BufferedWriter out = new BufferedWriter(output.equals("<stdout>") ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(new File(output))));
        POSPriorModel posPriorMod = null;
        if (priorModF != null) {
            posPriorMod = new POSPriorModel(priorModF, priorVocab);
        }
        POSTagFex fexer = new POSTagFex(posPriorMod);
        for (List<Word> sentence : corp) {
            HashMap<Integer, TaggedWord> sent = new HashMap<Integer, TaggedWord>(sentence.size());
            int index = 0;
            for (Word w : sentence) {
                sent.put(index++, new TaggedWord(w));
            }
            List<Collection<Pair<String, Double>>> ftss = fexer.getSentenceFeatures(sent, true);
            for (Collection<Pair<String, Double>> fts : ftss) {
                index = 0;
                for (Pair<String, Double> ft : fts) {
                    if (index == 0) {
                        out.write((String)ft.a);
                    } else {
                        out.write(" " + (String)ft.a + ":" + ft.b);
                    }
                    ++index;
                }
                out.write(System.getProperty("line.separator"));
            }
        }
        out.flush();
    }
}

