/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.postagger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.postagger.BasicPOSTagger;
import opennlp.ccg.parse.postagger.DummyPOSTagger;
import opennlp.ccg.parse.postagger.ml.POSPriorModel;
import opennlp.ccg.parse.postagger.ml.POSTagFex;
import opennlp.ccg.parse.tagger.Constants;
import opennlp.ccg.parse.tagger.TaggedWord;
import opennlp.ccg.parse.tagger.ml.ZLMEM;
import opennlp.ccg.parse.tagger.sequencescoring.SequenceScorer;
import opennlp.ccg.parse.tagger.util.ConfigFileProcessor;
import opennlp.ccg.util.Pair;

public abstract class POSTagger {
    protected SequenceScorer posSeqMod = null;
    public Constants.TaggingAlgorithm alg = Constants.TaggingAlgorithm.FORWARDBACKWARD;
    public double beta = 1.0;
    protected boolean includeGold = false;

    public abstract List<TaggedWord> tagSentence(List<Word> var1);

    public void setTaggingAlgorithm(Constants.TaggingAlgorithm newAlg) {
        this.alg = newAlg;
        this.posSeqMod.setAlgorithm(this.alg);
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void setIncludeGold(boolean includeGoldOrNot) {
        this.includeGold = includeGoldOrNot;
    }

    public List<TaggedWord> betaBestFilter(List<TaggedWord> sentence) {
        ArrayList<TaggedWord> res = new ArrayList<TaggedWord>(sentence.size());
        for (TaggedWord tw : sentence) {
            Word w = tw.getWord();
            double best = (Double)tw.getPOSTagging().get((int)0).a;
            int endIndex = 0;
            for (Pair<Double, String> pair : tw.getPOSTagging()) {
                if (!((Double)pair.a >= this.beta * best)) break;
                ++endIndex;
            }
            ArrayList<Pair<Double, String>> tmpTagging = new ArrayList<Pair<Double, String>>(tw.getPOSTagging().size());
            for (Pair<Double, String> pair : tw.getPOSTagging()) {
                tmpTagging.add(pair);
            }
            tmpTagging.subList(endIndex, tmpTagging.size()).clear();
            TaggedWord taggedWord = new TaggedWord(w);
            taggedWord.setPOSTagging(tmpTagging);
            res.add(taggedWord);
        }
        return res;
    }

    public static POSTagger posTaggerFactory(String configFile) {
        BasicPOSTagger res = null;
        try {
            String[] pathKeys = new String[]{"maxentmodel", "priormodel", "priormodelvocab", "sequencemodel"};
            Map<String, String> opts = ConfigFileProcessor.readInConfig(configFile, pathKeys);
            if (opts.get("taggertype").equalsIgnoreCase("dummy")) {
                return new DummyPOSTagger();
            }
            ZLMEM mem = new ZLMEM(new File(opts.get("maxentmodel")));
            POSPriorModel posPrior = null;
            if (opts.get("priormodel") != null) {
                posPrior = new POSPriorModel(opts.get("priormodel"), opts.get("priormodelvocab"));
            }
            POSTagFex fexer = new POSTagFex(posPrior);
            res = new BasicPOSTagger(mem, fexer, opts.get("sequencemodel"));
            res.setBeta(Double.parseDouble(opts.get("beta")));
            Constants.TaggingAlgorithm alg = opts.get("taggingalgorithm") == null || opts.get("taggingalgorithm").equals("forward-backward") ? Constants.TaggingAlgorithm.FORWARDBACKWARD : Constants.TaggingAlgorithm.FORWARD;
            res.setTaggingAlgorithm(alg);
            res.setIncludeGold(opts.get("includegold") != null && !opts.get("includegold").equals("false"));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(POSTagger.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(POSTagger.class.getName()).log(Level.SEVERE, null, ex);
        }
        return res;
    }
}

