/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.postagger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.postagger.POSTagger;
import opennlp.ccg.parse.postagger.ml.POSPriorModel;
import opennlp.ccg.parse.supertagger.ml.FeatureExtractor;
import opennlp.ccg.parse.tagger.Constants;
import opennlp.ccg.parse.tagger.TaggedWord;
import opennlp.ccg.parse.tagger.io.SRILMFactoredBundleCorpusIterator;
import opennlp.ccg.parse.tagger.ml.MaxentModel;
import opennlp.ccg.parse.tagger.sequencescoring.SequenceScorer;
import opennlp.ccg.parse.tagger.util.ResultSink;
import opennlp.ccg.util.Pair;

public class BasicPOSTagger
extends POSTagger {
    private FeatureExtractor posFex = null;
    private MaxentModel tagMod = null;
    private static final Comparator<Pair<Double, Integer>> comp = new Comparator<Pair<Double, Integer>>(){

        @Override
        public int compare(Pair<Double, Integer> pr0, Pair<Double, Integer> pr1) {
            if (pr0.a == pr1.a) {
                return 0;
            }
            if ((Double)pr0.a < (Double)pr1.a) {
                return 1;
            }
            return -1;
        }
    };

    public BasicPOSTagger(MaxentModel tagMod, FeatureExtractor posFex, String tagSequenceModel) {
        this.posFex = posFex;
        this.tagMod = tagMod;
        int ord = SequenceScorer.findOrder(tagSequenceModel);
        try {
            this.posSeqMod = new SequenceScorer(ord, tagSequenceModel);
            this.posSeqMod.setAlgorithm(Constants.TaggingAlgorithm.FORWARDBACKWARD);
            this.posSeqMod.setSearchBeam(5);
        }
        catch (IOException ex) {
            Logger.getLogger(BasicPOSTagger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<TaggedWord> tagSentence(List<Word> sentence) {
        ArrayList<TaggedWord> result = new ArrayList<TaggedWord>(sentence.size());
        List<List<Pair<Double, String>>> taggings = new ArrayList<List<Pair<Double, String>>>(sentence.size());
        HashMap<Integer, TaggedWord> sentMap = new HashMap<Integer, TaggedWord>(sentence.size());
        int ind = 0;
        for (Word w : sentence) {
            sentMap.put(ind++, new TaggedWord(w));
        }
        List<Collection<Pair<String, Double>>> ftss = this.posFex.getSentenceFeatures(sentMap);
        double[] distro = null;
        int wordIndex = 0;
        for (Collection<Pair<String, Double>> fts : ftss) {
            distro = this.tagMod.eval(fts);
            ArrayList<Pair<Double, Integer>> distroList = new ArrayList<Pair<Double, Integer>>(distro.length);
            ind = 0;
            for (double prob : distro) {
                distroList.add(new Pair<Double, Integer>(prob, ind++));
            }
            Collections.sort(distroList, comp);
            ArrayList tagging = new ArrayList(distro.length);
            double best = (Double)((Pair)distroList.get((int)0)).a;
            double widenedBeta = this.beta / 8.0;
            String goldPOS = sentence.get(wordIndex).getPOS();
            for (Pair pair : distroList) {
                if ((Double)pair.a >= widenedBeta * best || this.includeGold && this.tagMod.getOutcome((Integer)pair.b).equals(goldPOS)) {
                    tagging.add(new Pair(pair.a, this.tagMod.getOutcome((Integer)pair.b)));
                    continue;
                }
                if (this.includeGold) continue;
                break;
            }
            taggings.add(tagging);
            ++wordIndex;
        }
        taggings = this.posSeqMod.rescoreSequence(taggings);
        int wInd = 0;
        for (List<Pair<Double, String>> tagging : taggings) {
            TaggedWord tmpWd = new TaggedWord(sentence.get(wInd++));
            tmpWd.setPOSTagging(tagging);
            result.add(tmpWd);
        }
        return this.betaBestFilter(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String usage = "\nBasicPOSTagger -c <configFile> (-i <input> [defaults to <stdin>]) (-o <output> [defaults to <stdout>])\n                 (-e [test tagger; assumes input is gold-standard corpus])\n";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        SRILMFactoredBundleCorpusIterator inp = null;
        BufferedWriter out = null;
        try {
            String inputCorp = "<stdin>";
            String output = "<stdout>";
            String configFile = null;
            boolean test = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-i")) {
                    inputCorp = args[++i];
                    continue;
                }
                if (args[i].equals("-o")) {
                    output = args[++i];
                    continue;
                }
                if (args[i].equals("-e")) {
                    test = true;
                    continue;
                }
                if (args[i].equals("-c")) {
                    configFile = args[++i];
                    continue;
                }
                System.out.println("Unrecognized option: " + args[i]);
            }
            ResultSink rs = new ResultSink(ResultSink.ResultSinkType.POSTAG);
            try {
                inp = new SRILMFactoredBundleCorpusIterator(inputCorp.equals("<stdin>") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(new File(inputCorp))));
            }
            catch (FileNotFoundException ex) {
                System.err.print("Input corpus " + inputCorp + " not found.  Exiting...");
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            try {
                out = output.equals("<stdout>") ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(new File(output)));
            }
            catch (IOException ex) {
                System.err.print("Output file " + output + " not found.  Exiting...");
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            POSTagger post = POSTagger.posTaggerFactory(configFile);
            for (List<Word> inLine : inp) {
                List<TaggedWord> taggedSent = post.tagSentence(inLine);
                ArrayList<List<Pair<Double, String>>> sentTagging = new ArrayList<List<Pair<Double, String>>>(taggedSent.size());
                for (TaggedWord tw : taggedSent) {
                    sentTagging.add(tw.getPOSTagging());
                }
                if (test) {
                    rs.addSent(sentTagging, inLine);
                }
                out.write("<s>" + System.getProperty("line.separator"));
                for (TaggedWord tw : taggedSent) {
                    out.write(tw.getForm());
                    for (Pair<Double, String> tg : tw.getPOSTagging()) {
                        out.write("\t" + (String)tg.b + "\t" + tg.a);
                    }
                    out.write(System.getProperty("line.separator"));
                }
                out.write("</s>" + System.getProperty("line.separator"));
            }
            out.flush();
            if (test) {
                System.err.println(rs.report());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                inp.close();
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

