/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.util.Pair;

abstract class AbstractStandardNgramModel
extends NgramScorer {
    protected List<String> stringsToScore = new ArrayList<String>();

    protected AbstractStandardNgramModel(int order, boolean useSemClasses) {
        super(order, useSemClasses);
        this.numNgrams = new int[order];
    }

    protected AbstractStandardNgramModel(int order) {
        this(order, false);
    }

    @Override
    protected void prepareToScoreWords() {
        this.stringsToScore.clear();
        for (int i = 0; i < this.wordsToScore.size(); ++i) {
            Word w = (Word)this.wordsToScore.get(i);
            String s = w.getForm();
            String scr = this.semClassReplacement(w);
            if (scr != null) {
                s = scr;
            }
            String pitchAccent = w.getPitchAccent();
            Iterator<Pair<String, String>> pairs = w.getAttrValPairs();
            if (pitchAccent != null || pairs.hasNext()) {
                StringBuffer sb = new StringBuffer();
                sb.append(s);
                if (pitchAccent != null) {
                    sb.append('_').append(pitchAccent);
                }
                while (pairs.hasNext()) {
                    Pair<String, String> p = pairs.next();
                    sb.append('_').append((String)p.b);
                }
                s = sb.toString().intern();
            }
            if (this.openVocab && this.trieMapRoot.getChild(s) == null) {
                s = "<unk>";
            }
            this.stringsToScore.add(s);
        }
    }

    @Override
    protected float logProbFromNgram(int i, int order) {
        if (i == 0 && order == 1 && this.stringsToScore.get(0) == "<s>") {
            return 0.0f;
        }
        this.keysList.clear();
        for (int j = i; j < i + order; ++j) {
            this.keysList.add(this.stringsToScore.get(j));
        }
        if (this.debugScore) {
            System.out.print("logp( " + this.keysList.get(order - 1) + " | ");
            if (order > 1) {
                System.out.print(this.keysList.get(order - 2) + " ... ");
            }
            System.out.print(") = ");
        }
        float retval = this.logProb(0, order);
        if (this.debugScore) {
            System.out.println("" + retval);
        }
        return retval;
    }
}

