/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.ccg.lexicon.FullWord;
import opennlp.ccg.util.Pair;

public abstract class Word
implements Serializable,
Comparable<Word> {
    private static final long serialVersionUID = 1L;
    private static Iterator<Pair<String, String>> emptyIterator = new ArrayList(0).iterator();
    private static Set<String> knownAttrs = Word.initKnownAttrs();
    protected static WordFactory wordFactory = new FullWord.Factory();
    private static Comparator<Pair<String, String>> attrValComparator = new Comparator<Pair<String, String>>(){

        @Override
        public int compare(Pair<String, String> p1, Pair<String, String> p2) {
            return ((String)p1.a).compareTo((String)p2.a);
        }
    };

    public abstract String getForm();

    public abstract String getPitchAccent();

    public Iterator<Pair<String, String>> getAttrValPairs() {
        List<Pair<String, String>> pairs = this.getAttrValPairsList();
        return pairs != null ? pairs.iterator() : emptyIterator;
    }

    public Iterator<Pair<String, String>> getSurfaceAttrValPairs() {
        List<Pair<String, String>> pairs = this.getAttrValPairsList();
        String pitchAccent = this.getPitchAccent();
        if (pairs == null && pitchAccent == null) {
            return emptyIterator;
        }
        if (pairs == null) {
            ArrayList<Pair<String, String>> retval = new ArrayList<Pair<String, String>>(1);
            retval.add(new Pair<String, String>("A", pitchAccent));
            return retval.iterator();
        }
        if (pitchAccent == null) {
            return pairs.iterator();
        }
        ArrayList<Pair<String, String>> retval = new ArrayList<Pair<String, String>>(pairs);
        retval.add(new Pair<String, String>("A", pitchAccent));
        return retval.iterator();
    }

    protected abstract List<Pair<String, String>> getAttrValPairsList();

    public abstract String getStem();

    public abstract String getPOS();

    public abstract String getSupertag();

    public abstract String getSemClass();

    public abstract String getVal(String var1);

    private static Set<String> initKnownAttrs() {
        THashSet knownAttrs = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
        String[] names = new String[]{"W", "A", "S", "P", "T", "C"};
        for (int i = 0; i < names.length; ++i) {
            knownAttrs.add(names[i]);
        }
        return knownAttrs;
    }

    public static boolean isKnownAttr(String attr) {
        return knownAttrs.contains(attr.intern());
    }

    public boolean isSurfaceWord() {
        return this.getForm() != null && this.getStem() == null && this.getPOS() == null && this.getSupertag() == null && this.getSemClass() == null;
    }

    public static synchronized Word createWord(String form) {
        form = form != null ? form.intern() : null;
        return wordFactory.create(form);
    }

    public static synchronized Word createWord(String form, String pitchAccent, List<Pair<String, String>> attrValPairs, String stem, String POS, String supertag, String semClass) {
        form = form != null ? form.intern() : null;
        String string = pitchAccent = pitchAccent != null ? pitchAccent.intern() : null;
        if (attrValPairs != null) {
            if (attrValPairs.isEmpty()) {
                attrValPairs = null;
            } else {
                attrValPairs = new ArrayList<Pair<String, String>>(attrValPairs);
                Word.sortAttrValPairs(attrValPairs);
                for (int i = 0; i < attrValPairs.size(); ++i) {
                    Pair<String, String> p = attrValPairs.get(i);
                    String attr = ((String)p.a).intern();
                    String val = p.b != null ? ((String)p.b).intern() : null;
                    attrValPairs.set(i, new Pair<String, String>(attr, val));
                }
            }
        }
        stem = stem != null ? stem.intern() : null;
        POS = POS != null ? POS.intern() : null;
        supertag = supertag != null ? supertag.intern() : null;
        semClass = semClass != null ? semClass.intern() : null;
        return Word.createWordDirectly(form, pitchAccent, attrValPairs, stem, POS, supertag, semClass);
    }

    private static void sortAttrValPairs(List<Pair<String, String>> pairs) {
        Collections.sort(pairs, attrValComparator);
    }

    private static synchronized Word createWordDirectly(String form, String pitchAccent, List<Pair<String, String>> attrValPairs, String stem, String POS, String supertag, String semClass) {
        return wordFactory.create(form, pitchAccent, attrValPairs, stem, POS, supertag, semClass);
    }

    public static synchronized Word createWord(String attr, String val) {
        attr = attr.intern();
        val = val != null ? val.intern() : null;
        return wordFactory.create(attr, val);
    }

    public static synchronized Word createWord(Word word, String form) {
        if (form != null) {
            form = form.intern();
        }
        return Word.createWordDirectly(form, word.getPitchAccent(), word.getAttrValPairsList(), word.getStem(), word.getPOS(), word.getSupertag(), word.getSemClass());
    }

    public static synchronized Word createWordUsingSemClass(Word word) {
        String form;
        String stem = form = word.getSemClass().toUpperCase().intern();
        return Word.createWordDirectly(form, word.getPitchAccent(), word.getAttrValPairsList(), stem, word.getPOS(), word.getSupertag(), word.getSemClass());
    }

    public static synchronized Word createWordWithAttrs(Word word, Word word2) {
        String accent = word.getPitchAccent();
        if (accent == null) {
            accent = word2.getPitchAccent();
        }
        boolean mixedAttrs = false;
        List<Pair<String, String>> pairs = word.getAttrValPairsList();
        List<Pair<String, String>> pairs2 = word2.getAttrValPairsList();
        if (pairs == null && pairs2 != null) {
            pairs = pairs2;
        } else if (pairs2 != null) {
            mixedAttrs = true;
            pairs = new ArrayList<Pair<String, String>>(pairs);
            for (int i = 0; i < pairs2.size(); ++i) {
                if (pairs.contains(pairs2.get(i))) continue;
                pairs.add(pairs2.get(i));
            }
        }
        String form = word.getForm();
        String stem = word.getStem();
        String POS = word.getPOS();
        String supertag = word.getSupertag();
        String semClass = word.getSemClass();
        if (mixedAttrs) {
            return Word.createWord(form, accent, pairs, stem, POS, supertag, semClass);
        }
        return Word.createWordDirectly(form, accent, pairs, stem, POS, supertag, semClass);
    }

    public static synchronized Word createFullWord(Word word, String stem, String POS, String supertag, String semClass) {
        stem = stem != null ? stem.intern() : null;
        POS = POS != null ? POS.intern() : null;
        supertag = supertag != null ? supertag.intern() : null;
        semClass = semClass != null ? semClass.intern() : null;
        return Word.createWordDirectly(word.getForm(), word.getPitchAccent(), word.getAttrValPairsList(), stem, POS, supertag, semClass);
    }

    public static synchronized Word createFullWord(Word word, Word word2, String supertag) {
        boolean mixedAttrs = false;
        List<Pair<String, String>> pairs = word.getAttrValPairsList();
        List<Pair<String, String>> pairs2 = word2.getAttrValPairsList();
        if (pairs == null && pairs2 != null) {
            pairs = pairs2;
        } else if (pairs2 != null) {
            mixedAttrs = true;
            pairs = new ArrayList<Pair<String, String>>(pairs);
            for (int i = 0; i < pairs2.size(); ++i) {
                if (pairs.contains(pairs2.get(i))) continue;
                pairs.add(pairs2.get(i));
            }
        }
        if (mixedAttrs) {
            return Word.createWord(word.getForm(), word.getPitchAccent(), pairs, word2.getStem(), word2.getPOS(), supertag, word2.getSemClass());
        }
        supertag = supertag != null ? supertag.intern() : null;
        return Word.createWordDirectly(word.getForm(), word.getPitchAccent(), pairs, word2.getStem(), word2.getPOS(), supertag, word2.getSemClass());
    }

    public static synchronized Word createSurfaceWord(Word word) {
        return Word.createWordDirectly(word.getForm(), word.getPitchAccent(), word.getAttrValPairsList(), null, null, null, null);
    }

    public static synchronized Word createSurfaceWord(Word word, String form) {
        form = form != null ? form.intern() : null;
        return Word.createWordDirectly(form, word.getPitchAccent(), word.getAttrValPairsList(), null, null, null, null);
    }

    public static synchronized Word createSurfaceWordUsingSemClass(Word word) {
        String form = word.getSemClass().toUpperCase().intern();
        return Word.createWordDirectly(form, word.getPitchAccent(), word.getAttrValPairsList(), null, null, null, null);
    }

    public static synchronized Word createCoreSurfaceWord(Word word, Set<String> attrsSet) {
        List<Pair<String, String>> pairs;
        String form = word.getForm();
        String accent = word.getPitchAccent();
        if (accent != null && attrsSet.contains("A")) {
            accent = null;
        }
        if ((pairs = word.getAttrValPairsList()) != null) {
            pairs = new ArrayList<Pair<String, String>>(pairs);
            Iterator<Pair<String, String>> pairsIt = pairs.iterator();
            while (pairsIt.hasNext()) {
                Pair<String, String> pair = pairsIt.next();
                if (!attrsSet.contains(pair.a)) continue;
                pairsIt.remove();
            }
            return Word.createWord(form, accent, pairs, null, null, null, null);
        }
        return Word.createWordDirectly(form, accent, null, null, null, null, null);
    }

    public int hashCode() {
        int hc = System.identityHashCode(this.getForm());
        hc = 31 * hc + System.identityHashCode(this.getPitchAccent());
        Iterator<Pair<String, String>> it = this.getAttrValPairs();
        while (it.hasNext()) {
            Pair<String, String> p = it.next();
            hc = 31 * hc + System.identityHashCode(p.a);
            hc = 31 * hc + System.identityHashCode(p.b);
        }
        hc = 31 * hc + System.identityHashCode(this.getStem());
        hc = 31 * hc + System.identityHashCode(this.getPOS());
        hc = 31 * hc + System.identityHashCode(this.getSupertag());
        hc = 31 * hc + System.identityHashCode(this.getSemClass());
        return hc;
    }

    public boolean equals(Object obj) {
        boolean sameFields;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Word)) {
            return false;
        }
        Word word = (Word)obj;
        boolean bl = sameFields = this.getForm() == word.getForm() && this.getPitchAccent() == word.getPitchAccent() && this.getStem() == word.getStem() && this.getPOS() == word.getPOS() && this.getSupertag() == word.getSupertag() && this.getSemClass() == word.getSemClass();
        if (!sameFields) {
            return false;
        }
        List<Pair<String, String>> pairs = this.getAttrValPairsList();
        List<Pair<String, String>> wordPairs = word.getAttrValPairsList();
        if (pairs == null && wordPairs == null) {
            return true;
        }
        if (pairs == null || wordPairs == null) {
            return false;
        }
        if (pairs.size() != wordPairs.size()) {
            return false;
        }
        for (int i = 0; i < pairs.size(); ++i) {
            if (pairs.get(i).equals(wordPairs.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Word word) {
        if (this == word) {
            return 0;
        }
        int cmp = 0;
        cmp = this.compare(this.getForm(), word.getForm());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare(this.getPitchAccent(), word.getPitchAccent());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare(this.getStem(), word.getStem());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare(this.getPOS(), word.getPOS());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare(this.getSupertag(), word.getSupertag());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare(this.getSemClass(), word.getSemClass());
        if (cmp != 0) {
            return cmp;
        }
        List<Pair<String, String>> pairs = this.getAttrValPairsList();
        List<Pair<String, String>> wordPairs = word.getAttrValPairsList();
        if (pairs == null && wordPairs == null) {
            return 0;
        }
        if (pairs == null) {
            return -1;
        }
        if (wordPairs == null) {
            return 1;
        }
        if (pairs.size() < wordPairs.size()) {
            return -1;
        }
        if (pairs.size() > wordPairs.size()) {
            return 1;
        }
        for (int i = 0; i < pairs.size(); ++i) {
            Pair<String, String> p = pairs.get(i);
            Pair<String, String> wp = wordPairs.get(i);
            cmp = ((String)p.a).compareTo((String)wp.a);
            if (cmp != 0) {
                return cmp;
            }
            cmp = ((String)p.b).compareTo((String)wp.b);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public boolean attrsIntersect(Set<String> attrsSet) {
        if (this.getPitchAccent() != null && attrsSet.contains("A")) {
            return true;
        }
        Iterator<Pair<String, String>> it = this.getAttrValPairs();
        while (it.hasNext()) {
            Pair<String, String> p = it.next();
            if (!attrsSet.contains(p.a)) continue;
            return true;
        }
        return false;
    }

    public int surfaceWordHashCode() {
        int hc = System.identityHashCode(this.getForm());
        hc = 31 * hc + System.identityHashCode(this.getPitchAccent());
        Iterator<Pair<String, String>> it = this.getAttrValPairs();
        while (it.hasNext()) {
            Pair<String, String> p = it.next();
            hc = 31 * hc + System.identityHashCode(p.a);
            hc = 31 * hc + System.identityHashCode(p.b);
        }
        return hc;
    }

    public boolean surfaceWordEquals(Object obj) {
        boolean sameFields;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Word)) {
            return false;
        }
        Word word = (Word)obj;
        boolean bl = sameFields = this.getForm() == word.getForm() && this.getPitchAccent() == word.getPitchAccent();
        if (!sameFields) {
            return false;
        }
        List<Pair<String, String>> pairs = this.getAttrValPairsList();
        List<Pair<String, String>> wordPairs = word.getAttrValPairsList();
        if (pairs == null && wordPairs == null) {
            return true;
        }
        if (pairs == null || wordPairs == null) {
            return false;
        }
        if (pairs.size() != wordPairs.size()) {
            return false;
        }
        for (int i = 0; i < pairs.size(); ++i) {
            if (pairs.get(i).equals(wordPairs.get(i))) continue;
            return false;
        }
        return true;
    }

    public Object readResolve() throws ObjectStreamException {
        return Word.createWord(this.getForm(), this.getPitchAccent(), this.getAttrValPairsList(), this.getStem(), this.getPOS(), this.getSupertag(), this.getSemClass());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getForm() != null) {
            sb.append(this.getForm());
        }
        if (this.getPitchAccent() != null) {
            sb.append('_').append(this.getPitchAccent());
        }
        Iterator<Pair<String, String>> it = this.getAttrValPairs();
        while (it.hasNext()) {
            Pair<String, String> p = it.next();
            sb.append('_').append((String)p.b);
        }
        if (this.getStem() != null && this.getStem() != this.getForm()) {
            sb.append('_').append(this.getStem());
        }
        if (this.getPOS() != null) {
            sb.append('_').append(this.getPOS());
        }
        if (this.getSupertag() != null) {
            sb.append('_').append(this.getSupertag());
        }
        if (this.getSemClass() != null) {
            sb.append('_').append(this.getSemClass());
        }
        if (sb.length() == 0) {
            sb.append((String)null);
        }
        return sb.toString();
    }

    public static void main(String[] argv) throws IOException, ClassNotFoundException {
        Word w = Word.createWord("ran");
        Word fw = Word.createFullWord(w, "run", "VBD", "s\\np", "MOTION");
        Word wb = Word.createWordWithAttrs(w, Word.createWord("B", "L"));
        String filename = "tmp.ser";
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
        System.out.println("Writing w: " + w);
        out.writeObject(w);
        System.out.println("Writing fw: " + fw);
        out.writeObject(fw);
        System.out.println("Writing wb: " + wb);
        out.writeObject(wb);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        System.out.print("Reading w2: ");
        Word w2 = (Word)in.readObject();
        System.out.println(w2);
        System.out.print("Reading fw2: ");
        Word fw2 = (Word)in.readObject();
        System.out.println(fw2);
        System.out.print("Reading wb2: ");
        Word wb2 = (Word)in.readObject();
        System.out.println(wb2);
        in.close();
        System.out.println("w == w2?: " + (w == w2));
        System.out.println("fw == fw2?: " + (fw == fw2));
        System.out.println("wb == wb2?: " + (wb == wb2));
    }

    public static interface WordFactory {
        public Word create(String var1);

        public Word create(String var1, String var2);

        public Word create(String var1, String var2, List<Pair<String, String>> var3, String var4, String var5, String var6, String var7);
    }
}

