/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.util.Pair;

public class ListPairWord
extends Word {
    private static final long serialVersionUID = 1L;
    protected List<Pair<String, String>> pairsList;

    public ListPairWord(List<Pair<String, String>> pairsList) {
        this.pairsList = pairsList;
    }

    @Override
    public String getForm() {
        return this.getValFromInterned("W");
    }

    @Override
    public String getPitchAccent() {
        return this.getValFromInterned("A");
    }

    @Override
    protected List<Pair<String, String>> getAttrValPairsList() {
        ArrayList<Pair<String, String>> retval = null;
        for (Pair<String, String> pair : this.pairsList) {
            if (ListPairWord.isKnownAttr((String)pair.a)) continue;
            if (retval == null) {
                retval = new ArrayList<Pair<String, String>>(5);
            }
            retval.add(pair);
        }
        return retval;
    }

    @Override
    public String getStem() {
        return this.getValFromInterned("S");
    }

    @Override
    public String getPOS() {
        return this.getValFromInterned("P");
    }

    @Override
    public String getSupertag() {
        return this.getValFromInterned("T");
    }

    @Override
    public String getSemClass() {
        return this.getValFromInterned("C");
    }

    @Override
    public String getVal(String attr) {
        String internedAttr = attr.intern();
        return this.getValFromInterned(internedAttr);
    }

    protected String getValFromInterned(String attr) {
        for (Pair<String, String> pair : this.pairsList) {
            if (pair.a != attr) continue;
            return (String)pair.b;
        }
        return null;
    }
}

