/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import opennlp.ccg.lexicon.Family;
import opennlp.ccg.synsem.CatReader;
import opennlp.ccg.synsem.Category;
import org.jdom.Element;

public class EntriesItem {
    private Family family;
    private Boolean active = Boolean.TRUE;
    private String name;
    private String stem;
    private String indexRel;
    private Category cat;

    public EntriesItem(Element el, Family family) {
        String indexRelVal;
        String isActive;
        this.family = family;
        this.name = el.getAttributeValue("name");
        this.stem = el.getAttributeValue("stem");
        if (this.stem == null) {
            this.stem = "[*DEFAULT*]";
        }
        if ((isActive = el.getAttributeValue("active")) != null && isActive.equals("false")) {
            this.active = Boolean.FALSE;
        }
        this.indexRel = (indexRelVal = el.getAttributeValue("indexRel")) != null ? indexRelVal : family.getIndexRel();
        this.cat = CatReader.getCat((Element)el.getChildren().get(0));
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.getFamilyName() + "." + this.name;
    }

    public String getFamilyName() {
        return this.family.getName();
    }

    public String getSupertag() {
        return this.cat.getSupertag();
    }

    public Family getFamily() {
        return this.family;
    }

    public String getStem() {
        return this.stem;
    }

    public String getIndexRel() {
        return this.indexRel;
    }

    public String getCoartRel() {
        return this.family.getCoartRel();
    }

    public Category getCat() {
        return this.cat;
    }

    public String toString() {
        return this.getQualifiedName() + ":" + this.stem + " :- " + this.cat;
    }
}

