/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.Diamond;
import opennlp.ccg.hylo.HyloFormula;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Content;
import org.jdom.Element;

public class Op
extends HyloFormula {
    private static final long serialVersionUID = -7489598953770901195L;
    public static final String CONJ = "conj";
    public static final String DISJ = "disj";
    public static final String XOR = "xor";
    public static final String NEG = "neg";
    public static final String OPT = "opt";
    protected final String _name;
    protected List<LF> _args;

    public Op(Element e) {
        String name = e.getAttributeValue("name");
        if (name == null) {
            name = e.getAttributeValue("n");
        }
        this._name = name;
        List argElements = e.getChildren();
        int argSize = argElements.size();
        ArrayList<LF> args = new ArrayList<LF>(argSize);
        for (int i = 0; i < argSize; ++i) {
            args.add(HyloHelper.getLF((Element)argElements.get(i)));
        }
        if (args.size() > 1 && (name.equals(NEG) || name.equals(OPT))) {
            this._args = new ArrayList<LF>(1);
            this._args.add(new Op(CONJ, args));
        } else {
            this._args = args;
        }
    }

    public Op(String name, List<LF> args) {
        this._name = name;
        this._args = args;
    }

    public Op(String name, LF first, LF second) {
        this._name = name;
        this._args = new ArrayList<LF>();
        this._args.add(first);
        this._args.add(second);
    }

    public String getName() {
        return this._name;
    }

    public List<LF> getArguments() {
        return this._args;
    }

    public void addArgument(LF formula) {
        this._args.add(formula);
    }

    public void appendArgs(LF lf) {
        if (lf instanceof Op && ((Op)lf).getName().equals(CONJ)) {
            this._args.addAll(((Op)lf).getArguments());
        } else {
            this._args.add(lf);
        }
    }

    @Override
    public LF copy() {
        ArrayList<LF> $args = new ArrayList<LF>(this._args.size());
        for (LF arg : this._args) {
            $args.add(arg.copy());
        }
        return new Op(this._name, $args);
    }

    @Override
    public void deepMap(ModFcn mf) {
        Iterator<LF> argsIt = this._args.iterator();
        while (argsIt.hasNext()) {
            argsIt.next().deepMap(mf);
        }
        mf.modify(this);
    }

    @Override
    public boolean occurs(Variable var) {
        Iterator<LF> argsIt = this._args.iterator();
        while (argsIt.hasNext()) {
            if (!argsIt.next().occurs(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Op)) {
            return false;
        }
        Op op2 = (Op)o;
        if (this._name != op2._name) {
            return false;
        }
        List<LF> opArgs = op2._args;
        if (this._args.size() != opArgs.size()) {
            return false;
        }
        return opArgs.containsAll(this._args);
    }

    @Override
    public void unifyCheck(Object u) throws UnifyFailure {
        throw new UnifyFailure();
    }

    @Override
    public Object unify(Object u, Substitution s) throws UnifyFailure {
        throw new UnifyFailure();
    }

    @Override
    public Object fill(Substitution sub) throws UnifyFailure {
        ArrayList<LF> $args = new ArrayList<LF>(this._args.size());
        for (LF arg : this._args) {
            $args.add((LF)arg.fill(sub));
        }
        return new Op(this._name, $args);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String opString = Op.printOp(this._name);
        if (this._args.size() == 1) {
            sb.append(opString);
            sb.append(this._args.get(0).toString());
        } else {
            sb.append('(');
            Iterator<LF> argsIt = this.filteredArgs().iterator();
            while (argsIt.hasNext()) {
                sb.append(argsIt.next().toString());
                if (!argsIt.hasNext()) continue;
                sb.append(' ').append(opString).append(' ');
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String prettyPrint(String indent) {
        StringBuffer sb = new StringBuffer();
        String opString = Op.printOp(this._name);
        if (this._args.size() == 1) {
            sb.append(opString);
            sb.append(this._args.get(0).prettyPrint(indent));
        } else {
            sb.append('(');
            Iterator<LF> argsIt = this.filteredArgs().iterator();
            while (argsIt.hasNext()) {
                sb.append(argsIt.next().prettyPrint(indent));
                if (!argsIt.hasNext()) continue;
                sb.append(' ').append(opString).append(' ');
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static String printOp(String o) {
        if (o.equals(CONJ)) {
            return "^";
        }
        if (o.equals(DISJ)) {
            return "v";
        }
        if (o.equals(XOR)) {
            return "v_";
        }
        if (o.equals(NEG)) {
            return "~";
        }
        if (o.equals(OPT)) {
            return "?";
        }
        return o;
    }

    private List<LF> filteredArgs() {
        String featsToShow = Grammar.theGrammar.prefs.featsToShow;
        if (featsToShow.length() == 0) {
            return this._args;
        }
        ArrayList<LF> retval = new ArrayList<LF>(this._args.size());
        for (LF arg : this._args) {
            String attr = null;
            if (arg instanceof SatOp && HyloHelper.isAttrPred(arg)) {
                attr = HyloHelper.getRel(arg);
            } else if (arg instanceof Diamond && HyloHelper.isAttr(arg)) {
                attr = ((Diamond)arg).getMode().toString();
            }
            if (attr != null && featsToShow.indexOf(attr) == -1) continue;
            retval.add(arg);
        }
        return retval;
    }

    public int hashCode() {
        int retval = this._name.hashCode();
        Iterator<LF> it = this._args.iterator();
        while (it.hasNext()) {
            retval += it.next().hashCode();
        }
        return retval;
    }

    @Override
    public int hashCode(TObjectIntHashMap varMap) {
        int retval = this._name.hashCode();
        for (LF arg : this._args) {
            retval += arg.hashCode(varMap);
        }
        return retval;
    }

    @Override
    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Op op2 = (Op)obj;
        if (!this._name.equals(op2._name)) {
            return false;
        }
        if (this._args.size() != op2._args.size()) {
            return false;
        }
        for (int i = 0; i < this._args.size(); ++i) {
            LF arg2;
            LF arg = this._args.get(i);
            if (arg.equals(arg2 = op2._args.get(i), varMap, varMap2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element toXml() {
        Element retval = new Element("op");
        retval.setAttribute("name", this._name);
        for (int i = 0; i < this._args.size(); ++i) {
            LF arg = this._args.get(i);
            Element argElt = arg.toXml();
            retval.addContent((Content)argElt);
        }
        return retval;
    }
}

