/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.LexDependency;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureMap;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.util.TrieMap;

public class LexDepFeatureExtractor
implements FeatureExtractor {
    public static final String PREFIX = "ld";
    public static final String HEAD_PRECEDES_DEP = "hpd";
    public static final String DEP_PRECEDES_HEAD = "dph";
    public static final String LEFT_SIBS_PRECEDENCE = "lsp";
    public static final String RIGHT_SIBS_PRECEDENCE = "rsp";
    public static final String DEF = "def1";
    public static final String INDEF = "def0";
    public static final String CLASS_PRO = "PRO";
    public static final String CLASS_COLOR = "COLOR";
    public static final String CLASS_HYPH = "HYPH";
    public static final String CLASS_CAP = "CAP";
    public static final String CLASS_NIL = "NIL";
    public boolean includeComplexityFeats = false;
    public static final String HAS_V = "1v";
    public static final String NO_V = "0v";
    public static final String HAS_P = "1p";
    public static final String NO_P = "0p";
    public boolean includeShortLong = false;
    public static final String SHORT_LONG_ORDER = "sl";
    public static final String LONG_SHORT_ORDER = "ls";
    public boolean includeDepLen = true;
    public static final String DEPLEN = "$deplen";
    protected Alphabet alphabet = null;
    protected FeatureMap currentMap = null;
    protected Sign currentSign = null;
    protected Sign[] currentInputs = null;
    protected LexDependency currentDep = null;
    protected int currentHeadIndex = -1;
    protected int currentDepIndex = -1;
    protected LexDependency currentSib = null;
    protected int currentSibIndex = -1;
    protected String currentHeadBroadPOS = null;
    protected String currentHeadDepOrder = null;
    protected String currentSibsPrecedence = null;
    protected boolean currentDepPrecedesSib = false;
    protected Sign currentDepSign = null;
    protected Sign currentSibSign = null;
    protected PhraseLengths currentDepLengths = null;
    protected PhraseLengths currentSibLengths = null;
    protected PhraseLengths currentLengthsDiff = null;
    protected List<List<TrieMap.KeyExtractor<String>>> depOrderExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<List<TrieMap.KeyExtractor<String>>> sibsOrderExtractors = new ArrayList<List<TrieMap.KeyExtractor<String>>>();
    protected List<ConditionalLazyExtractor> sibsOrderCondExtractors = new ArrayList<ConditionalLazyExtractor>();
    protected List<ConditionalLazyExtractor> sibsComplexityOrderCondExtractors = new ArrayList<ConditionalLazyExtractor>();
    protected List<ConditionalLazyEvaluator> shortLongCondEvaluators = new ArrayList<ConditionalLazyEvaluator>();
    protected List<String> depLenKeys = new ArrayList<String>(1);
    protected Alphabet.Feature depLenFeat = null;
    protected Set<String> colors = this.defaultColors();
    protected String[] suffixClasses = this.defaultSuffixClasses();
    protected WeakHashMap<Word, String> cachedWordClasses = new WeakHashMap();

    public static String sibPrecedenceForDep(String depConst) {
        return depConst == DEP_PRECEDES_HEAD ? LEFT_SIBS_PRECEDENCE : RIGHT_SIBS_PRECEDENCE;
    }

    public LexDepFeatureExtractor() {
        this.depOrderExtractors.add(this.head_dep_order_words());
        this.depOrderExtractors.add(this.head_dep_order_pos());
        this.depOrderExtractors.add(this.head_dep_order_word_pos());
        this.depOrderExtractors.add(this.head_dep_order_pos_word());
        this.sibsOrderExtractors.add(this.sibs_precedence_words());
        this.sibsOrderExtractors.add(this.sibs_precedence_word_pos());
        this.sibsOrderExtractors.add(this.sibs_precedence_pos_word());
        this.sibsOrderCondExtractors.add(this.sibs_precedence_pos());
        this.sibsOrderExtractors.add(this.sibs_precedence_word_class());
        this.sibsOrderExtractors.add(this.sibs_precedence_class_word());
        this.sibsOrderCondExtractors.add(this.sibs_precedence_class());
        this.sibsOrderCondExtractors.add(this.sibs_precedence_rels());
        this.sibsOrderCondExtractors.add(this.sibs_precedence_defs());
        this.sibsComplexityOrderCondExtractors.add(this.sibs_precedence_verbs());
        this.sibsComplexityOrderCondExtractors.add(this.sibs_precedence_puncts());
        this.shortLongCondEvaluators.add(this.short_long_words());
        this.depLenKeys.add(DEPLEN);
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public FeatureVector extractFeatures(Sign sign, boolean complete) {
        this.addFeatures(sign, complete);
        return this.getFeatureMap(sign);
    }

    protected void addFeatures(Sign sign, boolean complete) {
        if (this.getFeatureMap(sign) != null) {
            return;
        }
        if (sign.isLexical()) {
            this.currentSign = sign;
            this.currentMap = new FeatureMap(0);
        } else {
            Sign[] inputs = sign.getDerivationHistory().getInputs();
            for (Sign child : inputs) {
                this.addFeatures(child, false);
            }
            this.currentSign = sign;
            this.currentInputs = inputs;
            if (inputs.length == 1) {
                this.currentMap = new FeatureMap(this.getFeatureMap(inputs[0]));
            } else if (inputs.length == 2) {
                this.currentMap = new FeatureMap(this.getFeatureMap(inputs[0]), this.getFeatureMap(inputs[1]));
            }
            Iterator<LexDependency> iterator = sign.getFilledDeps().iterator();
            while (iterator.hasNext()) {
                Alphabet.Feature f;
                LexDependency dep;
                this.currentDep = dep = (LexDependency)iterator.next();
                this.currentHeadBroadPOS = this.getHeadBroadPOS(dep);
                this.setDepIndexes(dep);
                this.currentHeadDepOrder = this.getHeadDepOrder();
                this.inc(this.depOrderExtractors);
                if (this.includeDepLen && (f = this.getDepLenFeat()) != null) {
                    this.currentMap.add(f, Float.valueOf(this.depLen()));
                }
                Iterator<LexDependency> iterator2 = sign.getSiblingFilledDeps().iterator();
                while (iterator2.hasNext()) {
                    LexDependency sib;
                    this.currentSib = sib = iterator2.next();
                    if (dep.lexHead != sib.lexHead) continue;
                    this.setSibIndex(sib);
                    if (this.currentHeadDepOrder != this.getHeadSibOrder()) continue;
                    this.currentSibsPrecedence = LexDepFeatureExtractor.sibPrecedenceForDep(this.currentHeadDepOrder);
                    this.currentDepPrecedesSib = this.depPrecedesSib();
                    this.inc(this.sibsOrderExtractors);
                    this.incCond(this.sibsOrderCondExtractors);
                    if (!this.includeComplexityFeats && !this.includeShortLong) continue;
                    this.setLengthsDiff();
                    if (this.currentLengthsDiff == null) continue;
                    if (this.includeComplexityFeats) {
                        this.incCond(this.sibsComplexityOrderCondExtractors);
                    }
                    if (!this.includeShortLong) continue;
                    this.addCond(this.shortLongCondEvaluators);
                }
            }
        }
        this.storeFeatureMap(sign);
    }

    protected void storeFeatureMap(Sign sign) {
        sign.addData(new FeatureMapWrapper(this.currentMap));
    }

    protected FeatureMap getFeatureMap(Sign sign) {
        FeatureMapWrapper fmw = (FeatureMapWrapper)sign.getData(FeatureMapWrapper.class);
        return fmw != null ? fmw.featureMap : null;
    }

    protected void inc(List<List<TrieMap.KeyExtractor<String>>> extractors) {
        for (List<TrieMap.KeyExtractor<String>> lazyExtractor : extractors) {
            Alphabet.Feature f = this.alphabet.indexLazy(lazyExtractor);
            if (f == null) continue;
            this.currentMap.inc(f);
        }
    }

    protected void incCond(List<ConditionalLazyExtractor> condExtractors) {
        for (ConditionalLazyExtractor condExtractor : condExtractors) {
            Alphabet.Feature f;
            if (!condExtractor.test() || (f = this.alphabet.indexLazy(condExtractor.lazyExtractor)) == null) continue;
            this.currentMap.inc(f);
        }
    }

    protected void addCond(List<ConditionalLazyEvaluator> condEvaluators) {
        for (ConditionalLazyEvaluator condEvaluator : condEvaluators) {
            Alphabet.Feature f;
            if (!condEvaluator.test() || (f = this.alphabet.indexLazy(condEvaluator.lazyExtractor)) == null) continue;
            this.currentMap.add(f, Float.valueOf(condEvaluator.eval()));
        }
    }

    private String getHeadBroadPOS(LexDependency dep) {
        String pos;
        String retval = pos = dep.lexHead.getPOS();
        if (pos.length() > 2) {
            retval = pos.substring(0, 2).intern();
        }
        return retval;
    }

    private void setDepIndexes(LexDependency dep) {
        this.currentHeadIndex = this.currentSign.wordIndex(dep.lexHead);
        this.currentDepIndex = this.currentSign.wordIndex(dep.lexDep);
        this.currentDepSign = this.currentSign.getSignHeadedByDep(dep);
    }

    private String getHeadDepOrder() {
        return this.currentHeadIndex < this.currentDepIndex ? HEAD_PRECEDES_DEP : DEP_PRECEDES_HEAD;
    }

    private void setSibIndex(LexDependency sib) {
        this.currentSibIndex = this.currentSign.wordIndex(sib.lexDep);
        this.currentSibSign = this.currentSign.getSignHeadedByDep(sib);
    }

    private String getHeadSibOrder() {
        return this.currentHeadIndex < this.currentSibIndex ? HEAD_PRECEDES_DEP : DEP_PRECEDES_HEAD;
    }

    private boolean depPrecedesSib() {
        return this.currentDepIndex < this.currentSibIndex;
    }

    public DefiniteNP getDefiniteNP(Sign sign) {
        DefiniteNP defNP = (DefiniteNP)sign.getData(DefiniteNP.class);
        if (defNP != null) {
            return defNP;
        }
        Boolean def = null;
        Sign npSign = this.getSignOrChildSignAsNP(sign);
        if (npSign != null) {
            def = Boolean.TRUE;
            Nominal npNom = npSign.getCategory().getIndexNominal();
            List<SatOp> semFeats = HyloHelper.getSemFeatsForHead(npNom, npSign.getCategory().getLF());
            for (SatOp feat : semFeats) {
                if (!this.isIndefFeat(feat)) continue;
                def = Boolean.FALSE;
                break;
            }
            if (def.booleanValue()) {
                ArrayList<LexDependency> allDeps = new ArrayList<LexDependency>(5);
                allDeps.addAll(npSign.getFilledDeps());
                allDeps.addAll(npSign.getSiblingFilledDeps());
                for (LexDependency dep : allDeps) {
                    if (!this.isIndefDep(dep)) continue;
                    def = Boolean.FALSE;
                    break;
                }
            }
        }
        defNP = new DefiniteNP(def);
        sign.addData(defNP);
        return defNP;
    }

    protected Sign getSignOrChildSignAsNP(Sign sign) {
        if (this.isNP(sign)) {
            return sign;
        }
        if (sign.isLexical()) {
            return null;
        }
        Sign[] inputs = sign.getDerivationHistory().getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            if (!this.isNP(inputs[i])) continue;
            return inputs[i];
        }
        return null;
    }

    protected boolean isNP(Sign sign) {
        Category cat = sign.getCategory();
        if (!(cat instanceof AtomCat)) {
            return false;
        }
        AtomCat ac = (AtomCat)cat;
        return ac.getType().equals("np");
    }

    protected boolean isIndefFeat(SatOp feat) {
        return HyloHelper.getRel(feat).equals("det") && "nil".equals(HyloHelper.getVal(feat));
    }

    protected boolean isIndefDep(LexDependency dep) {
        String form;
        return dep.rel.equalsIgnoreCase("Det") && ((form = dep.lexDep.getWordForm()) == "a" || form == "an" || form == "any" || form == "some");
    }

    public boolean defDifference(Sign sign1, Sign sign2) {
        DefiniteNP defNP1 = this.getDefiniteNP(sign1);
        if (defNP1.def == null) {
            return false;
        }
        DefiniteNP defNP2 = this.getDefiniteNP(sign2);
        if (defNP2.def == null) {
            return false;
        }
        return defNP1.def != defNP2.def;
    }

    public String defConstant(DefiniteNP defNP) {
        return defNP.def != false ? DEF : INDEF;
    }

    public PhraseLengths getPhraseLengths(Sign sign) {
        PhraseLengths lengths = (PhraseLengths)sign.getData(PhraseLengths.class);
        if (lengths != null) {
            return lengths;
        }
        int wordlen = 0;
        int punctlen = 0;
        int verblen = 0;
        if (sign.isLexical()) {
            for (Word w : sign.getWords()) {
                ++wordlen;
                if (this.isPunct(w)) {
                    ++punctlen;
                }
                if (!this.isVerb(w)) continue;
                ++verblen;
            }
        } else {
            Sign[] inputs = sign.getDerivationHistory().getInputs();
            for (int i = 0; i < inputs.length; ++i) {
                PhraseLengths lengthsI = this.getPhraseLengths(inputs[i]);
                wordlen += lengthsI.wordlen;
                punctlen += lengthsI.punctlen;
                verblen += lengthsI.punctlen;
            }
        }
        lengths = new PhraseLengths(wordlen, punctlen, verblen);
        sign.addData(lengths);
        return lengths;
    }

    protected boolean isPunct(Word word) {
        String form = word.getForm();
        return form == "," || form == "--" || form == ";" || form == ":";
    }

    protected boolean isVerb(Word word) {
        String pos = word.getPOS();
        return pos == "VBD" || pos == "VBP" || pos == "VBZ";
    }

    protected void setLengthsDiff() {
        this.currentLengthsDiff = null;
        this.currentDepLengths = null;
        this.currentSibLengths = null;
        if (this.currentDepSign == null || this.currentSibSign == null) {
            return;
        }
        this.currentDepLengths = this.getPhraseLengths(this.currentDepSign);
        this.currentSibLengths = this.getPhraseLengths(this.currentSibSign);
        PhraseLengths pl1 = this.currentDepPrecedesSib ? this.currentDepLengths : this.currentSibLengths;
        PhraseLengths pl2 = this.currentDepPrecedesSib ? this.currentSibLengths : this.currentDepLengths;
        this.currentLengthsDiff = new PhraseLengths(pl2.wordlen - pl1.wordlen, pl2.punctlen - pl1.punctlen, pl2.verblen - pl1.verblen);
    }

    protected Alphabet.Feature getDepLenFeat() {
        if (this.depLenFeat == null) {
            this.depLenFeat = this.alphabet.index(this.depLenKeys);
        }
        return this.depLenFeat;
    }

    protected int depLen() {
        List<Word> words = this.currentSign.getWords();
        int min = Math.min(this.currentHeadIndex, this.currentDepIndex);
        int max = Math.max(this.currentHeadIndex, this.currentDepIndex);
        int count = 0;
        for (int i = min + 1; i < max; ++i) {
            Word w = words.get(i);
            if (this.isPunct(w)) continue;
            ++count;
        }
        return count;
    }

    protected String getWordClass(Word word) {
        String retval = this.cachedWordClasses.get(word);
        if (retval != null) {
            return retval;
        }
        String wClass = word.getSemClass();
        if (wClass != null) {
            return this.updateCachedWordClasses(word, wClass);
        }
        if (this.isPro(word)) {
            return this.updateCachedWordClasses(word, CLASS_PRO);
        }
        String form = word.getForm();
        if (this.colors.contains(form)) {
            return this.updateCachedWordClasses(word, CLASS_COLOR);
        }
        String suffix = this.getSuffix(form);
        if (suffix != null) {
            return this.updateCachedWordClasses(word, suffix);
        }
        if (form.indexOf(45) >= 0) {
            return this.updateCachedWordClasses(word, CLASS_HYPH);
        }
        if (Character.isUpperCase(form.charAt(0))) {
            return this.updateCachedWordClasses(word, CLASS_CAP);
        }
        return this.updateCachedWordClasses(word, CLASS_NIL);
    }

    protected boolean isPro(Word word) {
        return word.getPOS().startsWith("PR");
    }

    public void setColorWords(Set<String> colorWords) {
        this.colors = colorWords;
    }

    protected Set<String> defaultColors() {
        String[] colors = new String[]{"black", "blue", "brown", "gray", "grey", "green", "orange", "pink", "purple", "red", "white", "yellow"};
        return new HashSet<String>(Arrays.asList(colors));
    }

    protected String[] defaultSuffixClasses() {
        return new String[]{"ancy", "aphy", "arch", "crat", "gram", "less", "logy", "ness", "nomy", "ship", "some", "sque", "tude", "ade", "age", "ant", "aph", "ary", "ast", "ate", "ble", "dom", "ent", "est", "ful", "ian", "ile", "ion", "ing", "ish", "ism", "ist", "ise", "ite", "ium", "ive", "ize", "nce", "oid", "ory", "ose", "ote", "ous", "sig", "ure", "ac", "al", "an", "cy", "ed", "en", "er", "fy", "ic", "le", "ly", "or", "se", "sy", "ty", "y"};
    }

    public void setSuffixClasses(String[] suffixes) {
        this.suffixClasses = suffixes;
    }

    protected String getSuffix(String form) {
        for (int i = 0; i < this.suffixClasses.length; ++i) {
            String suff = this.suffixClasses[i];
            if (form.length() <= suff.length() || !form.endsWith(suff)) continue;
            return suff;
        }
        return null;
    }

    protected String updateCachedWordClasses(Word word, String wordClass) {
        this.cachedWordClasses.put(word, wordClass);
        return wordClass;
    }

    private void add_prefix(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.PREFIX;
            }
        });
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentHeadBroadPOS;
            }
        });
    }

    private void add_head_dep_order(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentHeadDepOrder;
            }
        });
    }

    private void add_rel(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDep.rel.intern();
            }
        });
    }

    private void add_head_dep_order_common(List<TrieMap.KeyExtractor<String>> retval) {
        this.add_prefix(retval);
        this.add_head_dep_order(retval);
        this.add_rel(retval);
    }

    private void add_head_word(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDep.lexHead.getWordForm();
            }
        });
    }

    private void add_head_pos(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDep.lexHead.getPOS();
            }
        });
    }

    private void add_dep_word(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDep.lexDep.getWordForm();
            }
        });
    }

    private void add_dep_pos(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDep.lexDep.getPOS();
            }
        });
    }

    private void add_sibs_precedence(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentSibsPrecedence;
            }
        });
    }

    private void add_sibs_precedence_common(List<TrieMap.KeyExtractor<String>> retval) {
        this.add_prefix(retval);
        this.add_sibs_precedence(retval);
    }

    private void add_sibs_word1(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.currentDep.lexDep.getWordForm() : LexDepFeatureExtractor.this.currentSib.lexDep.getWordForm();
            }
        });
    }

    private void add_sibs_word2(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.currentSib.lexDep.getWordForm() : LexDepFeatureExtractor.this.currentDep.lexDep.getWordForm();
            }
        });
    }

    private void add_sibs_pos1(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.currentDep.lexDep.getPOS() : LexDepFeatureExtractor.this.currentSib.lexDep.getPOS();
            }
        });
    }

    private void add_sibs_pos2(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.currentSib.lexDep.getPOS() : LexDepFeatureExtractor.this.currentDep.lexDep.getPOS();
            }
        });
    }

    private void add_sibs_class1(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                Sign first = LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.currentDep.lexDep : LexDepFeatureExtractor.this.currentSib.lexDep;
                return LexDepFeatureExtractor.this.getWordClass(first.getWords().get(0));
            }
        });
    }

    private void add_sibs_class2(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                Sign second = LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.currentSib.lexDep : LexDepFeatureExtractor.this.currentDep.lexDep;
                return LexDepFeatureExtractor.this.getWordClass(second.getWords().get(0));
            }
        });
    }

    private void add_sibs_rel1(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.currentDep.rel.intern() : LexDepFeatureExtractor.this.currentSib.rel.intern();
            }
        });
    }

    private void add_sibs_rel2(List<TrieMap.KeyExtractor<String>> retval) {
        retval.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.currentSib.rel.intern() : LexDepFeatureExtractor.this.currentDep.rel.intern();
            }
        });
    }

    private List<TrieMap.KeyExtractor<String>> head_dep_order_words() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_head_dep_order_common(retval);
        this.add_head_word(retval);
        this.add_dep_word(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> head_dep_order_pos() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_head_dep_order_common(retval);
        this.add_head_pos(retval);
        this.add_dep_pos(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> head_dep_order_word_pos() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_head_dep_order_common(retval);
        this.add_head_word(retval);
        this.add_dep_pos(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> head_dep_order_pos_word() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_head_dep_order_common(retval);
        this.add_head_pos(retval);
        this.add_dep_word(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> sibs_precedence_words() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_sibs_precedence_common(retval);
        this.add_sibs_word1(retval);
        this.add_sibs_word2(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> sibs_precedence_word_pos() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_sibs_precedence_common(retval);
        this.add_sibs_word1(retval);
        this.add_sibs_pos2(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> sibs_precedence_pos_word() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_sibs_precedence_common(retval);
        this.add_sibs_pos1(retval);
        this.add_sibs_word2(retval);
        return retval;
    }

    private ConditionalLazyExtractor sibs_precedence_pos() {
        ConditionalLazyExtractor retval = new ConditionalLazyExtractor(){

            @Override
            boolean test() {
                return LexDepFeatureExtractor.this.currentDep.lexDep.getPOS() != LexDepFeatureExtractor.this.currentSib.lexDep.getPOS();
            }
        };
        this.add_sibs_precedence_common(retval.lazyExtractor);
        this.add_sibs_pos1(retval.lazyExtractor);
        this.add_sibs_pos2(retval.lazyExtractor);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> sibs_precedence_word_class() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_sibs_precedence_common(retval);
        this.add_sibs_word1(retval);
        this.add_sibs_class2(retval);
        return retval;
    }

    private List<TrieMap.KeyExtractor<String>> sibs_precedence_class_word() {
        ArrayList<TrieMap.KeyExtractor<String>> retval = new ArrayList<TrieMap.KeyExtractor<String>>(5);
        this.add_sibs_precedence_common(retval);
        this.add_sibs_class1(retval);
        this.add_sibs_word2(retval);
        return retval;
    }

    private ConditionalLazyExtractor sibs_precedence_class() {
        ConditionalLazyExtractor retval = new ConditionalLazyExtractor(){

            @Override
            boolean test() {
                return LexDepFeatureExtractor.this.getWordClass(LexDepFeatureExtractor.this.currentDep.lexDep.getWords().get(0)) != LexDepFeatureExtractor.this.getWordClass(LexDepFeatureExtractor.this.currentSib.lexDep.getWords().get(0));
            }
        };
        this.add_sibs_precedence_common(retval.lazyExtractor);
        this.add_sibs_class1(retval.lazyExtractor);
        this.add_sibs_class2(retval.lazyExtractor);
        return retval;
    }

    private ConditionalLazyExtractor sibs_precedence_rels() {
        ConditionalLazyExtractor retval = new ConditionalLazyExtractor(){

            @Override
            boolean test() {
                return !LexDepFeatureExtractor.this.currentDep.rel.equals(LexDepFeatureExtractor.this.currentSib.rel);
            }
        };
        this.add_sibs_precedence_common(retval.lazyExtractor);
        this.add_sibs_rel1(retval.lazyExtractor);
        this.add_sibs_rel2(retval.lazyExtractor);
        return retval;
    }

    private ConditionalLazyExtractor sibs_precedence_defs() {
        ConditionalLazyExtractor retval = new ConditionalLazyExtractor(){

            @Override
            boolean test() {
                if (LexDepFeatureExtractor.this.currentDepSign == null || LexDepFeatureExtractor.this.currentSibSign == null) {
                    return false;
                }
                return LexDepFeatureExtractor.this.defDifference(LexDepFeatureExtractor.this.currentDepSign, LexDepFeatureExtractor.this.currentSibSign);
            }
        };
        this.add_sibs_precedence_common(retval.lazyExtractor);
        retval.lazyExtractor.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.defConstant(LexDepFeatureExtractor.this.getDefiniteNP(LexDepFeatureExtractor.this.currentDepSign)) : LexDepFeatureExtractor.this.defConstant(LexDepFeatureExtractor.this.getDefiniteNP(LexDepFeatureExtractor.this.currentSibSign));
            }
        });
        retval.lazyExtractor.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentDepPrecedesSib ? LexDepFeatureExtractor.this.defConstant(LexDepFeatureExtractor.this.getDefiniteNP(LexDepFeatureExtractor.this.currentSibSign)) : LexDepFeatureExtractor.this.defConstant(LexDepFeatureExtractor.this.getDefiniteNP(LexDepFeatureExtractor.this.currentDepSign));
            }
        });
        return retval;
    }

    private ConditionalLazyExtractor sibs_precedence_verbs() {
        ConditionalLazyExtractor retval = new ConditionalLazyExtractor(){

            @Override
            boolean test() {
                return LexDepFeatureExtractor.this.currentLengthsDiff.verblen != 0 && (LexDepFeatureExtractor.this.currentDepLengths.verblen == 0 || LexDepFeatureExtractor.this.currentSibLengths.verblen == 0);
            }
        };
        this.add_sibs_precedence_common(retval.lazyExtractor);
        retval.lazyExtractor.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentLengthsDiff.verblen > 0 ? LexDepFeatureExtractor.NO_V : LexDepFeatureExtractor.HAS_V;
            }
        });
        retval.lazyExtractor.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentLengthsDiff.verblen > 0 ? LexDepFeatureExtractor.HAS_V : LexDepFeatureExtractor.NO_V;
            }
        });
        return retval;
    }

    private ConditionalLazyExtractor sibs_precedence_puncts() {
        ConditionalLazyExtractor retval = new ConditionalLazyExtractor(){

            @Override
            boolean test() {
                return LexDepFeatureExtractor.this.currentLengthsDiff.punctlen != 0 && (LexDepFeatureExtractor.this.currentDepLengths.punctlen == 0 || LexDepFeatureExtractor.this.currentSibLengths.punctlen == 0);
            }
        };
        this.add_sibs_precedence_common(retval.lazyExtractor);
        retval.lazyExtractor.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentLengthsDiff.punctlen > 0 ? LexDepFeatureExtractor.NO_P : LexDepFeatureExtractor.HAS_P;
            }
        });
        retval.lazyExtractor.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentLengthsDiff.punctlen > 0 ? LexDepFeatureExtractor.HAS_P : LexDepFeatureExtractor.NO_P;
            }
        });
        return retval;
    }

    private ConditionalLazyEvaluator short_long_words() {
        ConditionalLazyEvaluator retval = new ConditionalLazyEvaluator(){

            @Override
            boolean test() {
                return LexDepFeatureExtractor.this.currentLengthsDiff.wordlen != 0;
            }

            @Override
            float eval() {
                return Math.abs(LexDepFeatureExtractor.this.currentLengthsDiff.wordlen);
            }
        };
        this.add_sibs_precedence_common(retval.lazyExtractor);
        retval.lazyExtractor.add(new TrieMap.KeyExtractor<String>(){

            @Override
            public String getKey() {
                return LexDepFeatureExtractor.this.currentLengthsDiff.wordlen > 0 ? LexDepFeatureExtractor.SHORT_LONG_ORDER : LexDepFeatureExtractor.LONG_SHORT_ORDER;
            }
        });
        return retval;
    }

    public static class PhraseLengths {
        public int wordlen;
        public int punctlen;
        public int verblen;

        public PhraseLengths(int wordlen, int punctlen, int verblen) {
            this.wordlen = wordlen;
            this.punctlen = punctlen;
            this.verblen = verblen;
        }

        public String toString() {
            return " wordlen: " + this.wordlen + " punctlen: " + this.punctlen + " verblen: " + this.verblen;
        }
    }

    public static class DefiniteNP {
        public Boolean def;

        public DefiniteNP(Boolean def) {
            this.def = def;
        }

        public String toString() {
            return "defNP: " + this.def;
        }
    }

    public static class FeatureMapWrapper {
        public FeatureMap featureMap;

        public FeatureMapWrapper(FeatureMap featureMap) {
            this.featureMap = featureMap;
        }
    }

    public static abstract class ConditionalLazyEvaluator
    extends ConditionalLazyExtractor {
        abstract float eval();
    }

    public static abstract class ConditionalLazyExtractor {
        List<TrieMap.KeyExtractor<String>> lazyExtractor = new ArrayList<TrieMap.KeyExtractor<String>>(5);

        abstract boolean test();
    }
}

