/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammar;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import opennlp.ccg.grammar.RuleGroup;
import opennlp.ccg.grammar.Types;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Lexicon;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.ParseException;
import opennlp.ccg.parse.Parser;
import opennlp.ccg.realize.Realizer;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.util.DisplayPrefs;
import opennlp.ccg.util.Pair;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class Grammar {
    public final Lexicon lexicon;
    public final RuleGroup rules;
    public final Types types;
    public final Set<String> supertagFeatures = new HashSet<String>();
    public final URL[] fromXmlTransforms;
    public final URL[] toXmlTransforms;
    public DisplayPrefs prefs = new DisplayPrefs();
    public static Grammar theGrammar;
    private String grammarName = null;
    private Parser parser = null;
    private SAXParserFactory spf = null;
    private static SAXTransformerFactory stf;
    private Transformer transformer = null;
    private Templates[] fromXmlTemplates = null;
    private Templates[] toXmlTemplates = null;
    private Transformer apmlTransformer = null;
    public static final String[] pitchAccents;
    private static Set<String> pitchAccentsSet;
    public static final String[] boundaryTones;
    private static Set<String> boundaryTonesSet;

    public Grammar(String filename) throws IOException {
        this(new File(filename).toURI().toURL());
    }

    public Grammar(URL url) throws IOException {
        this(url, false);
    }

    public Grammar(URL url, boolean ignoreCombos) throws IOException {
        Element toXmlElt;
        Element typesElt;
        String feats;
        Document doc;
        theGrammar = this;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(url);
        }
        catch (JDOMException jde) {
            throw (IOException)new IOException().initCause(jde);
        }
        Element root = doc.getRootElement();
        this.grammarName = root.getAttributeValue("name");
        Element supertagsElt = root.getChild("supertags");
        if (supertagsElt != null && (feats = supertagsElt.getAttributeValue("feats")) != null) {
            String[] names = feats.split("\\s+");
            for (int i = 0; i < names.length; ++i) {
                this.supertagFeatures.add(names[i]);
            }
        }
        if (this.supertagFeatures.isEmpty()) {
            this.supertagFeatures.add("form");
            this.supertagFeatures.add("lex");
        }
        Tokenizer tokenizer = null;
        Element tokenizerElt = root.getChild("tokenizer");
        if (tokenizerElt != null) {
            String tokenizerClass = tokenizerElt.getAttributeValue("classname");
            if (tokenizerClass != null) {
                try {
                    tokenizer = (Tokenizer)Class.forName(tokenizerClass).newInstance();
                }
                catch (Exception exc) {
                    throw (IOException)new IOException().initCause(exc);
                }
            } else {
                tokenizer = new DefaultTokenizer();
            }
            String replacementSemClasses = tokenizerElt.getAttributeValue("replacement-sem-classes");
            if (replacementSemClasses != null) {
                String[] semClasses = replacementSemClasses.split("\\s+");
                for (int i = 0; i < semClasses.length; ++i) {
                    tokenizer.addReplacementSemClass(semClasses[i]);
                }
            }
        }
        URL typesUrl = (typesElt = root.getChild("types")) != null ? new URL(url, typesElt.getAttributeValue("file")) : null;
        Element lexiconElt = root.getChild("lexicon");
        boolean openlex = "true".equals(lexiconElt.getAttributeValue("openlex"));
        URL lexiconUrl = new URL(url, lexiconElt.getAttributeValue("file"));
        Element morphElt = root.getChild("morphology");
        URL morphUrl = new URL(url, morphElt.getAttributeValue("file"));
        Element rulesElt = root.getChild("rules");
        URL rulesUrl = new URL(url, rulesElt.getAttributeValue("file"));
        Element fromXmlElt = root.getChild("LF-from-XML");
        if (fromXmlElt != null) {
            List children = fromXmlElt.getChildren();
            this.fromXmlTransforms = new URL[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                Element transformElt = (Element)children.get(i);
                this.fromXmlTransforms[i] = new URL(url, transformElt.getAttributeValue("file"));
            }
        } else {
            this.fromXmlTransforms = new URL[0];
        }
        if ((toXmlElt = root.getChild("LF-to-XML")) != null) {
            List children = toXmlElt.getChildren();
            this.toXmlTransforms = new URL[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                Element transformElt = (Element)children.get(i);
                this.toXmlTransforms[i] = new URL(url, transformElt.getAttributeValue("file"));
            }
        } else {
            this.toXmlTransforms = new URL[0];
        }
        this.types = typesUrl != null ? new Types(typesUrl, this) : new Types(this);
        this.lexicon = tokenizer != null ? new Lexicon(this, tokenizer) : new Lexicon(this);
        this.lexicon.openlex = openlex;
        this.lexicon.init(lexiconUrl, morphUrl);
        this.rules = new RuleGroup(rulesUrl, this);
        if (!ignoreCombos) {
            String combosfile = rulesElt.getAttributeValue("combosfile");
            if (combosfile != null) {
                URL combosUrl = new URL(url, combosfile);
                this.rules.loadSupercatRuleCombos(combosUrl);
            }
            boolean dynamic = combosfile != null;
            String dynamicCombos = rulesElt.getAttributeValue("dynamic-combos");
            if (dynamicCombos != null) {
                dynamic = Boolean.parseBoolean(dynamicCombos);
            }
            this.rules.setDynamicCombos(dynamic);
        }
    }

    public static String convertToFileUrl(String filename) {
        try {
            return new File(filename).toURI().toURL().toString();
        }
        catch (MalformedURLException exc) {
            throw (RuntimeException)new RuntimeException().initCause(exc);
        }
    }

    private void initializeTransformers() throws TransformerConfigurationException {
        if (this.spf == null) {
            this.spf = SAXParserFactory.newInstance();
            this.spf.setNamespaceAware(true);
        }
        if (stf == null) {
            stf = (SAXTransformerFactory)TransformerFactory.newInstance();
            try {
                stf.setAttribute("indent-number", new Integer(2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.transformer == null) {
            this.transformer = stf.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            try {
                this.transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.apmlTransformer == null) {
            InputStream toApmlStr = ClassLoader.getSystemResourceAsStream("opennlp/ccg/grammar/to-apml.xsl");
            this.apmlTransformer = stf.newTransformer(new StreamSource(toApmlStr));
            this.apmlTransformer.setOutputProperty("doctype-system", "apml.dtd");
        }
    }

    private SAXSource fromXmlSetup(InputStream istream) throws IOException {
        try {
            this.initializeTransformers();
            if (this.fromXmlTemplates == null) {
                this.fromXmlTemplates = new Templates[this.fromXmlTransforms.length];
                for (int i = 0; i < this.fromXmlTemplates.length; ++i) {
                    String url = this.fromXmlTransforms[i].toString();
                    this.fromXmlTemplates[i] = stf.newTemplates(new StreamSource(url));
                }
            }
            SAXParser parser = this.spf.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            XMLFilter[] filters = new XMLFilter[this.fromXmlTransforms.length];
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = stf.newXMLFilter(this.fromXmlTemplates[i]);
                if (i == 0) {
                    filters[0].setParent(reader);
                    continue;
                }
                filters[i].setParent(filters[i - 1]);
            }
            XMLReader finalReader = filters.length == 0 ? reader : filters[filters.length - 1];
            return new SAXSource(finalReader, new InputSource(istream));
        }
        catch (ParserConfigurationException pce) {
            throw (IOException)new IOException().initCause(pce);
        }
        catch (SAXException se) {
            throw (IOException)new IOException().initCause(se);
        }
        catch (TransformerConfigurationException tce) {
            throw (IOException)new IOException().initCause(tce);
        }
    }

    public synchronized Document loadFromXml(InputStream istream) throws IOException {
        try {
            SAXSource source = this.fromXmlSetup(istream);
            JDOMResult result = new JDOMResult();
            this.transformer.transform(source, (Result)result);
            return result.getDocument();
        }
        catch (TransformerException exc) {
            throw (IOException)new IOException().initCause(exc);
        }
    }

    public synchronized Document loadFromXml(String filename) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filename));
        Document retval = this.loadFromXml(bis);
        bis.close();
        return retval;
    }

    private SAXSource toXmlSetup(Source source) throws IOException {
        try {
            this.initializeTransformers();
            if (this.toXmlTemplates == null) {
                this.toXmlTemplates = new Templates[this.toXmlTransforms.length];
                for (int i = 0; i < this.toXmlTemplates.length; ++i) {
                    String url = this.toXmlTransforms[i].toString();
                    this.toXmlTemplates[i] = stf.newTemplates(new StreamSource(url));
                }
            }
            SAXParser parser = this.spf.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            XMLFilter[] filters = new XMLFilter[this.toXmlTransforms.length];
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = stf.newXMLFilter(this.toXmlTemplates[i]);
                if (i == 0) {
                    filters[0].setParent(reader);
                    continue;
                }
                filters[i].setParent(filters[i - 1]);
            }
            XMLReader finalReader = filters.length == 0 ? reader : filters[filters.length - 1];
            return new SAXSource(finalReader, SAXSource.sourceToInputSource(source));
        }
        catch (ParserConfigurationException pce) {
            throw (IOException)new IOException().initCause(pce);
        }
        catch (SAXException se) {
            throw (IOException)new IOException().initCause(se);
        }
        catch (TransformerConfigurationException tce) {
            throw (IOException)new IOException().initCause(tce);
        }
    }

    public synchronized void saveToXml(LF lf, String target, String filename) throws IOException {
        File file = new File(filename);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file);
        this.saveToXml(lf, target, out);
        out.close();
    }

    public synchronized void saveToXml(LF lf, String target, OutputStream out) throws IOException {
        Document doc = new Document();
        Element root = new Element("xml");
        doc.setRootElement(root);
        root.addContent((Content)HyloHelper.toXml(lf));
        Element targetElt = new Element("target");
        targetElt.addContent(target);
        root.addContent((Content)targetElt);
        try {
            SAXSource source = this.toXmlSetup((Source)new JDOMSource(doc));
            this.transformer.transform(source, new StreamResult(new OutputStreamWriter(out)));
        }
        catch (TransformerException exc) {
            throw (IOException)new IOException().initCause(exc);
        }
    }

    public synchronized LF transformLF(LF lf) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.saveToXml(lf, "", out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Document doc = this.loadFromXml(in);
        return Realizer.getLfFromDoc(doc);
    }

    public synchronized LF loadLF(Document doc) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializeXml(doc, out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Document doc2 = this.loadFromXml(in);
        return Realizer.getLfFromDoc(doc2);
    }

    public synchronized void serializeXml(Document doc, OutputStream out) throws IOException {
        try {
            this.initializeTransformers();
            JDOMResult result = new JDOMResult();
            this.transformer.transform((Source)new JDOMSource(doc), (Result)result);
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            outputter.output(result.getDocument(), (Writer)new OutputStreamWriter(out));
        }
        catch (TransformerException exc) {
            throw (IOException)new IOException().initCause(exc);
        }
    }

    public synchronized Element makeLfElt(LF lf) throws IOException {
        Document lfDoc = new Document();
        lfDoc.setRootElement(HyloHelper.toXml(lf));
        try {
            SAXSource source = this.toXmlSetup((Source)new JDOMSource(lfDoc));
            JDOMResult result = new JDOMResult();
            this.transformer.transform(source, (Result)result);
            lfDoc = result.getDocument();
        }
        catch (TransformerException exc) {
            throw (IOException)new IOException().initCause(exc);
        }
        return lfDoc.detachRootElement();
    }

    public static boolean isPitchAccent(String s) {
        if (pitchAccentsSet == null) {
            pitchAccentsSet = new HashSet<String>();
            for (int i = 0; i < pitchAccents.length; ++i) {
                pitchAccentsSet.add(pitchAccents[i]);
            }
        }
        return pitchAccentsSet.contains(s);
    }

    public static boolean isBoundaryTone(String s) {
        if (boundaryTonesSet == null) {
            boundaryTonesSet = new HashSet<String>();
            for (int i = 0; i < boundaryTones.length; ++i) {
                boundaryTonesSet.add(boundaryTones[i]);
            }
        }
        return boundaryTonesSet.contains(s);
    }

    public synchronized void saveToApml(Sign sign, String filename) throws IOException {
        File file = new File(filename);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileWriter fw = new FileWriter(file);
        this.saveToApml(sign, fw);
        fw.close();
    }

    public synchronized void saveToApml(Sign sign, Writer writer) throws IOException {
        Document doc = sign.getWordsInXml();
        try {
            this.initializeTransformers();
            JDOMSource source = new JDOMSource(doc);
            this.apmlTransformer.transform((Source)source, new StreamResult(writer));
        }
        catch (TransformerException exc) {
            throw (IOException)new IOException().initCause(exc);
        }
    }

    public List<Word> getParsedWords(String s) {
        if (this.parser == null) {
            this.parser = new Parser(this);
        }
        try {
            this.parser.parse(s);
        }
        catch (ParseException pe) {
            return new ArrayList<Word>(0);
        }
        List<Sign> parses = this.parser.getResult();
        Sign sign = parses.get(0);
        return sign.getWords();
    }

    public final String getName() {
        return this.grammarName;
    }

    public void toMorphXml(List<Word> words, String filename) throws IOException {
        Collections.sort(words);
        XMLOutputter xout = new XMLOutputter();
        xout.setFormat(Format.getPrettyFormat());
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<morph name=\"" + this.grammarName + "\">");
        for (Word w : words) {
            Element e = new Element("entry");
            e.setAttribute("word", w.getForm());
            if (w.getForm() != w.getStem() && w.getStem() != null) {
                e.setAttribute("stem", w.getStem());
            }
            if (w.getPOS() != null) {
                e.setAttribute("pos", w.getPOS());
            }
            if (w.getSemClass() != null) {
                e.setAttribute("class", w.getSemClass());
            }
            xout.output(e, (Writer)out);
            out.println();
        }
        out.println("</morph>");
        out.flush();
        out.close();
    }

    public void toLexiconXml(List<Category> cats, List<String> POSs, String filename) throws IOException {
        HashMap<String, Pair<Category, String>> stagMap = new HashMap<String, Pair<Category, String>>();
        for (int i = 0; i < cats.size(); ++i) {
            Category cat = cats.get(i);
            String pos = POSs.get(i);
            String stag = cat.getSupertag();
            if (stagMap.containsKey(stag)) {
                int j = 1;
                while (stagMap.containsKey(stag + "-" + j)) {
                    ++j;
                }
                stag = stag + "-" + j;
            }
            stagMap.put(stag, new Pair<Category, String>(cat, pos));
        }
        ArrayList keys = new ArrayList(stagMap.keySet());
        Collections.sort(keys);
        XMLOutputter xout = new XMLOutputter();
        xout.setFormat(Format.getPrettyFormat());
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<lexicon name=\"" + this.grammarName + "\">");
        for (String key : keys) {
            Pair p = (Pair)stagMap.get(key);
            Category cat = (Category)p.a;
            String pos = (String)p.b;
            Element fam = new Element("family");
            fam.setAttribute("name", key);
            fam.setAttribute("pos", pos);
            Element ent = new Element("entry");
            ent.setAttribute("name", "1");
            fam.addContent((Content)ent);
            ent.addContent((Content)cat.toXml());
            xout.output(fam, (Writer)out);
            out.println();
        }
        out.println("</lexicon>");
        out.flush();
        out.close();
    }

    static {
        stf = null;
        pitchAccents = new String[]{"H*", "L*", "L+H*", "L*+H", "H*+L", "H+L*"};
        pitchAccentsSet = null;
        boundaryTones = new String[]{"L", "H", "LL%", "HH%", "LH%", "HL%"};
        boundaryTonesSet = null;
    }
}

