/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammar;

import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.grammar.AbstractRule;
import opennlp.ccg.synsem.Arg;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.BasicArg;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.unify.SimpleSubstitution;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import org.jdom.Element;

public class GlueRule
extends AbstractRule {
    private static final long serialVersionUID = 4867141181941895272L;
    private static final Substitution emptySubst = new SimpleSubstitution();
    public static final String resultType = "frag";

    public GlueRule() {
        this._name = "glue";
    }

    @Override
    public Element toXml() {
        throw new RuntimeException("toXml not supported for GlueRule rules");
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public List<Category> applyRule(Category[] inputs) throws UnifyFailure {
        AtomCat ac2;
        if (inputs.length != 2) {
            throw new UnifyFailure();
        }
        if (inputs[1] instanceof AtomCat && (ac2 = (AtomCat)inputs[1]).isFragment() && !ac2.fragCompletion) {
            throw new UnifyFailure();
        }
        ArrayList<Category> results = new ArrayList<Category>(1);
        this._headCats.clear();
        AtomCat ac = new AtomCat(resultType);
        this.appendLFs(inputs[0], inputs[1], ac, emptySubst);
        results.add(ac);
        boolean leftHead = true;
        boolean leftMod = GlueRule.isModifier(inputs[0]);
        boolean rightMod = GlueRule.isModifier(inputs[1]);
        if (inputs[0] instanceof AtomCat && inputs[1] instanceof ComplexCat && !rightMod || leftMod && !rightMod) {
            leftHead = false;
        }
        this._headCats.add(leftHead ? inputs[0] : inputs[1]);
        return results;
    }

    private static boolean isModifier(Category cat) {
        ComplexCat xyCat;
        Arg arg;
        if (cat instanceof ComplexCat && (arg = (xyCat = (ComplexCat)cat).getOuterArg()) instanceof BasicArg) {
            return ((BasicArg)arg).getSlash().isModifier();
        }
        return false;
    }

    public String toString() {
        return "frag|cat cat => frag";
    }
}

