/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammar;

import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.grammar.AbstractRule;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.BasicArg;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.synsem.Dollar;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Slash;
import opennlp.ccg.synsem.TargetCat;
import opennlp.ccg.unify.GFeatStruc;
import opennlp.ccg.unify.GSubstitution;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractTypeRaisingRule
extends AbstractRule {
    private static final long serialVersionUID = 1L;
    protected Slash _upperSlash;
    protected Slash _embeddedSlash;
    protected Category _result;
    protected Category _arg;

    protected AbstractTypeRaisingRule(String name, Slash uslash, Slash eslash, boolean useDollar, Category arg, Category result) {
        this._name = name;
        this._upperSlash = uslash;
        this._upperSlash.setAbility("active");
        this._upperSlash.setModifier(true);
        this._embeddedSlash = eslash;
        this._embeddedSlash.setAbility("active");
        this._arg = arg != null ? arg : new AtomCat("np", new GFeatStruc());
        if (result != null) {
            this._result = result;
            result.getFeatureStructure().setIndex(1);
        } else {
            GFeatStruc resfs = new GFeatStruc();
            resfs.setIndex(1);
            this._result = new AtomCat("s", resfs);
        }
        if (useDollar) {
            Dollar dol = new Dollar("1");
            dol.setIndex(1);
            this._result = new ComplexCat((TargetCat)((AtomCat)this._result), dol);
        }
    }

    public Element toXml(String dir) {
        Element retval = new Element("typeraising");
        retval.setAttribute("dir", dir);
        boolean usesDollar = this._result instanceof ComplexCat && ((ComplexCat)this._result).containsDollarArg();
        retval.setAttribute("useDollar", Boolean.toString(usesDollar));
        if (!(this._arg instanceof AtomCat) || !((AtomCat)this._arg).getType().equals("np")) {
            Element argElt = new Element("arg");
            retval.addContent((Content)argElt);
            argElt.addContent((Content)this._arg.toXml());
        }
        if (!((AtomCat)this._result.getTarget()).getType().equals("s")) {
            Element resultElt = new Element("result");
            retval.addContent((Content)resultElt);
            resultElt.addContent((Content)this._result.getTarget().toXml());
        }
        return retval;
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public List<Category> applyRule(Category[] inputs) throws UnifyFailure {
        if (inputs.length != 1) {
            throw new UnifyFailure();
        }
        return this.apply(inputs[0]);
    }

    protected List<Category> apply(Category input) throws UnifyFailure {
        GSubstitution sub = new GSubstitution();
        Category arg = (Category)this._arg.unify(input, sub);
        sub.condense();
        Category result = this._result.copy();
        UnifyControl.reindex(result);
        if (result instanceof ComplexCat) {
            ComplexCat range = (ComplexCat)result.copy();
            range.add(new BasicArg(this._embeddedSlash, arg));
            ((ComplexCat)result).add(new BasicArg(this._upperSlash, range));
        } else {
            ComplexCat range = new ComplexCat((TargetCat)result.copy(), new BasicArg(this._embeddedSlash, arg));
            result = new ComplexCat((TargetCat)result.copy(), new BasicArg(this._upperSlash, range));
        }
        this._ruleGroup.grammar.lexicon.propagateDistributiveAttrs(result);
        LF inputLF = input.getLF();
        if (inputLF != null) {
            result.setLF(inputLF.copy());
        }
        ArrayList<Category> results = new ArrayList<Category>(1);
        this._headCats.clear();
        results.add(result);
        this._headCats.add(input);
        return results;
    }
}

